/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.LocaleModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.locale.LocaleUtils;
import com.oracle.graal.python.runtime.locale.PythonLocale;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

@CoreFunctions(defineModule="_locale")
public final class LocaleModuleBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinNode>> getNodeFactories() {
        return LocaleModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("LC_ALL", (Object)6);
        this.addBuiltinConstant("LC_COLLATE", (Object)3);
        this.addBuiltinConstant("LC_CTYPE", (Object)0);
        this.addBuiltinConstant("LC_MESSAGES", (Object)5);
        this.addBuiltinConstant("LC_MONETARY", (Object)4);
        this.addBuiltinConstant("LC_NUMERIC", (Object)1);
        this.addBuiltinConstant("LC_TIME", (Object)2);
        this.addBuiltinConstant("CHAR_MAX", (Object)127);
        this.addBuiltinConstant("Error", (Object)PythonBuiltinClassType.ValueError);
        super.initialize(core);
    }

    @Builtin(name="setlocale", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetLocaleNode
    extends PythonBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private static String getCurrent(PythonContext ctx, int category) {
            return LocaleUtils.toPosix(ctx.getCurrentLocale().category(category));
        }

        @CompilerDirectives.TruffleBoundary
        private static String setCurrent(PythonContext ctx, int category, String posixLocaleID, Node nodeForRaise) {
            PythonLocale current = ctx.getCurrentLocale();
            Locale newLocale = LocaleUtils.fromPosix(posixLocaleID, current.category(category));
            if (newLocale == null) {
                throw PRaiseNode.raiseStatic(nodeForRaise, PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_LOCALE_SETTING);
            }
            ctx.setCurrentLocale(current.withCategory(category, newLocale));
            return LocaleUtils.toPosix(newLocale);
        }

        @Specialization
        static TruffleString doGeneric(VirtualFrame frame, Object category, Object posixLocaleID, @Bind Node inliningTarget, @Cached PyLongAsLongNode asLongNode, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.FromJavaStringNode resultAsTruffleStringNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached PRaiseNode raiseNode) {
            long l = asLongNode.execute((Frame)frame, inliningTarget, category);
            if (!SetLocaleNode.isValidCategory(l)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INVALID_LOCALE_CATEGORY);
            }
            TruffleString posixLocaleIDStr = null;
            if (!PGuards.isPNone(posixLocaleID)) {
                try {
                    posixLocaleIDStr = castToStringNode.execute(inliningTarget, posixLocaleID);
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
            }
            PythonContext ctx = PythonContext.get(inliningTarget);
            String result = posixLocaleIDStr != null ? SetLocaleNode.setCurrent(ctx, (int)l, toJavaStringNode.execute((AbstractTruffleString)posixLocaleIDStr), inliningTarget) : SetLocaleNode.getCurrent(ctx, (int)l);
            return resultAsTruffleStringNode.execute(result, PythonUtils.TS_ENCODING);
        }

        static boolean isValidCategory(long l) {
            return 0L <= l && l <= 6L;
        }
    }

    @Builtin(name="localeconv")
    @GenerateNodeFactory
    public static abstract class LocaleConvNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDict localeconv() {
            PythonContext ctx = PythonContext.get(null);
            PythonLanguage language = ctx.getLanguage();
            LinkedHashMap<String, Object> dict = new LinkedHashMap<String, Object>(20);
            PythonLocale currentPythonLocale = ctx.getCurrentLocale();
            Locale numericLocale = currentPythonLocale.category(1);
            NumberFormat numericLocaleNumFormat = NumberFormat.getInstance(numericLocale);
            DecimalFormatSymbols decimalFormatSymbols = LocaleConvNode.getDecimalFormatSymbols(numericLocale, numericLocaleNumFormat);
            dict.put("decimal_point", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getDecimalSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("thousands_sep", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getGroupingSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("grouping", LocaleConvNode.getDecimalFormatGrouping(language, numericLocaleNumFormat));
            Locale monetaryLocale = currentPythonLocale.category(4);
            NumberFormat monetaryNumFormat = NumberFormat.getInstance(monetaryLocale);
            Currency currency = monetaryNumFormat.getCurrency();
            decimalFormatSymbols = LocaleConvNode.getDecimalFormatSymbols(monetaryLocale, monetaryNumFormat);
            dict.put("int_curr_symbol", PythonUtils.toTruffleStringUncached(decimalFormatSymbols.getInternationalCurrencySymbol()));
            dict.put("currency_symbol", PythonUtils.toTruffleStringUncached(decimalFormatSymbols.getCurrencySymbol()));
            dict.put("mon_decimal_point", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getMonetaryDecimalSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("mon_thousands_sep", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getGroupingSeparator(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("mon_grouping", LocaleConvNode.getDecimalFormatGrouping(language, monetaryNumFormat));
            dict.put("positive_sign", "");
            dict.put("negative_sign", TruffleString.fromCodePointUncached((int)decimalFormatSymbols.getMinusSign(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            dict.put("int_frac_digits", currency.getDefaultFractionDigits());
            dict.put("frac_digits", currency.getDefaultFractionDigits());
            dict.put("p_cs_precedes", PNone.NONE);
            dict.put("p_sep_by_space", PNone.NONE);
            dict.put("n_cs_precedes", PNone.NONE);
            dict.put("n_sep_by_space", PNone.NONE);
            dict.put("p_sign_posn", PNone.NONE);
            dict.put("n_sign_posn", PNone.NONE);
            return PFactory.createDictFromMap(language, dict);
        }

        private static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale, NumberFormat numberFormat) {
            DecimalFormatSymbols decimalFormatSymbols;
            if (numberFormat instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            } else {
                decimalFormatSymbols = new DecimalFormatSymbols(locale);
            }
            return decimalFormatSymbols;
        }

        private static PList getDecimalFormatGrouping(PythonLanguage language, NumberFormat numberFormat) {
            if (numberFormat instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                return PFactory.createList(language, new Object[]{decimalFormat.getGroupingSize(), 0});
            }
            return PFactory.createList(language);
        }
    }
}

