/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.charset;

import com.oracle.graal.python.util.PythonUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class PythonRawUnicodeEscapeCharsetEncoder
extends CharsetEncoder {
    protected PythonRawUnicodeEscapeCharsetEncoder(Charset cs) {
        super(cs, 2.0f, 10.0f, new byte[]{63});
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target) {
        block0: while (true) {
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            initialPosition = source.position();
            codePoint = ch = source.get();
            if (Character.isHighSurrogate((char)ch)) {
                if (!source.hasRemaining()) {
                    source.position(initialPosition);
                    return CoderResult.UNDERFLOW;
                }
                low = source.get();
                if (Character.isLowSurrogate(low)) {
                    codePoint = Character.toCodePoint((char)ch, low);
                } else {
                    source.position(source.position() - 1);
                }
            }
            if (codePoint <= 255) {
                target.put((byte)codePoint);
                continue;
            }
            hexString = PythonUtils.formatJString(codePoint <= 65535 ? "\\u%04x" : "\\U%08x", new Object[]{codePoint});
            i = 0;
            while (true) {
                if (i < hexString.length()) ** break;
                continue block0;
                if (!target.hasRemaining()) {
                    source.position(initialPosition);
                    target.position(target.position() - i);
                    return CoderResult.OVERFLOW;
                }
                target.put((byte)hexString.charAt(i));
                ++i;
            }
            break;
        }
    }
}

