-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULLIF(1, 1)
    AS ROUTINE_CATALOG,
  STRIP(SYSCAT.ROUTINES.ROUTINESCHEMA)
    AS ROUTINE_SCHEMA,
  STRIP(SYSCAT.ROUTINES.ROUTINENAME)
    AS ROUTINE_NAME,
  STRIP(SYSCAT.ROUTINES.SPECIFICNAME)
    AS SPECIFIC_NAME,
  CASE WHEN STRIP(SYSCAT.ROUTINES.ORIGIN) = 'E' THEN 'EXTERNAL' ELSE 'SQL' END
    AS ROUTINE_BODY,
  SYSCAT.ROUTINES.TEXT
    AS ROUTINE_DEFINITION
FROM
  SYSCAT.ROUTINES
ORDER BY
  SYSCAT.ROUTINES.ROUTINESCHEMA,
  SYSCAT.ROUTINES.ROUTINENAME
WITH UR  
