/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkShrinkImageFilter_h
#define sitkShrinkImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class ShrinkImageFilter
\brief Reduce the size of an image by an integer factor in each dimension.

ShrinkImageFilter reduces the size of an image by an integer factor in each dimension. The algorithm implemented is a simple subsample. The output image size in each dimension is given by:

outputSize[j] = max( std::floor(inputSize[j]/shrinkFactor[j]), 1 );

NOTE: The physical centers of the input and output will be the same. Because of this, the Origin of the output may not be the same as the Origin of the input. Since this filter produces an image which is a different resolution, origin and with different pixel spacing than its input image, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In particular, this filter overrides ProcessObject::GenerateInputRequestedRegion() and ProcessObject::GenerateOutputInformation() .

This filter is implemented as a multithreaded filter. It provides a DynamicThreadedGenerateData() method for its implementation.
\sa itk::simple::Shrink for the procedural interface
\sa itk::ShrinkImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ShrinkImageFilter : public ImageFilter {
    public:
      using Self = ShrinkImageFilter;

      /** Destructor */
      virtual ~ShrinkImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ShrinkImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
      /** Custom public declarations */
      SITK_RETURN_SELF_TYPE_HEADER SetShrinkFactor( unsigned int s ) { this->m_ShrinkFactors = std::vector<unsigned int>(3, s ); return *this; }

\

      /**
       * Set the shrink factors. Values are clamped to a minimum value of 1. Default is 1 for all dimensions.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetShrinkFactors ( std::vector<unsigned int> ShrinkFactors ) { this->m_ShrinkFactors = std::move(ShrinkFactors); return *this; }

      /**
       * Get the shrink factors.
       */
      std::vector<unsigned int> GetShrinkFactors() const { return this->m_ShrinkFactors; }

      /** Name of this class */
      std::string GetName() const { return std::string ("ShrinkImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_ShrinkFactors{std::vector<unsigned int>(3, 1)};


    };

    /**\
     * \brief Reduce the size of an image by an integer factor in each dimension.
     *
     * This function directly calls the execute method of ShrinkImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ShrinkImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image Shrink ( const Image& image1, std::vector<unsigned int> shrinkFactors = std::vector<unsigned int>(3, 1) );

     /** @} */
}
#endif
