; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s
;

define i16 @load16_shr63(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load16_shr63:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #63
; CHECK-NEXT:    ldrh w0, [x2, x8, lsl #1]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 63
  %arrayidx = getelementptr inbounds i16, ptr %table, i64 %shr
  %0 = load i16, ptr %arrayidx, align 2
  ret i16 %0
}

define i16 @load16_shr2(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load16_shr2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #2
; CHECK-NEXT:    ldrh w0, [x2, x8, lsl #1]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 2
  %arrayidx = getelementptr inbounds i16, ptr %table, i64 %shr
  %0 = load i16, ptr %arrayidx, align 2
  ret i16 %0
}

define i16 @load16_shr1(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load16_shr1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #1
; CHECK-NEXT:    ldrh w0, [x2, x8, lsl #1]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 1
  %arrayidx = getelementptr inbounds i16, ptr %table, i64 %shr
  %0 = load i16, ptr %arrayidx, align 2
  ret i16 %0
}

define i32 @load32_shr63(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load32_shr63:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #63
; CHECK-NEXT:    ldr w0, [x2, x8, lsl #2]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 63
  %arrayidx = getelementptr inbounds i32, ptr %table, i64 %shr
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

define i32 @load32_shr2(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load32_shr2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #2
; CHECK-NEXT:    ldr w0, [x2, x8, lsl #2]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 2
  %arrayidx = getelementptr inbounds i32, ptr %table, i64 %shr
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

define i32 @load32_shr1(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load32_shr1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #1
; CHECK-NEXT:    ldr w0, [x2, x8, lsl #2]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 1
  %arrayidx = getelementptr inbounds i32, ptr %table, i64 %shr
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

define i64 @load64_shr63(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load64_shr63:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #63
; CHECK-NEXT:    ldr x0, [x2, x8, lsl #3]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 63
  %arrayidx = getelementptr inbounds i64, ptr %table, i64 %shr
  %0 = load i64, ptr %arrayidx, align 8
  ret i64 %0
}

define i64 @load64_shr2(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load64_shr2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #2
; CHECK-NEXT:    ldr x0, [x2, x8, lsl #3]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 2
  %arrayidx = getelementptr inbounds i64, ptr %table, i64 %shr
  %0 = load i64, ptr %arrayidx, align 8
  ret i64 %0
}

define i64 @load64_shr1(i64 %a, i64 %b, ptr %table) {
; CHECK-LABEL: load64_shr1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x8, x1, x0
; CHECK-NEXT:    lsr x8, x8, #1
; CHECK-NEXT:    ldr x0, [x2, x8, lsl #3]
; CHECK-NEXT:    ret
entry:
  %mul = mul i64 %b, %a
  %shr = lshr i64 %mul, 1
  %arrayidx = getelementptr inbounds i64, ptr %table, i64 %shr
  %0 = load i64, ptr %arrayidx, align 8
  ret i64 %0
}
