from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, ForeignKey, UniqueConstraint
from sqlalchemy.orm import relationship

from ..base import Base


class CpuInfo(Base):
    __tablename__ = 'cpu_info'
    id = Column(Integer, primary_key=True, index=True)
    core_count = Column(Integer, default=0)
    p_core_count = Column(Integer, default=0)
    p_smt_core_count = Column(Integer, default=0)
    e_core_count = Column(Integer, default=0)
    e_smt_core_count = Column(Integer, default=0)
    report_id = Column(Integer, ForeignKey('report.id'))
    report = relationship('Report', back_populates='cpu_info')

    __table_args__ = (UniqueConstraint("report_id", name="cpu_info_report_id_key"), )


class CpuInfoInDB(BaseModel):
    core_count: int
    p_core_count: int
    p_smt_core_count: int
    e_core_count: int
    e_smt_core_count: int

    class Config:
        from_attributes = True


class CpuInfoCreate(BaseModel):
    core_count: Optional[int]
    p_core_count: Optional[int]
    p_smt_core_count: Optional[int]
    e_core_count: Optional[int]
    e_smt_core_count: Optional[int]

    class Config:
        from_attributes = True
