/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class FileWatcher {
    private long timestamp = -1L;
    private final int POLLING_INTERVAL_SEC = 5;
    private final int POLLING_DELAY_SEC = 0;
    private File file;
    private ScheduledFuture<?> future;
    private ScheduledExecutorService executor;
    private FVEventListener eventListener;

    public FileWatcher(File file, FVEventListener eventListener) {
        this.file = file;
        this.eventListener = eventListener;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void stop() {
        this.future.cancel(false);
    }

    public void start() {
        if (this.executor == null) {
            return;
        }
        this.future = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (FileWatcher.this.future.isCancelled()) {
                    return;
                }
                if (FileWatcher.this.isFileUpdated(FileWatcher.this.file)) {
                    FVEvent updateEvt = new FVEvent(FVEvent.EventType.FILE_CHANGED, null);
                    FileWatcher.this.eventListener.send(updateEvt);
                }
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    private boolean isFileUpdated(File file) {
        if (this.timestamp == -1L) {
            this.timestamp = file.lastModified();
            return false;
        }
        if (this.timestamp != file.lastModified()) {
            this.timestamp = file.lastModified();
            return true;
        }
        return false;
    }
}

