/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.ResponseName;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class QueryName
extends BSimQuery<ResponseName> {
    public ExeSpecifier spec = new ExeSpecifier();
    public String funcname = "";
    public ResponseName nameresponse = null;
    public int maxfunc = 1000;
    public boolean printselfsig = false;
    public boolean printjustexe = false;
    public boolean fillinSigs = true;
    public boolean fillinCallgraph = false;
    public boolean fillinCategories = true;

    public QueryName() {
        super("queryname");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.nameresponse = new ResponseName();
            this.response = this.nameresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        this.spec.saveXml(fwrite);
        fwrite.append("<funcname>");
        if (this.funcname != null) {
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.funcname);
        }
        fwrite.append("</funcname>\n");
        fwrite.append("<maxfunc>");
        fwrite.append(Integer.toString(this.maxfunc));
        fwrite.append("</maxfunc>\n");
        if (this.printselfsig) {
            fwrite.append("<printselfsig>true</printselfsig>\n");
        } else {
            fwrite.append("<printselfsig>false</printselfsig>\n");
        }
        if (this.printjustexe) {
            fwrite.append("<printjustexe>true</printjustexe>\n");
        } else {
            fwrite.append("<printjustexe>false</printjustexe>\n");
        }
        if (this.fillinSigs) {
            fwrite.append("<sigs>true</sigs>\n");
        } else {
            fwrite.append("<sigs>false</sigs>\n");
        }
        if (this.fillinCallgraph) {
            fwrite.append("<callgraph>true</callgraph>\n");
        } else {
            fwrite.append("<callgraph>false</callgraph>\n");
        }
        if (this.fillinCategories) {
            fwrite.append("<categories>true</categories>\n");
        } else {
            fwrite.append("<categories>false</categories>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        this.spec = new ExeSpecifier();
        this.spec.restoreXml(parser);
        parser.start(new String[]{"funcname"});
        this.funcname = parser.end().getText();
        parser.start(new String[]{"maxfunc"});
        this.maxfunc = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"printselfsig"});
        this.printselfsig = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.start(new String[]{"printjustexe"});
        this.printjustexe = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.start(new String[]{"sigs"});
        this.fillinSigs = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.start(new String[]{"callgraph"});
        this.fillinCallgraph = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.start(new String[]{"categories"});
        this.fillinCategories = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.end();
    }
}

