/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.listing.Program;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class NavigationPanel
extends JPanel {
    private MarkerManager manager;
    private Navigatable navigatable;
    private Program program;
    private AddressIndexMap addrMap;

    NavigationPanel(MarkerManager manager) {
        this.manager = manager;
        this.setPreferredSize(new Dimension(16, 1));
        this.init();
    }

    private void init() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) != 0) {
                    NavigationPanel.this.manager.navigateTo(NavigationPanel.this.navigatable, NavigationPanel.this.program, e.getX(), e.getY(), NavigationPanel.this.getViewHeight(), NavigationPanel.this.addrMap);
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintNavigation(g);
    }

    void paintNavigation(Graphics g) {
        this.manager.paintNavigation(this.program, g, this, this.addrMap);
    }

    void setNavigatable(Navigatable navigatable) {
        this.navigatable = navigatable;
    }

    void setProgram(Program program, AddressIndexMap map) {
        this.program = program;
        this.addrMap = map;
    }

    public int getViewHeight() {
        return this.getHeight() - 4;
    }
}

