/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import ghidra.app.plugin.core.strings.StringTrigramIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public record Trigram(int[] codePoints) implements Comparable<Trigram>
{
    private static final String START_OF_STRING = "[^]";
    private static final String END_OF_STRING = "[$]";
    private static final Set<String> META_CHARS = Set.of("[^]", "[$]");
    private static final Map<String, Integer> descriptionToCodePoint = new HashMap<String, Integer>();
    private static final Map<Integer, String> codePointToDescription = new HashMap<Integer, String>();

    public static Trigram of(int cp1, int cp2, int cp3) {
        return new Trigram(new int[]{cp1, cp2, cp3});
    }

    public static Trigram fromStringRep(String s1, String s2, String s3) throws NumberFormatException, IOException {
        return Trigram.of(Trigram.decodeCodePoint(s1), Trigram.decodeCodePoint(s2), Trigram.decodeCodePoint(s3));
    }

    public static StringTrigramIterator iterate(String s) {
        return new StringTrigramIterator(s);
    }

    public String toCharSeq() {
        return Trigram.getCodePointRepresentation(this.codePoints[0]) + Trigram.getCodePointRepresentation(this.codePoints[1]) + Trigram.getCodePointRepresentation(this.codePoints[2]);
    }

    @Override
    public String toString() {
        return this.toCharSeq();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.codePoints);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trigram other = (Trigram)obj;
        return Arrays.equals(this.codePoints, other.codePoints);
    }

    @Override
    public int compareTo(Trigram o) {
        int result = Integer.compare(this.codePoints[0], o.codePoints[0]);
        result = result == 0 ? Integer.compare(this.codePoints[1], o.codePoints[1]) : result;
        result = result == 0 ? Integer.compare(this.codePoints[2], o.codePoints[2]) : result;
        return result;
    }

    private static void mapCP(String desc, int codePoint) {
        descriptionToCodePoint.put(desc, codePoint);
        codePointToDescription.put(codePoint, desc);
    }

    static String getCodePointRepresentation(int codePoint) {
        if (codePoint >= 33 && codePoint <= 126) {
            return Character.toString(codePoint);
        }
        String result = codePointToDescription.get(codePoint);
        if (result != null) {
            return result;
        }
        return codePoint > 0 && codePoint <= 65535 ? "\\u%04X".formatted(codePoint) : "\\U%08X".formatted(codePoint);
    }

    private static int decodeCodePoint(String rep) throws IOException, NumberFormatException {
        if (rep == null || rep.isEmpty()) {
            throw new IOException("Invalid character symbol in model file");
        }
        if (rep.codePointCount(0, rep.length()) == 1) {
            return rep.codePointAt(0);
        }
        if (rep.length() == 3 && META_CHARS.contains(rep)) {
            return 0;
        }
        if (rep.length() == 6 && rep.startsWith("\\u")) {
            return Integer.parseUnsignedInt(rep, 2, 6, 16);
        }
        if (rep.length() == 10 && rep.startsWith("\\U")) {
            return Integer.parseUnsignedInt(rep, 2, 10, 16);
        }
        if (rep.startsWith("[")) {
            Integer codePoint = descriptionToCodePoint.get(rep);
            if (codePoint == null) {
                throw new IOException("Can not parse character " + rep + " in model file");
            }
            return codePoint;
        }
        return rep.codePointAt(0);
    }

    static {
        Trigram.mapCP("[NUL]", 0);
        Trigram.mapCP("[SOH]", 1);
        Trigram.mapCP("[STX]", 2);
        Trigram.mapCP("[ETX]", 3);
        Trigram.mapCP("[EOT]", 4);
        Trigram.mapCP("[ENQ]", 5);
        Trigram.mapCP("[ACK]", 6);
        Trigram.mapCP("[BEL]", 7);
        Trigram.mapCP("[BS]", 8);
        Trigram.mapCP("[HT]", 9);
        Trigram.mapCP("[LF]", 10);
        Trigram.mapCP("[VT]", 11);
        Trigram.mapCP("[FF]", 12);
        Trigram.mapCP("[CR]", 13);
        Trigram.mapCP("[SO]", 14);
        Trigram.mapCP("[SI]", 15);
        Trigram.mapCP("[DLE]", 16);
        Trigram.mapCP("[DC1]", 17);
        Trigram.mapCP("[DC2]", 18);
        Trigram.mapCP("[DC3]", 19);
        Trigram.mapCP("[DC4]", 20);
        Trigram.mapCP("[NAK]", 21);
        Trigram.mapCP("[SYN]", 22);
        Trigram.mapCP("[ETB]", 23);
        Trigram.mapCP("[CAN]", 24);
        Trigram.mapCP("[EM]", 25);
        Trigram.mapCP("[SUB]", 26);
        Trigram.mapCP("[ESC]", 27);
        Trigram.mapCP("[FS]", 28);
        Trigram.mapCP("[GS]", 29);
        Trigram.mapCP("[RS]", 30);
        Trigram.mapCP("[US]", 31);
        Trigram.mapCP("[SP]", 32);
        Trigram.mapCP("[DEL]", 127);
    }
}

