/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pdb.PdbInfo;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.framework.options.Options;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;

public class PdbInfoDotNet
implements StructConverter,
PdbInfo {
    private static final int MAGIC = 1381188691;
    private byte[] magic;
    private GUID guid;
    private int age;
    private String pdbName;
    private String pdbPath;

    public static boolean isMatch(BinaryReader reader, long offset) throws IOException {
        int value = reader.asBigEndian().readInt(offset);
        return 1381188691 == value;
    }

    public static PdbInfoDotNet read(BinaryReader reader, long offset) throws IOException {
        reader = reader.clone(offset);
        PdbInfoDotNet result = new PdbInfoDotNet();
        result.magic = reader.readNextByteArray(4);
        result.guid = new GUID(reader);
        result.age = reader.readNextInt();
        result.pdbPath = reader.readNextAsciiString();
        result.pdbName = FilenameUtils.getName((String)result.pdbPath);
        return result;
    }

    public static PdbInfoDotNet fromValues(String pdbPath, int age, GUID guid) {
        PdbInfoDotNet result = new PdbInfoDotNet();
        result.pdbPath = pdbPath;
        result.pdbName = FilenameUtils.getName((String)result.pdbPath);
        result.age = age;
        result.guid = guid;
        result.magic = "????".getBytes();
        return result;
    }

    private PdbInfoDotNet() {
    }

    @Override
    public boolean isValid() {
        return this.magic.length == 4 && !this.pdbName.isBlank() && this.guid != null;
    }

    @Override
    public void serializeToOptions(Options options) {
        options.setString("PDB Version", new String(this.magic, StandardCharsets.US_ASCII));
        options.setString("PDB GUID", this.guid.toString());
        options.setString("PDB Age", Integer.toHexString(this.age));
        options.setString("PDB File", this.pdbName);
    }

    @Override
    public DataType toDataType() {
        StructureDataType struct = new StructureDataType("DotNetPdbInfo", 0);
        struct.add((DataType)new StringDataType(), this.magic.length, "signature", null);
        struct.add((DataType)new GuidDataType(), "guid", null);
        struct.add((DataType)new DWordDataType(), "age", null);
        if (this.pdbPath.length() > 0) {
            struct.add((DataType)new StringDataType(), this.pdbPath.length(), "pdbpath", null);
        }
        struct.setCategoryPath(new CategoryPath("/PDB"));
        return struct;
    }
}

