/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.gotoquery.GoToQueryResultsTableModel;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.QueryData;
import ghidra.app.util.navigation.GoToSymbolSearchTask;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.AddressEvaluator;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoToQuery {
    private Pattern FILE_OFFSET_REGEX = Pattern.compile("file\\s*\\(\\s*((0x[0-9a-fA-F]+|[0-9]+))\\s*\\)", 2);
    private QueryData queryData;
    private Address fromAddress;
    private TaskMonitor monitor;
    private GoToService goToService;
    private final int maxHits;
    private final Plugin plugin;
    private final Navigatable navigatable;
    private NavigationOptions navigationOptions;
    private PluginTool tool;

    public GoToQuery(Navigatable navigatable, Plugin plugin, GoToService goToService, QueryData queryData, Address fromAddr, NavigationOptions navigationOptions, TaskMonitor monitor) {
        this.navigatable = navigatable;
        this.queryData = queryData;
        this.plugin = plugin;
        this.goToService = goToService;
        this.navigationOptions = navigationOptions;
        this.tool = plugin.getTool();
        ToolOptions options = plugin.getTool().getOptions("Search");
        this.maxHits = options.getInt("Search Limit", 500);
        this.fromAddress = fromAddr;
        this.monitor = monitor;
    }

    public boolean processQuery() {
        if (this.processFileOffset()) {
            return true;
        }
        if (this.processAddressExpression()) {
            return true;
        }
        if (this.processAddress()) {
            return true;
        }
        return this.processSymbols();
    }

    private boolean processFileOffset() {
        String input = this.queryData.getQueryString();
        Matcher matcher = this.FILE_OFFSET_REGEX.matcher(input);
        if (matcher.matches()) {
            try {
                long offset = Long.decode(matcher.group(1));
                Program currentProgram = this.navigatable.getProgram();
                Memory mem = currentProgram.getMemory();
                List addresses = mem.locateAddressesForFileOffset(offset);
                if (addresses.size() > 0) {
                    this.goToAddresses(currentProgram, addresses.toArray(new Address[0]));
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean processAddressExpression() {
        String queryInput = this.queryData.getQueryString();
        if (!this.isAddressExpression(queryInput)) {
            return false;
        }
        boolean relative = queryInput.matches("^\\s*[+-].*");
        Address baseAddr = relative ? this.fromAddress : null;
        for (Program program : this.getSearchPrograms()) {
            Address evalAddr = AddressEvaluator.evaluate((Program)program, (Address)baseAddr, (String)queryInput);
            if (evalAddr == null) continue;
            return this.goTo(program, new ProgramLocation(program, evalAddr));
        }
        return false;
    }

    private boolean processAddress() {
        String queryString = this.queryData.getQueryString();
        for (Program program : this.getSearchPrograms()) {
            Address[] addresses;
            Address[] validAddresses = this.validateAddresses(program, addresses = program.parseAddress(queryString, this.queryData.isCaseSensitive()));
            if (validAddresses.length <= 0) continue;
            return this.goToAddresses(program, validAddresses);
        }
        Program currentProgram = this.navigatable.getProgram();
        Address fileAddress = this.getFileAddress(currentProgram, queryString);
        if (fileAddress != null) {
            return this.goToAddresses(currentProgram, new Address[]{fileAddress});
        }
        return false;
    }

    private boolean processSymbols() {
        GoToSymbolSearchTask task = new GoToSymbolSearchTask(this.queryData, this.getSearchPrograms(), this.maxHits);
        TaskLauncher.launch((Task)task);
        List<ProgramLocation> locations = task.getResults();
        if (locations.isEmpty()) {
            return false;
        }
        Program program = locations.get(0).getProgram();
        return this.goToProgramLocations(program, locations);
    }

    private List<ProgramLocation> toProgramLocations(Address[] addresses, Program program) {
        return Arrays.stream(addresses).map(a -> new ProgramLocation(program, a)).toList();
    }

    private Address getFileAddress(Program program, String addressString) {
        if (this.fromAddress == null) {
            return null;
        }
        try {
            Address address = this.fromAddress.getAddressSpace().getAddress(addressString);
            if (address != null && program.getMemory().contains(address)) {
                return address;
            }
        }
        catch (AddressFormatException addressFormatException) {
            // empty catch block
        }
        return null;
    }

    private boolean goToAddresses(Program program, Address[] validAddresses) {
        List<ProgramLocation> locations = this.toProgramLocations(validAddresses, program);
        return this.goToProgramLocations(program, locations);
    }

    private boolean goToProgramLocations(Program program, List<ProgramLocation> locations) {
        if (locations.size() == 1) {
            return this.goTo(program, locations.get(0));
        }
        Swing.runIfSwingOrRunLater(() -> this.showResultsInTable(locations));
        return true;
    }

    private void showResultsInTable(List<ProgramLocation> locations) {
        Program program = locations.get(0).getProgram();
        if (locations.size() > this.maxHits) {
            this.showMaxSearchWarning(locations.size());
        }
        this.showModelInTable(new GoToQueryResultsTableModel(program, (ServiceProvider)this.tool, locations, this.monitor));
    }

    private void showModelInTable(GhidraProgramTableModel<?> model) {
        TableService service = (TableService)this.tool.getService(TableService.class);
        TableComponentProvider<?> provider = service.showTable("Goto " + this.queryData.getQueryString(), "Go To Results", model, "Go To", this.navigatable);
        provider.requestFocus();
    }

    private List<Program> getSearchPrograms() {
        Program currentProgram = this.navigatable.getProgram();
        ArrayList<Program> searchPrograms = new ArrayList<Program>();
        searchPrograms.add(currentProgram);
        if (!this.navigationOptions.isGoToRestrictedToCurrentProgram()) {
            Program[] allOpenPrograms;
            ProgramManager programManager = (ProgramManager)this.plugin.getTool().getService(ProgramManager.class);
            for (Program program : allOpenPrograms = programManager.getAllOpenPrograms()) {
                if (program == currentProgram) continue;
                searchPrograms.add(program);
            }
        }
        return searchPrograms;
    }

    private boolean isAddressExpression(String input) {
        return input.indexOf(43) >= 0 || input.indexOf(45) >= 0 || input.indexOf(42) > 0;
    }

    private Address[] validateAddresses(Program program, Address[] addrs) {
        Memory memory = program.getMemory();
        ArrayList<Address> list = new ArrayList<Address>();
        for (Address element : addrs) {
            boolean isValid = memory.contains(element);
            if (!isValid) continue;
            if (this.isPreferredAddress(element)) {
                return new Address[]{element};
            }
            list.add(element);
        }
        if (list.size() == addrs.length) {
            return addrs;
        }
        Address[] a = new Address[list.size()];
        return list.toArray(a);
    }

    private boolean isPreferredAddress(Address address) {
        if (!this.navigationOptions.preferCurrentAddressSpace()) {
            return false;
        }
        return this.isInCurrentAddressSpace(address);
    }

    private boolean isInCurrentAddressSpace(Address address) {
        if (this.fromAddress == null) {
            return true;
        }
        AddressSpace currentSpace = this.fromAddress.getAddressSpace();
        return currentSpace.equals((Object)address.getAddressSpace());
    }

    private boolean goTo(Program program, ProgramLocation loc) {
        if (loc == null) {
            return false;
        }
        if (program == null) {
            program = this.navigatable.getProgram();
        }
        return this.goToService.goTo(this.navigatable, loc, program);
    }

    private void showMaxSearchWarning(int matchCount) {
        Msg.showWarn(this.getClass(), null, (String)"Search Limit Exceeded!", (Object)("Stopped search after finding " + matchCount + " matches.\nThe search limit can be changed at Edit->Tool Options, under Search."));
    }
}

