/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.feature.vt.gui.editors.DisplayableAddress;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.table.field.AddressBasedLocation;

public class DisplayableListingAddress
implements DisplayableAddress {
    protected final Program program;
    protected Address address;

    public DisplayableListingAddress(Program program, Address listingAddress) {
        this.program = program;
        this.address = listingAddress;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public String getDisplayString() {
        if (this.address == null || this.address == Address.NO_ADDRESS) {
            return "No Address";
        }
        AddressBasedLocation location = new AddressBasedLocation(this.program, this.address);
        return location.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(DisplayableAddress otherDisplayableAddress) {
        if (otherDisplayableAddress == null) {
            return 1;
        }
        Address otherAddress = otherDisplayableAddress.getAddress();
        if (this.address == null) {
            return otherAddress == null ? 0 : -1;
        }
        if (otherAddress == null) {
            return 1;
        }
        return this.address.compareTo((Object)otherAddress);
    }
}

