/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.tgt;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record JitCompiledPassageClass(MethodHandles.Lookup lookup, Class<? extends JitCompiledPassage> cls, MethodHandle constructor) {
    public static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, JitPcodeThread.class);

    public static JitCompiledPassageClass load(MethodHandles.Lookup lookup, byte[] bytes) {
        try {
            MethodHandles.Lookup defLookup = lookup.defineHiddenClass(bytes, true, new MethodHandles.Lookup.ClassOption[0]);
            Class<?> cls = defLookup.lookupClass();
            MethodHandle constructor = defLookup.findConstructor(cls, CONSTRUCTOR_TYPE);
            return new JitCompiledPassageClass(defLookup, cls, constructor);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public JitCompiledPassage createInstance(JitPcodeThread thread) {
        try {
            return this.constructor.invoke(thread);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    public Map<JitPassage.AddrCtx, JitCompiledPassage.EntryPointPrototype> getBlockEntries() {
        try {
            MethodHandle getter = this.lookup.findStaticGetter(this.cls, "ENTRIES", List.class);
            List entries = getter.invoke();
            HashMap<JitPassage.AddrCtx, JitCompiledPassage.EntryPointPrototype> result = new HashMap<JitPassage.AddrCtx, JitCompiledPassage.EntryPointPrototype>();
            for (int i = 0; i < entries.size(); ++i) {
                result.put((JitPassage.AddrCtx)entries.get(i), new JitCompiledPassage.EntryPointPrototype(this, i));
            }
            return result;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }
}

