/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh;

import generic.lsh.LSHMemoryModel;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class KandL {
    static double probOfHashMatch(double tau) {
        double thetabound = Math.acos(tau);
        double probbound = 1.0 - thetabound / Math.PI;
        return probbound;
    }

    public static int memoryModelToL(LSHMemoryModel model) {
        return KandL.kToL(model.getK(), model.getTauBound(), model.getProbabilityThreshold());
    }

    public static int kToL(int k, double taubound, double probthresh) {
        double P1 = KandL.probOfHashMatch(taubound);
        double prob_k_matches = Math.pow(P1, k);
        double prob_nomatch = 1.0 - prob_k_matches;
        int L = 1;
        double prob_nomatch_n = prob_nomatch;
        while (1.0 - prob_nomatch_n < probthresh) {
            ++L;
            prob_nomatch_n *= prob_nomatch;
        }
        return L;
    }

    static double binHits(int k, int L, BigInteger n) {
        BigInteger numbins = new BigInteger(new byte[]{1});
        numbins = numbins.shiftLeft(k);
        double hitsperbin = new BigDecimal(n).divide(new BigDecimal(numbins)).doubleValue();
        double numcompare = hitsperbin * (double)L;
        return numcompare;
    }

    static void print_result(PrintStream out, int k, int L, BigInteger n, double qt) {
        out.println(String.format("k=%d L=%d n=%s bin hits=%f k*L=%d", k, L, n.toString(), qt, k * L));
    }

    static void process_n(PrintStream out, BigInteger n, double taubound, double probthresh) {
        for (int k = 10; k <= 30; ++k) {
            int L = KandL.kToL(k, taubound, probthresh);
            double qt = KandL.binHits(k, L, n);
            KandL.print_result(out, k, L, n, qt);
        }
    }

    public static void main(String[] args) {
        try {
            BigInteger n = new BigInteger(args[0]);
            double taubound = Double.parseDouble(args[1]);
            double probthresh = Double.parseDouble(args[2]);
            KandL.process_n(System.out, n, taubound, probthresh);
        }
        catch (Exception e) {
            System.err.println("caught " + e.getClass().getName() + ": " + e.getLocalizedMessage());
            System.err.println("USAGE: KandL n taulowerbound probthresh");
        }
    }
}

