/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderV3;
import ghidra.file.formats.android.bootimg.VendorRamdiskTableEntryV4;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.InvalidNameException;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VendorBootImageHeaderV4
extends VendorBootImageHeaderV3 {
    private int vendor_ramdisk_table_size;
    private int vendor_ramdisk_table_entry_num;
    private int vendor_ramdisk_table_entry_size;
    private int bootconfig_size;
    private List<VendorRamdiskTableEntryV4> ramdiskTableEntryList = new ArrayList<VendorRamdiskTableEntryV4>();

    public VendorBootImageHeaderV4(BinaryReader reader) throws IOException {
        super(reader);
        this.vendor_ramdisk_table_size = reader.readNextInt();
        this.vendor_ramdisk_table_entry_num = reader.readNextInt();
        this.vendor_ramdisk_table_entry_size = reader.readNextInt();
        this.bootconfig_size = reader.readNextInt();
        BinaryReader cloneReader = reader.clone(this.getVendorRamdiskTableOffset());
        for (int i = 0; i < this.vendor_ramdisk_table_entry_num; ++i) {
            this.ramdiskTableEntryList.add(new VendorRamdiskTableEntryV4(cloneReader));
        }
    }

    @Override
    public long getNestedVendorRamdiskCount() {
        return this.vendor_ramdisk_table_entry_num;
    }

    @Override
    public long getNestedVendorRamdiskOffset(int index) throws IOException {
        return this.getVendorRamdiskOffset() + (long)this.ramdiskTableEntryList.get(index).getRamdiskOffset();
    }

    @Override
    public int getNestedVendorRamdiskSize(int index) throws IOException {
        return this.ramdiskTableEntryList.get(index).getRamdiskSize();
    }

    public long getVendorRamdiskTableOffset() {
        long value = this.getDtbOffset() + (long)this.getDtbSize();
        return NumericUtilities.getUnsignedAlignedValue((long)value, (long)this.getPageSize());
    }

    public int getVendorRamdiskTableSize() {
        return this.vendor_ramdisk_table_size;
    }

    public int getVendorRamdiskTableEntryNum() {
        return this.vendor_ramdisk_table_entry_num;
    }

    public int getVendorRamdiskTableEntrySize() {
        return this.vendor_ramdisk_table_entry_size;
    }

    public long getBootConfigOffset() {
        long value = this.getVendorRamdiskTableOffset() + (long)this.getVendorRamdiskTableSize();
        return NumericUtilities.getUnsignedAlignedValue((long)value, (long)this.getPageSize());
    }

    public int getBootConfigSize() {
        return this.bootconfig_size;
    }

    public List<VendorRamdiskTableEntryV4> getVendorRamdiskTableEntryList() {
        return this.ramdiskTableEntryList;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        try {
            structure.setName("vendor_boot_img_hdr_v4");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.add(DWORD, "vendor_ramdisk_table_size", null);
        structure.add(DWORD, "vendor_ramdisk_table_entry_num", null);
        structure.add(DWORD, "vendor_ramdisk_table_entry_size", null);
        structure.add(DWORD, "bootconfig_size", null);
        return structure;
    }
}

