/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.util;

import java.io.IOException;

public class OverlayRange {
    private int overlayIndex;
    private byte[] overlayBytes;

    public OverlayRange(long overlayIndex, byte[] overlayBytes) {
        this((int)overlayIndex, overlayBytes);
    }

    public OverlayRange(int overlayIndex, byte[] overlayBytes) {
        this.overlayIndex = overlayIndex;
        this.overlayBytes = overlayBytes;
    }

    public int getStartIndex() {
        return this.overlayIndex;
    }

    public int getEndIndex() {
        return this.overlayIndex + this.overlayBytes.length;
    }

    public boolean containsIndex(int index) {
        return index >= this.getStartIndex() && index <= this.getEndIndex();
    }

    public boolean containsIndex(long index) {
        return this.containsIndex((int)index);
    }

    public byte getByte(int index) {
        return this.overlayBytes[index - this.overlayIndex];
    }

    public byte getByte(long index) {
        return this.getByte((int)index);
    }

    public byte[] getBytes(int index, int length) throws IOException {
        try {
            byte[] bytes = new byte[length];
            System.arraycopy(this.overlayBytes, index - this.overlayIndex, bytes, 0, length);
            return bytes;
        }
        catch (Exception e) {
            throw new IOException("specified index and length are out of range");
        }
    }

    public byte[] getBytes(long index, long length) throws IOException {
        return this.getBytes((int)index, (int)length);
    }

    public byte[] getAllBytes() {
        return this.overlayBytes;
    }
}

