/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.Token;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class TokenField
extends PatternValue {
    private Token tok;
    private boolean bigendian;
    private boolean signbit;
    private int bitstart;
    private int bitend;
    private int bytestart;
    private int byteend;
    private int shift;

    public TokenField(Location location) {
        super(location);
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location, this.tok);
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = 0L;
        res ^= 0xFFFFFFFFFFFFFFFFL;
        res = Utils.zzz_zero_extend(res, this.bitend - this.bitstart);
        return res;
    }

    public TokenField(Location location, Token tk, boolean s, int bstart, int bend) {
        super(location);
        this.tok = tk;
        this.bigendian = this.tok.isBigEndian();
        this.signbit = s;
        this.bitstart = bstart;
        this.bitend = bend;
        if (tk.isBigEndian()) {
            this.byteend = (tk.getSize() * 8 - this.bitstart - 1) / 8;
            this.bytestart = (tk.getSize() * 8 - this.bitend - 1) / 8;
        } else {
            this.bytestart = this.bitstart / 8;
            this.byteend = this.bitend / 8;
        }
        this.shift = this.bitstart % 8;
    }

    @Override
    public TokenPattern genPattern(long val) {
        return new TokenPattern(this.location, this.tok, val, this.bitstart, this.bitend);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_TOKENFIELD);
        encoder.writeBool(SlaFormat.ATTRIB_BIGENDIAN, this.bigendian);
        encoder.writeBool(SlaFormat.ATTRIB_SIGNBIT, this.signbit);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_STARTBIT, this.bitstart);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_ENDBIT, this.bitend);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_STARTBYTE, this.bytestart);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_ENDBYTE, this.byteend);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SHIFT, this.shift);
        encoder.closeElement(SlaFormat.ELEM_TOKENFIELD);
    }
}

