/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import java.math.BigInteger;
import java.util.List;

public interface ProgramContext {
    public boolean hasNonFlowingContext();

    public RegisterValue getFlowValue(RegisterValue var1);

    public RegisterValue getNonFlowValue(RegisterValue var1);

    public Register getRegister(String var1);

    public List<Register> getRegisters();

    public Register[] getRegistersWithValues();

    public BigInteger getValue(Register var1, Address var2, boolean var3);

    public RegisterValue getRegisterValue(Register var1, Address var2);

    public void setRegisterValue(Address var1, Address var2, RegisterValue var3) throws ContextChangeException;

    public RegisterValue getNonDefaultValue(Register var1, Address var2);

    public void setValue(Register var1, Address var2, Address var3, BigInteger var4) throws ContextChangeException;

    public AddressRangeIterator getRegisterValueAddressRanges(Register var1);

    public AddressRangeIterator getRegisterValueAddressRanges(Register var1, Address var2, Address var3);

    public AddressRange getRegisterValueRangeContaining(Register var1, Address var2);

    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register var1);

    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register var1, Address var2, Address var3);

    public List<Register> getContextRegisters();

    public void remove(Address var1, Address var2, Register var3) throws ContextChangeException;

    public List<String> getRegisterNames();

    public boolean hasValueOverRange(Register var1, BigInteger var2, AddressSetView var3);

    public RegisterValue getDefaultValue(Register var1, Address var2);

    public Register getBaseContextRegister();

    public RegisterValue getDefaultDisassemblyContext();

    public void setDefaultDisassemblyContext(RegisterValue var1);

    public RegisterValue getDisassemblyContext(Address var1);
}

