/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.sf.juife.InformationDialog;
import net.sf.juife.JuifeUtils;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.task.Channel;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.SamplerChannel;

public class JSChannelOutputRoutingDlg
extends InformationDialog {
    private final ChannelRoutingTable channelRoutingTable;
    private SamplerChannel channel;

    public JSChannelOutputRoutingDlg(Frame frame, SamplerChannel samplerChannel) {
        super(frame, StdI18n.i18n.getLabel("JSChannelOutputRoutingDlg.title"));
        this.channel = samplerChannel;
        this.channelRoutingTable = new ChannelRoutingTable();
        JScrollPane jScrollPane = new JScrollPane(this.channelRoutingTable);
        jScrollPane.setPreferredSize(JuifeUtils.getUnionSize(jScrollPane.getMinimumSize(), new Dimension(200, 150)));
        this.setMainPane(jScrollPane);
    }

    class ChannelRoutingTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{StdI18n.i18n.getLabel("JSChannelOutputRoutingDlg.audioIn"), StdI18n.i18n.getLabel("JSChannelOutputRoutingDlg.audioOut")};

        ChannelRoutingTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return JSChannelOutputRoutingDlg.this.channel.getAudioOutputChannels();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return JSChannelOutputRoutingDlg.this.channel.getAudioOutputRouting()[n];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            int n3 = JSChannelOutputRoutingDlg.this.channel.getChannelId();
            int n4 = (Integer)this.getValueAt(n, 0);
            int n5 = (Integer)object;
            CC.getTaskQueue().add(new Channel.SetAudioOutputChannel(n3, n4, n5));
            ((JSChannelOutputRoutingDlg)JSChannelOutputRoutingDlg.this).channel.getAudioOutputRouting()[n] = n5;
            this.fireTableCellUpdated(n, n2);
        }
    }

    class ChannelRoutingTable
    extends JTable {
        private String[] columnToolTips;

        ChannelRoutingTable() {
            super(new ChannelRoutingTableModel());
            this.columnToolTips = new String[]{StdI18n.i18n.getLabel("JSChannelOutputRoutingDlg.ttAudioIn", JSChannelOutputRoutingDlg.this.channel.getChannelId()), StdI18n.i18n.getLabel("JSChannelOutputRoutingDlg.ttAudioOut")};
            JComboBox<Integer> jComboBox = new JComboBox<Integer>();
            int n = JSChannelOutputRoutingDlg.this.channel.getAudioOutputDevice();
            AudioDeviceModel audioDeviceModel = CC.getSamplerModel().getAudioDeviceById(n);
            if (audioDeviceModel == null) {
                this.setEnabled(false);
            } else {
                int n2 = audioDeviceModel.getDeviceInfo().getAudioChannelCount();
                Integer n3 = 0;
                while (n3 < n2) {
                    jComboBox.addItem(n3);
                    Integer n4 = n3;
                    Integer n5 = n3 = Integer.valueOf(n3 + 1);
                }
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(1);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = this.columnModel.getColumnIndexAtX(point.x);
                    n = this.columnModel.getColumn(n).getModelIndex();
                    return ChannelRoutingTable.this.columnToolTips[n];
                }
            };
        }
    }
}

