/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.LongValues;

public class DirectReader {
    static final int MERGE_BUFFER_SHIFT = 7;
    private static final int MERGE_BUFFER_SIZE = 128;
    private static final int MERGE_BUFFER_MASK = 127;

    public static LongValues getInstance(RandomAccessInput slice, int bitsPerValue) {
        return DirectReader.getInstance(slice, bitsPerValue, 0L);
    }

    public static LongValues getInstance(RandomAccessInput slice, int bitsPerValue, long offset) {
        switch (bitsPerValue) {
            case 1: {
                return new DirectPackedReader1(slice, offset);
            }
            case 2: {
                return new DirectPackedReader2(slice, offset);
            }
            case 4: {
                return new DirectPackedReader4(slice, offset);
            }
            case 8: {
                return new DirectPackedReader8(slice, offset);
            }
            case 12: {
                return new DirectPackedReader12(slice, offset);
            }
            case 16: {
                return new DirectPackedReader16(slice, offset);
            }
            case 20: {
                return new DirectPackedReader20(slice, offset);
            }
            case 24: {
                return new DirectPackedReader24(slice, offset);
            }
            case 28: {
                return new DirectPackedReader28(slice, offset);
            }
            case 32: {
                return new DirectPackedReader32(slice, offset);
            }
            case 40: {
                return new DirectPackedReader40(slice, offset);
            }
            case 48: {
                return new DirectPackedReader48(slice, offset);
            }
            case 56: {
                return new DirectPackedReader56(slice, offset);
            }
            case 64: {
                return new DirectPackedReader64(slice, offset);
            }
        }
        throw new IllegalArgumentException("unsupported bitsPerValue: " + bitsPerValue);
    }

    public static LongValues getMergeInstance(RandomAccessInput slice, int bitsPerValue, long numValues) {
        return DirectReader.getMergeInstance(slice, bitsPerValue, 0L, numValues);
    }

    public static LongValues getMergeInstance(final RandomAccessInput slice, final int bitsPerValue, final long baseOffset, final long numValues) {
        return new LongValues(){
            private final long[] buffer = new long[128];
            private long blockIndex = -1L;

            @Override
            public long get(long index) {
                assert (index < numValues);
                long blockIndex = index >>> 7;
                if (this.blockIndex != blockIndex) {
                    try {
                        this.fillBuffer(blockIndex << 7);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    this.blockIndex = blockIndex;
                }
                return this.buffer[(int)(index & 0x7FL)];
            }

            private void fillBuffer(long index) throws IOException {
                if (index >= numValues - 128L) {
                    LongValues slowInstance = DirectReader.getInstance(slice, bitsPerValue, baseOffset);
                    int numValuesLastBlock = Math.toIntExact(numValues - index);
                    for (int i = 0; i < numValuesLastBlock; ++i) {
                        this.buffer[i] = slowInstance.get(index + (long)i);
                    }
                } else if ((bitsPerValue & 7) == 0) {
                    int bytesPerValue = bitsPerValue / 8;
                    long mask = bitsPerValue == 64 ? -1L : (1L << bitsPerValue) - 1L;
                    long offset = baseOffset + index * (long)bitsPerValue / 8L;
                    for (int i = 0; i < 128; ++i) {
                        this.buffer[i] = bitsPerValue > 32 ? slice.readLong(offset) & mask : (bitsPerValue > 16 ? (long)slice.readInt(offset) & mask : (bitsPerValue > 8 ? Short.toUnsignedLong(slice.readShort(offset)) : Byte.toUnsignedLong(slice.readByte(offset))));
                        offset += (long)bytesPerValue;
                    }
                } else if (bitsPerValue < 8) {
                    int valuesPerLong = 64 / bitsPerValue;
                    long mask = (1L << bitsPerValue) - 1L;
                    long offset = baseOffset + index * (long)bitsPerValue / 8L;
                    int i = 0;
                    for (int l = 0; l < 2 * bitsPerValue; ++l) {
                        long bits = slice.readLong(offset);
                        for (int j = 0; j < valuesPerLong; ++j) {
                            this.buffer[i++] = bits >>> j * bitsPerValue & mask;
                        }
                        offset += 8L;
                    }
                } else {
                    int numBytesFor2Values = bitsPerValue * 2 / 8;
                    long mask = (1L << bitsPerValue) - 1L;
                    long offset = baseOffset + index * (long)bitsPerValue / 8L;
                    for (int i = 0; i < 128; i += 2) {
                        long l = numBytesFor2Values > 4 ? slice.readLong(offset) : (long)slice.readInt(offset);
                        this.buffer[i] = l & mask;
                        this.buffer[i + 1] = l >>> bitsPerValue & mask;
                        offset += (long)numBytesFor2Values;
                    }
                }
            }
        };
    }

    static final class DirectPackedReader1
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader1(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index & 7L);
                return this.in.readByte(this.offset + (index >>> 3)) >>> shift & 1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader2
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader2(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index & 3L) << 1;
                return this.in.readByte(this.offset + (index >>> 2)) >>> shift & 3;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader4
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader4(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index & 1L) << 2;
                return this.in.readByte(this.offset + (index >>> 1)) >>> shift & 0xF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader8
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader8(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readByte(this.offset + index) & 0xFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader12
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader12(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * 12L >>> 3;
                int shift = (int)(index & 1L) << 2;
                return this.in.readShort(this.offset + offset) >>> shift & 0xFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader16
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader16(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readShort(this.offset + (index << 1)) & 0xFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader20
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader20(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * 20L >>> 3;
                int shift = (int)(index & 1L) << 2;
                return this.in.readInt(this.offset + offset) >>> shift & 0xFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader24
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader24(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readInt(this.offset + index * 3L) & 0xFFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader28
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader28(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * 28L >>> 3;
                int shift = (int)(index & 1L) << 2;
                return this.in.readInt(this.offset + offset) >>> shift & 0xFFFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader32
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader32(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return (long)this.in.readInt(this.offset + (index << 2)) & 0xFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader40
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader40(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + index * 5L) & 0xFFFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader48
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader48(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + index * 6L) & 0xFFFFFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader56
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader56(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + index * 7L) & 0xFFFFFFFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader64
    extends LongValues {
        final RandomAccessInput in;
        final long offset;

        DirectPackedReader64(RandomAccessInput in, long offset) {
            this.in = in;
            this.offset = offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + (index << 3));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

