/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordBasedDeriverFactory;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedPasswordBasedDeriverFactory;
import org.bouncycastle.crypto.general.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.general.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.general.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.general.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.util.Arrays;

public final class PBKD {
    private static final GeneralAlgorithm ALGORITHM_PBKDF2 = new GeneralAlgorithm("PBKDF2");
    private static final GeneralAlgorithm ALGORITHM_PBKDF1 = new GeneralAlgorithm("PBKDF1");
    private static final GeneralAlgorithm ALGORITHM_PKCS12 = new GeneralAlgorithm("PKCS12");
    private static final GeneralAlgorithm ALGORITHM_OpenSSL = new GeneralAlgorithm("OpenSSL");
    public static final ParametersBuilder PBKDF1 = new ParametersBuilder(ALGORITHM_PBKDF1, FipsSHS.Algorithm.SHA1);
    public static final ParametersBuilder PBKDF2 = new ParametersBuilder(ALGORITHM_PBKDF2, FipsSHS.Algorithm.SHA1_HMAC);
    public static final ParametersBuilder PKCS12 = new ParametersBuilder(ALGORITHM_PKCS12, FipsSHS.Algorithm.SHA1);
    public static final OpenSSLParametersBuilder OpenSSL = new OpenSSLParametersBuilder();
    private static Map<Algorithm, PasswordBasedDeriverFactory<Parameters>> deriverTable = new HashMap<Algorithm, PasswordBasedDeriverFactory<Parameters>>();

    private PBKD() {
    }

    static {
        deriverTable.put(ALGORITHM_PBKDF2, new PBKDF2DeriverFactory());
        deriverTable.put(ALGORITHM_PBKDF1, new PBKDF1DeriverFactory());
        deriverTable.put(ALGORITHM_PKCS12, new PKCS12DeriverFactory());
        deriverTable.put(ALGORITHM_OpenSSL, new OpenSSLDeriverFactory());
    }

    public static class DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(Parameters parameters2) {
            return ((PasswordBasedDeriverFactory)deriverTable.get(parameters2.getAlgorithm())).createDeriver(parameters2);
        }
    }

    private static class OpenSSLDeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private OpenSSLDeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters2) {
            if (parameters2.getPRF() != SecureHash.Algorithm.MD5) {
                throw new IllegalArgumentException("OpenSSL PBKDF only defined for MD5");
            }
            final OpenSSLPBEParametersGenerator<Parameters> openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator<Parameters>(parameters2);
            openSSLPBEParametersGenerator.init(parameters2.getPassword(), parameters2.getSalt(), parameters2.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return parameters2;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return openSSLPBEParametersGenerator.deriveKey(keyType, n);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return openSSLPBEParametersGenerator.deriveKeyAndIV(keyType, n, n2);
                }
            };
        }
    }

    public static final class OpenSSLParametersBuilder
    extends GeneralParameters {
        OpenSSLParametersBuilder() {
            super(ALGORITHM_OpenSSL);
        }

        public Parameters using(byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), SecureHash.Algorithm.MD5, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), SecureHash.Algorithm.MD5, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }

    private static class PBKDF1DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PBKDF1DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters2) {
            final PKCS5S1ParametersGenerator<Parameters> pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator<Parameters>(parameters2, Register.createDigest(parameters2.getPRF()));
            pKCS5S1ParametersGenerator.init(parameters2.getPassword(), parameters2.getSalt(), parameters2.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return parameters2;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return pKCS5S1ParametersGenerator.deriveKey(keyType, n);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return pKCS5S1ParametersGenerator.deriveKeyAndIV(keyType, n, n2);
                }
            };
        }
    }

    private static class PBKDF2DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PBKDF2DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters2) {
            final PKCS5S2ParametersGenerator<Parameters> pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator<Parameters>(parameters2, Register.createHMac(parameters2.getPRF()));
            pKCS5S2ParametersGenerator.init(parameters2.getPassword(), parameters2.getSalt(), parameters2.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters2;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return pKCS5S2ParametersGenerator.deriveKey(keyType, n);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return pKCS5S2ParametersGenerator.deriveKeyAndIV(keyType, n, n2);
                }
            };
        }
    }

    private static class PKCS12DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PKCS12DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters2) {
            final PKCS12ParametersGenerator<Parameters> pKCS12ParametersGenerator = new PKCS12ParametersGenerator<Parameters>(parameters2, Register.createDigest(parameters2.getPRF()));
            pKCS12ParametersGenerator.init(parameters2.getPassword(), parameters2.getSalt(), parameters2.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return parameters2;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return pKCS12ParametersGenerator.deriveKey(keyType, n);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
                    Utils.approveModeCheck(parameters2.getAlgorithm());
                    return pKCS12ParametersGenerator.deriveKeyAndIV(keyType, n, n2);
                }
            };
        }
    }

    public static final class Parameters
    extends GeneralParameters<Algorithm> {
        private final DigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm, PasswordConverter passwordConverter, byte[] byArray, int n, byte[] byArray2) {
            super(generalAlgorithm);
            this.digestAlgorithm = digestAlgorithm;
            this.converter = passwordConverter;
            this.password = byArray;
            this.iterationCount = n;
            this.salt = byArray2;
        }

        private Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            this(generalAlgorithm, digestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(byArray));
        }

        public Parameters withIterationCount(int n) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.digestAlgorithm, this.converter, this.getPassword(), n, this.salt);
        }

        byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public DigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Arrays.fill(this.password, (byte)0);
        }
    }

    public static final class ParametersBuilder
    extends GeneralParameters {
        private final DigestAlgorithm defaultPrf;

        ParametersBuilder(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            this.defaultPrf = digestAlgorithm;
        }

        public Parameters using(byte[] byArray) {
            return this.using(this.defaultPrf, byArray);
        }

        public Parameters using(DigestAlgorithm digestAlgorithm, byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.defaultPrf, passwordConverter, cArray);
        }

        public Parameters using(DigestAlgorithm digestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }
}

