/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.samplecalculator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.ExecuteInput;
import org.opensearch.ml.common.input.Input;

@ExecuteInput(algorithms={FunctionName.LOCAL_SAMPLE_CALCULATOR})
public class LocalSampleCalculatorInput
implements Input {
    public static final String PARSE_FIELD_NAME = FunctionName.LOCAL_SAMPLE_CALCULATOR.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> LocalSampleCalculatorInput.parse(it));
    public static final String OPERATION_FIELD = "operation";
    public static final String INPUT_DATA_FIELD = "input_data";
    String operation;
    List<Double> inputData;

    public static LocalSampleCalculatorInput parse(XContentParser parser) throws IOException {
        String operation = null;
        ArrayList<Double> inputData = new ArrayList<Double>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "operation": {
                    operation = parser.text();
                    continue block8;
                }
                case "input_data": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        inputData.add(parser.doubleValue(false));
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new LocalSampleCalculatorInput(operation, inputData);
    }

    public LocalSampleCalculatorInput(String operation, List<Double> inputData) {
        if (operation == null) {
            throw new IllegalArgumentException("wrong operation");
        }
        if (inputData == null || inputData.size() == 0) {
            throw new IllegalArgumentException("empty input data");
        }
        this.operation = operation;
        this.inputData = inputData;
    }

    @Override
    public FunctionName getFunctionName() {
        return FunctionName.LOCAL_SAMPLE_CALCULATOR;
    }

    public LocalSampleCalculatorInput(StreamInput in) throws IOException {
        this.operation = in.readString();
        int size = in.readInt();
        this.inputData = new ArrayList<Double>();
        for (int i = 0; i < size; ++i) {
            this.inputData.add(in.readDouble());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.operation);
        out.writeInt(this.inputData.size());
        for (Double d : this.inputData) {
            out.writeDouble(d.doubleValue());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(OPERATION_FIELD, this.operation);
        builder.field(INPUT_DATA_FIELD, this.inputData);
        builder.endObject();
        return builder;
    }

    @Generated
    public static LocalSampleCalculatorInputBuilder builder() {
        return new LocalSampleCalculatorInputBuilder();
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public List<Double> getInputData() {
        return this.inputData;
    }

    @Generated
    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Generated
    public void setInputData(List<Double> inputData) {
        this.inputData = inputData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalSampleCalculatorInput)) {
            return false;
        }
        LocalSampleCalculatorInput other = (LocalSampleCalculatorInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$operation = this.getOperation();
        String other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        List<Double> this$inputData = this.getInputData();
        List<Double> other$inputData = other.getInputData();
        return !(this$inputData == null ? other$inputData != null : !((Object)this$inputData).equals(other$inputData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalSampleCalculatorInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $operation = this.getOperation();
        result2 = result2 * 59 + ($operation == null ? 43 : $operation.hashCode());
        List<Double> $inputData = this.getInputData();
        result2 = result2 * 59 + ($inputData == null ? 43 : ((Object)$inputData).hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "LocalSampleCalculatorInput(operation=" + this.getOperation() + ", inputData=" + String.valueOf(this.getInputData()) + ")";
    }

    @Generated
    public static class LocalSampleCalculatorInputBuilder {
        @Generated
        private String operation;
        @Generated
        private List<Double> inputData;

        @Generated
        LocalSampleCalculatorInputBuilder() {
        }

        @Generated
        public LocalSampleCalculatorInputBuilder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Generated
        public LocalSampleCalculatorInputBuilder inputData(List<Double> inputData) {
            this.inputData = inputData;
            return this;
        }

        @Generated
        public LocalSampleCalculatorInput build() {
            return new LocalSampleCalculatorInput(this.operation, this.inputData);
        }

        @Generated
        public String toString() {
            return "LocalSampleCalculatorInput.LocalSampleCalculatorInputBuilder(operation=" + this.operation + ", inputData=" + String.valueOf(this.inputData) + ")";
        }
    }
}

