/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class DaySpanHandler {
    public RexNode createExpression(RexNode fieldExpr, int intervalDays, CalcitePlanContext context) {
        RexNode inputDate = context.rexBuilder.makeCall(PPLBuiltinOperators.DATE, fieldExpr);
        RexLiteral epochDate = context.relBuilder.literal("1970-01-01");
        RexNode daysSinceEpoch = context.rexBuilder.makeCall(PPLBuiltinOperators.DATEDIFF, inputDate, epochDate);
        RexNode binStartDays = this.calculateBinStart(daysSinceEpoch, intervalDays, context);
        RexNode binStartDate = context.rexBuilder.makeCall(PPLBuiltinOperators.ADDDATE, epochDate, binStartDays);
        return context.rexBuilder.makeCall(PPLBuiltinOperators.TIMESTAMP, binStartDate);
    }

    private RexNode calculateBinStart(RexNode value, int interval, CalcitePlanContext context) {
        RexLiteral intervalLiteral = context.relBuilder.literal(interval);
        RexNode positionInCycle = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MOD, value, intervalLiteral);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, value, positionInCycle);
    }
}

