/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.interceptors;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.babbel.mobile.android.commons.okhttpawssigner.OkHttpAwsV4Signer;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AwsSigningInterceptor
implements Interceptor {
    private final OkHttpAwsV4Signer okHttpAwsV4Signer;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Logger LOG = LogManager.getLogger();

    public AwsSigningInterceptor(@NonNull AWSCredentialsProvider awsCredentialsProvider, @NonNull String region, @NonNull String serviceName) {
        if (awsCredentialsProvider == null) {
            throw new NullPointerException("awsCredentialsProvider is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.okHttpAwsV4Signer = new OkHttpAwsV4Signer(region, serviceName);
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("GMT"));
        Request.Builder newRequestBuilder = request.newBuilder().addHeader("x-amz-date", timestampFormat.format(ZonedDateTime.now())).addHeader("host", request.url().host());
        AWSCredentials awsCredentials = this.awsCredentialsProvider.getCredentials();
        if (this.awsCredentialsProvider instanceof STSAssumeRoleSessionCredentialsProvider) {
            newRequestBuilder.addHeader("x-amz-security-token", ((STSAssumeRoleSessionCredentialsProvider)this.awsCredentialsProvider).getCredentials().getSessionToken());
        }
        Request newRequest = newRequestBuilder.build();
        Request signed = this.okHttpAwsV4Signer.sign(newRequest, awsCredentials.getAWSAccessKeyId(), awsCredentials.getAWSSecretKey());
        return chain.proceed(signed);
    }
}

