/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.spatial;

import java.util.ArrayList;
import org.opensearch.sql.legacy.utils.StringUtils;
import shaded.com.google.common.base.Joiner;

public class WktToGeoJsonConverter {
    public static String toGeoJson(String wkt) {
        int startOfCoordinates = (wkt = wkt.toLowerCase()).indexOf("(");
        if (startOfCoordinates == -1) {
            throw new IllegalArgumentException(StringUtils.format("Failed to convert well-known-text [%s] to geometry type", wkt));
        }
        String wktType = wkt.substring(0, startOfCoordinates).trim();
        wkt = wkt.substring(startOfCoordinates);
        String type2 = "";
        String coordinates = "";
        switch (wktType) {
            case "point": {
                type2 = "Point";
                coordinates = WktToGeoJsonConverter.pointCoordinatesFromWkt(wkt);
                break;
            }
            case "polygon": {
                type2 = "Polygon";
                coordinates = WktToGeoJsonConverter.polygonCoordinatesFromWkt(wkt);
                break;
            }
            case "linestring": {
                type2 = "LineString";
                coordinates = WktToGeoJsonConverter.lineStringCoordinatesFromWkt(wkt);
                break;
            }
            case "multipolygon": {
                type2 = "MultiPolygon";
                coordinates = WktToGeoJsonConverter.multiPolygonCoordinatesFromWkt(wkt);
                break;
            }
            case "multipoint": {
                type2 = "MultiPoint";
                coordinates = WktToGeoJsonConverter.multiPointCoordinatesFromWkt(wkt);
                break;
            }
            case "multilinestring": {
                type2 = "MultiLineString";
                coordinates = WktToGeoJsonConverter.multiLineStringCoordinatesFromWkt(wkt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported well-known-text type: " + wktType);
            }
        }
        return WktToGeoJsonConverter.buildGeoJson(type2, coordinates);
    }

    private static String multiLineStringCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        String lineStringsWithPipeSeparator = wkt.replaceAll("\\s*\\)\\s*,\\s*\\(", ")|(");
        String[] lineStrings = lineStringsWithPipeSeparator.split("\\|");
        Object[] coordinates = new String[lineStrings.length];
        for (int i = 0; i < lineStrings.length; ++i) {
            coordinates[i] = WktToGeoJsonConverter.lineStringCoordinatesFromWkt(lineStrings[i]);
        }
        String multiLineStringCoordinates = Joiner.on(",").join(coordinates);
        return String.format("[%s]", multiLineStringCoordinates);
    }

    private static String multiPointCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        boolean isSecondVersionMultiPoint = wkt.contains("(");
        String coordinates = "";
        if (isSecondVersionMultiPoint) {
            wkt = wkt.replaceAll("\\(|\\)", "");
        }
        coordinates = WktToGeoJsonConverter.getJsonArrayFromListOfPoints(wkt);
        return coordinates;
    }

    private static String multiPolygonCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        String polygonsWithPipeSeparator = wkt.replaceAll("\\s*\\)\\s*\\)\\s*,\\s*\\(\\s*\\(\\s*", "))|((");
        String[] polygons = polygonsWithPipeSeparator.split("\\|");
        Object[] polygonsCoordinates = new String[polygons.length];
        for (int i = 0; i < polygons.length; ++i) {
            polygonsCoordinates[i] = WktToGeoJsonConverter.polygonCoordinatesFromWkt(polygons[i]);
        }
        String coordinates = Joiner.on(",").join(polygonsCoordinates);
        return String.format("[%s]", coordinates);
    }

    private static String lineStringCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        return WktToGeoJsonConverter.getJsonArrayFromListOfPoints(wkt);
    }

    private static String polygonCoordinatesFromWkt(String wkt) {
        String coordinates;
        boolean polygonContainsInnerHoles = (wkt = WktToGeoJsonConverter.removeBrackets(wkt, 2)).contains("(");
        if (polygonContainsInnerHoles) {
            String[] polygons = wkt.split("\\s*\\)\\s*,\\s*\\(\\s*");
            Object[] coordinatesOfPolygons = new String[polygons.length];
            for (int i = 0; i < polygons.length; ++i) {
                String polygonCoordinates = WktToGeoJsonConverter.getJsonArrayFromListOfPoints(polygons[i]);
                coordinatesOfPolygons[i] = polygonCoordinates;
            }
            coordinates = Joiner.on(",").join(coordinatesOfPolygons);
        } else {
            coordinates = WktToGeoJsonConverter.getJsonArrayFromListOfPoints(wkt);
        }
        return String.format("[%s]", coordinates);
    }

    private static String getJsonArrayFromListOfPoints(String pointsInWkt) {
        String[] points = pointsInWkt.split(",");
        ArrayList<String> coordinates = new ArrayList<String>();
        for (String point : points) {
            coordinates.add(WktToGeoJsonConverter.extractCoordinateFromPoint(point));
        }
        String joinedCoordinates = Joiner.on(",").join(coordinates);
        return String.format("[%s]", joinedCoordinates);
    }

    private static String buildGeoJson(String type2, String coordinates) {
        return String.format("{\"type\":\"%s\", \"coordinates\": %s}", type2, coordinates);
    }

    public static String pointCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        return WktToGeoJsonConverter.extractCoordinateFromPoint(wkt);
    }

    private static String extractCoordinateFromPoint(String point) {
        String pointPattern = "(\\s*)([0-9\\.-]+)(\\s*)([0-9\\.-]+)(\\s*)";
        return point.replaceAll(pointPattern, "[$2,$4]");
    }

    private static String removeBrackets(String wkt, int num) {
        String result2 = wkt;
        for (int i = 0; i < num; ++i) {
            int lastClosingBrackets = result2.lastIndexOf(")");
            int firstOpenBrackets = result2.indexOf("(");
            if (lastClosingBrackets == -1 || firstOpenBrackets == -1) {
                throw new IllegalArgumentException("Illegal syntax: " + wkt);
            }
            result2 = result2.substring(firstOpenBrackets + 1, lastClosingBrackets);
        }
        return result2;
    }
}

