# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AscLocation(Resource):
    """The ASC location of the subscription is in the "name" field.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: An empty set of properties.
    :vartype properties: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(self, *, properties: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword properties: An empty set of properties.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.properties = properties


class AscLocationList(_serialization.Model):
    """List of locations where ASC saves your data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2015_06_01_preview.models.AscLocation]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AscLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2015_06_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2015_06_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class Operation(_serialization.Model):
    """Possible operation in the REST API of Microsoft.Security.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar origin: Where the operation is originated.
    :vartype origin: str
    :ivar display: Security operation display.
    :vartype display: ~azure.mgmt.security.v2015_06_01_preview.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Security operation display.
        :paramtype display: ~azure.mgmt.security.v2015_06_01_preview.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.origin = None
        self.display = display


class OperationDisplay(_serialization.Model):
    """Security operation display.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar operation: The display name of the security operation.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationList(_serialization.Model):
    """List of possible operations for Microsoft.Security resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Security operations.
    :vartype value: list[~azure.mgmt.security.v2015_06_01_preview.models.Operation]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Security operations.
        :paramtype value: list[~azure.mgmt.security.v2015_06_01_preview.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SecurityTask(Resource):
    """Security task that we recommend to do in order to strengthen security.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: State of the task (Active, Resolved etc.).
    :vartype state: str
    :ivar creation_time_utc: The time this task was discovered in UTC.
    :vartype creation_time_utc: ~datetime.datetime
    :ivar security_task_parameters: Changing set of properties, depending on the task type that is
     derived from the name field.
    :vartype security_task_parameters:
     ~azure.mgmt.security.v2015_06_01_preview.models.SecurityTaskParameters
    :ivar last_state_change_time_utc: The time this task's details were last changed in UTC.
    :vartype last_state_change_time_utc: ~datetime.datetime
    :ivar sub_state: Additional data on the state of the task.
    :vartype sub_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "creation_time_utc": {"readonly": True},
        "last_state_change_time_utc": {"readonly": True},
        "sub_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time_utc": {"key": "properties.creationTimeUtc", "type": "iso-8601"},
        "security_task_parameters": {"key": "properties.securityTaskParameters", "type": "SecurityTaskParameters"},
        "last_state_change_time_utc": {"key": "properties.lastStateChangeTimeUtc", "type": "iso-8601"},
        "sub_state": {"key": "properties.subState", "type": "str"},
    }

    def __init__(
        self, *, security_task_parameters: Optional["_models.SecurityTaskParameters"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword security_task_parameters: Changing set of properties, depending on the task type that
         is derived from the name field.
        :paramtype security_task_parameters:
         ~azure.mgmt.security.v2015_06_01_preview.models.SecurityTaskParameters
        """
        super().__init__(**kwargs)
        self.state = None
        self.creation_time_utc = None
        self.security_task_parameters = security_task_parameters
        self.last_state_change_time_utc = None
        self.sub_state = None


class SecurityTaskList(_serialization.Model):
    """List of security task recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2015_06_01_preview.models.SecurityTask]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityTask]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityTaskParameters(_serialization.Model):
    """Changing set of properties, depending on the task type that is derived from the name field.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Name of the task type.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = None
