/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;

public final class DelayedReadValueModel
extends AbstractValueModel {
    private final ValueModel subject;
    private final Timer timer;
    private boolean coalesce;
    private Object oldValue;
    private PropertyChangeEvent pendingEvt;

    public DelayedReadValueModel(ValueModel subject, int delay) {
        this(subject, delay, false);
    }

    public DelayedReadValueModel(ValueModel subject, int delay, boolean coalesce) {
        this.subject = subject;
        this.coalesce = coalesce;
        this.timer = new Timer(delay, new ValueUpdateListener());
        this.timer.setRepeats(false);
        subject.addValueChangeListener(new SubjectValueChangeHandler());
        this.oldValue = subject.getValue();
    }

    @Override
    public Object getValue() {
        return this.isPending() ? this.oldValue : this.subject.getValue();
    }

    @Override
    public void setValue(Object newValue) {
        this.subject.setValue(newValue);
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void setDelay(int delay) {
        this.timer.setInitialDelay(delay);
        this.timer.setDelay(delay);
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(boolean b) {
        this.coalesce = b;
    }

    public void stop() {
        this.timer.stop();
    }

    public boolean isPending() {
        return this.timer.isRunning();
    }

    private void fireDelayedValueChange(PropertyChangeEvent evt) {
        this.pendingEvt = evt;
        if (this.coalesce) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DelayedReadValueModel.this.fireDelayedValueChange(evt);
        }
    }

    private final class ValueUpdateListener
    implements ActionListener {
        private ValueUpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DelayedReadValueModel.this.fireValueChange(DelayedReadValueModel.this.pendingEvt.getOldValue(), DelayedReadValueModel.this.pendingEvt.getNewValue(), true);
            DelayedReadValueModel.this.stop();
            DelayedReadValueModel.this.oldValue = DelayedReadValueModel.this.pendingEvt.getNewValue() != null ? DelayedReadValueModel.this.pendingEvt.getNewValue() : DelayedReadValueModel.this.subject.getValue();
        }
    }
}

