/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.HighlightablePropertyControl;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.resources.components.OptionPanelWindowConfigurationStorage;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.resources.components.PropertyPane;
import org.freeplane.core.resources.components.TabProperty;
import org.freeplane.core.ui.FileOpener;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;

class OptionPanel {
    private static final String FILE_EXTENSION = "freeplaneoptions";
    static final String PREFERENCE_STORAGE_PROPERTY = "OptionPanel_Window_Properties";
    private Vector<IPropertyControl> controls;
    private final IOptionPanelFeedback feedback;
    private final HashMap<String, Integer> tabStringToIndexMap = new HashMap();
    private final HashMap<Integer, String> tabIndexToStringMap = new HashMap();
    private String selectedPanel;
    private final JDialog topDialog;
    private JFileChooser fileChooser;
    private boolean arePropertyValidatorsEnabled;

    OptionPanel(JDialog d, IOptionPanelFeedback feedback) {
        this.topDialog = d;
        this.arePropertyValidatorsEnabled = false;
        this.feedback = feedback;
        new OptionPanelBuilder();
    }

    void enablePropertyValidators() {
        this.arePropertyValidatorsEnabled = true;
    }

    private static JPanel buildRightAlignedBar(JButton ... buttons) {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton((JComponent[])buttons);
        JPanel panel = builder.getPanel();
        JPanel outerPanel = new JPanel(new FlowLayout(2));
        outerPanel.add(panel);
        return outerPanel;
    }

    public void buildPanel(DefaultMutableTreeNode controlsTree) {
        JPanel centralPanel = new JPanel();
        centralPanel.setLayout(new GridLayout(1, 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setTabLayoutPolicy(1);
        this.initControls(controlsTree);
        Iterator<IPropertyControl> iterator = this.controls.iterator();
        int tabIndex = 0;
        PropertyPane propertyPane = null;
        while (iterator.hasNext()) {
            IPropertyControl control = iterator.next();
            if (control instanceof TabProperty) {
                TabProperty newTab = (TabProperty)control;
                propertyPane = new PropertyPane(newTab.getLayout());
                propertyPane.border((Border)Borders.DIALOG);
                JScrollPane bottomComponent = new JScrollPane(propertyPane);
                UITools.setScrollbarIncrement(bottomComponent);
                String tabId = newTab.getName();
                if (tabId == null) continue;
                String tabLabel = TextUtils.getOptionalText(newTab.getLabel());
                if (this.selectedPanel != null && this.selectedPanel.equals(tabLabel)) {
                    this.selectedPanel = tabId;
                }
                this.tabStringToIndexMap.put(tabId, tabIndex);
                this.tabIndexToStringMap.put(tabIndex, tabId);
                String displayedLabel = tabLabel != null ? tabLabel : newTab.getLabel();
                tabbedPane.addTab(displayedLabel, bottomComponent);
                ++tabIndex;
                continue;
            }
            propertyPane.addProperty(control);
        }
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JTabbedPane c = (JTabbedPane)event.getSource();
                OptionPanel.this.selectedPanel = (String)OptionPanel.this.tabIndexToStringMap.get(c.getSelectedIndex());
            }
        });
        centralPanel.add(tabbedPane);
        if (this.selectedPanel != null && this.tabStringToIndexMap.containsKey(this.selectedPanel)) {
            tabbedPane.setSelectedIndex(this.tabStringToIndexMap.get(this.selectedPanel));
        }
        this.topDialog.getContentPane().add((Component)centralPanel, "Center");
        FileOpener fileOpener = new FileOpener(FILE_EXTENSION, new FileOpener.Listener(){

            @Override
            public void filesDropped(Collection<URL> urls) throws Exception {
                for (URL url : urls) {
                    InputStream inputStream = url.openStream();
                    try {
                        OptionPanel.this.loadOptions(inputStream);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
        });
        new DropTarget(centralPanel, fileOpener);
        JButton saveButton = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(saveButton, TextUtils.getRawText("save"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.saveOptionsToFile();
            }
        });
        JButton loadButton = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(loadButton, TextUtils.getRawText("load"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.loadOptionsFromFile();
            }
        });
        JButton cancelButton = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(cancelButton, TextUtils.getRawText("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.closeWindow();
            }
        });
        JButton okButton = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(okButton, TextUtils.getRawText("ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (OptionPanel.this.validate()) {
                    OptionPanel.this.closeWindow();
                    OptionPanel.this.feedback.writeProperties(OptionPanel.this.getOptionProperties());
                }
            }
        });
        this.topDialog.getRootPane().setDefaultButton(okButton);
        JButton[] buttons = new JButton[]{saveButton, loadButton, cancelButton, okButton};
        JPanel buttonPanel = OptionPanel.buildRightAlignedBar(buttons);
        buttonPanel.setAlignmentX(1.0f);
        MnemonicSetter.INSTANCE.setComponentMnemonics(buttonPanel);
        this.topDialog.getContentPane().add((Component)buttonPanel, "South");
    }

    public void highlight(String selectedProperty) {
        for (IPropertyControl control : this.controls) {
            if (!selectedProperty.equals(control.getName()) || !(control instanceof HighlightablePropertyControl)) continue;
            HighlightablePropertyControl property = (HighlightablePropertyControl)control;
            property.highlight();
        }
    }

    private void saveOptionsToFile() {
        Properties properties = this.getOptionProperties();
        if (!this.validate(properties)) {
            return;
        }
        JFileChooser fileChooser = this.getFileChooser();
        int status = fileChooser.showSaveDialog((Component)this.topDialog);
        if (status != 0) {
            return;
        }
        File outputFile = this.getOutputFile(fileChooser);
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));){
            properties.store(output, "");
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    private File getOutputFile(JFileChooser fileChooser) {
        File outputFile = fileChooser.getSelectedFile();
        if (outputFile.getName().contains(".")) {
            return outputFile;
        }
        return new File(outputFile.getPath() + '.' + FILE_EXTENSION);
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = this.createFileChooser();
        }
        return this.fileChooser;
    }

    private JFileChooser createFileChooser() {
        JFileChooser fileChooser = UITools.newFileChooser(new File(Compat.getApplicationUserDirectory()));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(FILE_EXTENSION, FILE_EXTENSION);
        fileChooser.setFileFilter((FileFilter)filter);
        return fileChooser;
    }

    private void loadOptionsFromFile() {
        JFileChooser fileChooser = this.getFileChooser();
        int status = fileChooser.showOpenDialog((Component)this.topDialog);
        if (status != 0) {
            return;
        }
        File inputFile = fileChooser.getSelectedFile();
        if (!inputFile.canRead()) {
            return;
        }
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(inputFile));
            this.loadOptions(inStream);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    private void loadOptions(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (IPropertyControl control : this.controls) {
            PropertyBean bean;
            String name;
            String value;
            if (!(control instanceof PropertyBean) || (value = properties.getProperty(name = (bean = (PropertyBean)control).getName())) == null) continue;
            bean.setValue(value);
        }
    }

    private boolean validate() {
        Properties properties = this.getOptionProperties();
        return this.validate(properties);
    }

    private boolean validate(Properties properties) {
        if (!this.arePropertyValidatorsEnabled) {
            return true;
        }
        IValidator.ValidationResult result = new IValidator.ValidationResult();
        for (IValidator validator : Controller.getCurrentController().getOptionValidators()) {
            result.add(validator.validate(properties));
        }
        if (!result.isValid()) {
            UITools.errorMessage(this.formatErrors("OptionPanel.validation_error", result.getErrors()));
            LogUtils.severe(result.toString());
        } else if (result.hasWarnings()) {
            UITools.informationMessage(this.formatErrors("OptionPanel.validation_warning", result.getWarnings()));
            LogUtils.warn(result.toString());
        }
        return result.isValid();
    }

    private String formatErrors(String key, ArrayList<String> errors) {
        MessageFormat formatter = new MessageFormat(TextUtils.getText(key));
        return formatter.format(new Object[]{StringUtils.join(errors.iterator(), (String)"<br>")});
    }

    private void initControls(DefaultMutableTreeNode controlsTree) {
        this.controls = new Vector();
        this.addChildControls(null, controlsTree);
    }

    private void addChildControls(BooleanProperty parentControl, DefaultMutableTreeNode controlsTree) {
        Enumeration<TreeNode> i = controlsTree.children();
        while (i.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.nextElement();
            IPropertyControlCreator creator = (IPropertyControlCreator)node.getUserObject();
            if (creator != null) {
                String propertyName = creator.getPropertyName();
                if (ResourceController.getResourceController().getBooleanProperty(propertyName + ".hide")) continue;
                IPropertyControl control = creator.createControl();
                this.controls.add(control);
                if (parentControl != null) {
                    parentControl.enables(control);
                }
                this.addChildControls(this.asBooleanProperty(control), node);
                continue;
            }
            this.addChildControls(parentControl, node);
        }
    }

    private BooleanProperty asBooleanProperty(IPropertyControl control) {
        return control instanceof BooleanProperty ? (BooleanProperty)control : null;
    }

    public void closeWindow() {
        OptionPanelWindowConfigurationStorage storage = new OptionPanelWindowConfigurationStorage();
        storage.setPanel("OptionPanel." + this.selectedPanel);
        storage.storeDialogPositions(this.topDialog, PREFERENCE_STORAGE_PROPERTY);
        this.topDialog.setVisible(false);
        this.topDialog.dispose();
    }

    private Properties getOptionProperties() {
        Properties p = new Properties();
        for (IPropertyControl control : this.controls) {
            PropertyBean bean;
            String value;
            if (!(control instanceof PropertyBean) || (value = (bean = (PropertyBean)control).getValue()) == null) continue;
            p.setProperty(bean.getName(), value);
        }
        return p;
    }

    public void setProperties() {
        for (IPropertyControl control : this.controls) {
            if (!(control instanceof PropertyBean)) continue;
            PropertyBean bean = (PropertyBean)control;
            String name = bean.getName();
            String value = ResourceController.getResourceController().getProperty(name);
            bean.setValue(value);
        }
    }

    void setSelectedPanel(String panel) {
        if (panel.startsWith("OptionPanel.")) {
            this.selectedPanel = panel.substring("OptionPanel.".length());
        }
    }

    static interface IOptionPanelFeedback {
        public void writeProperties(Properties var1);
    }
}

