/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.graph;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.traverse.DepthFirstIterator;

public class GraphExplorer {
    static <V, E> void exploreGraph(Graph<Object, E> graph, Iterable<V> startVertices, Function<V, Stream<V>> outgoingEdgesProvider, Function<V, Stream<V>> incomingEdgesProvider) {
        Class<?> vertexClass = startVertices.iterator().next().getClass();
        BothDirectionsIterator iterator = new BothDirectionsIterator(graph, startVertices);
        while (iterator.hasNext()) {
            Object currentElement = iterator.next();
            if (!vertexClass.isInstance(currentElement)) continue;
            Stream<V> outgoingElements = outgoingEdgesProvider.apply(currentElement);
            outgoingElements.forEach(outgoingElement -> {
                graph.addVertex(outgoingElement);
                graph.addEdge(currentElement, outgoingElement);
            });
            Stream<V> incomingElements = incomingEdgesProvider.apply(currentElement);
            incomingElements.forEach(incomingElement -> {
                graph.addVertex(incomingElement);
                graph.addEdge(incomingElement, currentElement);
            });
        }
    }

    private static final class BothDirectionsIterator<V, E>
    extends DepthFirstIterator<V, E> {
        private BothDirectionsIterator(Graph<V, E> g, Iterable<V> startVertices) {
            super(g, startVertices);
        }

        protected Set<E> selectOutgoingEdges(V vertex) {
            Set outgoingEdges = this.graph.outgoingEdgesOf(vertex);
            Set incomingEdges = this.graph.incomingEdgesOf(vertex);
            return this.combine(outgoingEdges, incomingEdges);
        }

        private Set<E> combine(Set<E> outgoingEdges, Set<E> incomingEdges) {
            if (outgoingEdges.isEmpty()) {
                return incomingEdges;
            }
            if (incomingEdges.isEmpty()) {
                return outgoingEdges;
            }
            HashSet<E> combinedEdges = new HashSet<E>(outgoingEdges);
            combinedEdges.addAll(incomingEdges);
            return combinedEdges;
        }
    }
}

