/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapperDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.CommitToolWindowUtil;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerChangesTreeTracker;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.TwoStepAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.vcs.impl.shared.changes.DiffPreviewUpdateProcessor;
import com.intellij.platform.vcs.impl.shared.changes.PreviewDiffSplitterComponent;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.FontUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private static final String SHELVE_PREVIEW_SPLITTER_PROPORTION = "ShelvedChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NonNls
    static final String SHELVED_CHANGES_TOOLBAR = "ShelvedChangesToolbar";
    private final Project myProject;
    private final MergingUpdateQueue myUpdateQueue;
    private final List<Runnable> myPostUpdateEdtActivity;
    @Nullable
    private ShelfToolWindowPanel myPanel;
    public static final String HELP_ID = "ideaInterface.shelf";
    public static final DataKey<ChangesTree> SHELVED_CHANGES_TREE = DataKey.create((String)"ShelveChangesManager.ShelvedChangesTree");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_DELETED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedDeletedChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");

    public static ShelvedChangesViewManager getInstance(@NotNull Project project) {
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(0);
        }
        return (ShelvedChangesViewManager)project.getService(ShelvedChangesViewManager.class);
    }

    ShelvedChangesViewManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(1);
        }
        if (coroutineScope == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(2);
        }
        this.myPostUpdateEdtActivity = new ArrayList<Runnable>();
        this.myPanel = null;
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue("Update Shelf Content", 200, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.SWING_THREAD, coroutineScope);
        project.getMessageBus().connect(coroutineScope).subscribe(ShelveChangesManager.SHELF_TOPIC, () -> this.scheduleTreeUpdate());
    }

    private void scheduleTreeUpdate() {
        this.myUpdateQueue.queue(Update.create((Object)"update", () -> this.updateTreeModel()));
    }

    @RequiresEdt
    @NotNull
    private ShelfToolWindowPanel initToolWindowPanel() {
        if (this.myPanel == null) {
            Activity activity = StartUpMeasurer.startActivity((String)"ShelvedChangesViewManager initialization");
            this.myPanel = new ShelfToolWindowPanel(this.myProject);
            Disposer.register((Disposable)this.myPanel, () -> {
                this.myPanel = null;
            });
            this.updateTreeModel();
            activity.end();
        }
        ShelfToolWindowPanel shelfToolWindowPanel = this.myPanel;
        if (shelfToolWindowPanel == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(3);
        }
        return shelfToolWindowPanel;
    }

    public void activateView(@Nullable ShelvedChangeList list) {
        this.activateAndUpdate(() -> {
            if (list != null) {
                this.selectShelvedList(list);
            }
        });
    }

    @NotNull
    private static Set<ShelvedChangeList> getSelectedLists(@NotNull ChangesTree tree, @NotNull Predicate<? super ShelvedChangeList> condition) {
        Object[] selectionPaths;
        if (tree == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(4);
        }
        if (condition == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(5);
        }
        if ((selectionPaths = tree.getSelectionPaths()) == null) {
            Set<ShelvedChangeList> set = Collections.emptySet();
            if (set == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set set = (Set)((StreamEx)((StreamEx)StreamEx.of((Object[])selectionPaths).map(path -> (ShelvedChangeList)TreeUtil.findObjectInPath((TreePath)path, ShelvedChangeList.class)).filter(Predicates.nonNull())).filter(condition)).collect(Collectors.toSet());
        if (set == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    static ListSelection<ShelvedWrapper> getSelectedChangesOrAll(@NotNull DataContext dataContext) {
        List<ShelvedWrapper> allWrappers;
        ChangesBrowserNode changeListNode;
        ShelvedChangeList changeList;
        ChangesTree tree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(8);
        }
        if ((tree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE))) == null) {
            ListSelection listSelection = ListSelection.empty();
            if (listSelection == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(9);
            }
            return listSelection;
        }
        ListSelection wrappers = ListSelection.createAt(VcsTreeModelData.selected((JTree)((Object)tree)).userObjects(ShelvedWrapper.class), (int)0);
        if (wrappers.getList().size() == 1 && (changeList = (ShelvedChangeList)ContainerUtil.getFirstItem(ShelvedChangesViewManager.getSelectedLists(tree, it -> true))) != null && (changeListNode = (ChangesBrowserNode)TreeUtil.findNodeWithObject(tree.getRoot(), (Object)changeList)) != null && (allWrappers = changeListNode.getAllObjectsUnder(ShelvedWrapper.class)).size() > 1) {
            ShelvedWrapper toSelect = (ShelvedWrapper)ContainerUtil.getFirstItem((List)wrappers.getList());
            ListSelection listSelection = ListSelection.create(allWrappers, (Object)toSelect);
            if (listSelection == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(10);
            }
            return listSelection;
        }
        ListSelection listSelection = wrappers.asExplicitSelection();
        if (listSelection == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(11);
        }
        return listSelection;
    }

    private void updateTreeIfShown(@NotNull Consumer<? super ShelfTree> treeConsumer) {
        if (treeConsumer == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(12);
        }
        if (this.myPanel != null) {
            treeConsumer.consume((Object)this.myPanel.myTree);
        }
    }

    @RequiresEdt
    void updateTreeView() {
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.rebuildTree()));
    }

    @ApiStatus.Internal
    public static boolean hideDefaultShelfTab(@NotNull Project project) {
        AbstractVcs singleVcs;
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(13);
        }
        if ((singleVcs = ProjectLevelVcsManager.getInstance((Project)project).getSingleVCS()) == null) {
            return false;
        }
        return singleVcs.isWithCustomShelves();
    }

    protected void removeContent(Content content) {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.removeContent(content);
        contentManager.selectContent("Local Changes");
    }

    protected void addContent(Content content) {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content);
    }

    protected void activateContent() {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.selectContent("Shelf");
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        if (window != null && !window.isVisible()) {
            window.activate(null);
        }
    }

    @RequiresEdt
    private void updateTreeModel() {
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.invalidateDataAndRefresh(() -> ApplicationManager.getApplication().invokeLater(() -> {
            this.myPostUpdateEdtActivity.forEach(Runnable::run);
            this.myPostUpdateEdtActivity.clear();
        }, ModalityState.nonModal(), this.myProject.getDisposed()))));
    }

    @RequiresEdt
    public void startEditing(@NotNull ShelvedChangeList shelvedChangeList) {
        if (shelvedChangeList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(14);
        }
        this.activateAndUpdate(() -> {
            this.selectShelvedList(shelvedChangeList);
            this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.startEditingAtPath(tree.getLeadSelectionPath())));
        });
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(15);
        }
        ArrayList<ShelvedChangeList> shelvedChangeLists = new ArrayList<ShelvedChangeList>();
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_CHANGELIST_KEY.getData(dataContext))));
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext))));
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_DELETED_CHANGELIST_KEY.getData(dataContext))));
        ArrayList<ShelvedChangeList> arrayList = shelvedChangeLists;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public static List<ShelvedChangeList> getExactlySelectedLists(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(17);
        }
        if ((shelvedChangeTree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE))) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        List list = VcsTreeModelData.exactlySelected((JTree)((Object)shelvedChangeTree)).iterateUserObjects(ShelvedChangeList.class).toList();
        if (list == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    private void activateAndUpdate(@NotNull Runnable postUpdateRunnable) {
        if (postUpdateRunnable == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(20);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)this.myProject.getDisposed(), () -> {
            this.activateContent();
            this.myUpdateQueue.cancelAllUpdates();
            this.myPostUpdateEdtActivity.add(postUpdateRunnable);
            this.updateTreeModel();
        });
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    public void updateOnVcsMappingsChanged() {
        ApplicationManager.getApplication().invokeLater(() -> this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
            ChangesGroupingSupport treeGroupingSupport = tree.getGroupingSupport();
            if (treeGroupingSupport.isAvailable("repository") && treeGroupingSupport.get("repository")) {
                tree.onGroupingChanged();
            }
        })), this.myProject.getDisposed());
    }

    public void selectShelvedList(@NotNull ShelvedChangeList list) {
        if (list == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(21);
        }
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
            DefaultMutableTreeNode treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)tree.getModel().getRoot()), (Object)list);
            if (treeNode == null) {
                LOG.warn(VcsBundle.message((String)"shelve.changelist.not.found", (Object[])new Object[]{list.getDescription()}));
                return;
            }
            TreeUtil.selectNode((JTree)((Object)tree), (TreeNode)treeNode);
        }));
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(22);
        }
        List list = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_CHANGE_KEY)));
        if (list == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_BINARY_FILE_KEY)));
        if (list == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public static List<String> getSelectedShelvedChangeNames(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(26);
        }
        if ((shelvedChangeTree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE))) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(27);
            }
            return list;
        }
        List list = VcsTreeModelData.selected((JTree)((Object)shelvedChangeTree)).iterateUserObjects(ShelvedWrapper.class).map(ShelvedWrapper::getPath).toList();
        if (list == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<ShelvedChange> getChangesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedChange> shelvedChanges) {
        if (listsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(29);
        }
        if (shelvedChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(30);
        }
        ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
        listsToDelete.stream().map(list -> Objects.requireNonNull(list.getChanges())).forEach(result2::removeAll);
        ArrayList<ShelvedChange> arrayList = result2;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    @Nls
    private static HtmlChunk constructDeleteSuccessfullyMessage(int shelvedFilesToDeleteSize, @NotNull List<ShelvedChangeList> shelvedListsToDelete) {
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(32);
        }
        String filesMessage = shelvedFilesToDeleteSize != 0 ? VcsBundle.message((String)"shelve.delete.files.successful.message", (Object[])new Object[]{shelvedFilesToDeleteSize}) : "";
        String listsMessage = "";
        int shelvedListsToDeleteSize = shelvedListsToDelete.size();
        if (shelvedListsToDeleteSize > 0) {
            ShelvedChangeList singleDeletedList = (ShelvedChangeList)ContainerUtil.getOnlyItem(shelvedListsToDelete);
            listsMessage = singleDeletedList != null ? VcsBundle.message((String)"shelve.delete.changelist.name.message", (Object[])new Object[]{singleDeletedList.getDescription()}) : VcsBundle.message((String)"shelve.delete.changelists.count.message", (Object[])new Object[]{shelvedListsToDeleteSize});
        }
        String message = VcsBundle.message((String)"shelve.delete.successful.message", (Object[])new Object[]{filesMessage, shelvedFilesToDeleteSize > 0 && shelvedListsToDeleteSize > 0 ? 1 : 0, listsMessage});
        HtmlChunk htmlChunk = HtmlChunk.text((String)StringUtil.capitalize((String)message));
        if (htmlChunk == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(33);
        }
        return htmlChunk;
    }

    public static void deleteShelves(@NotNull Project project, @NotNull List<ShelvedChangeList> shelvedListsToDelete) {
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(34);
        }
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(35);
        }
        ShelvedChangesViewManager.deleteShelves(project, shelvedListsToDelete, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @ApiStatus.Internal
    public static void deleteShelves(@NotNull Project project, @NotNull List<ShelvedChangeList> shelvedListsToDelete, @NotNull List<ShelvedChangeList> shelvedListsFromChanges, @NotNull List<ShelvedChange> selectedChanges, @NotNull List<ShelvedBinaryFile> selectedBinaryChanges) {
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(36);
        }
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(37);
        }
        if (shelvedListsFromChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(38);
        }
        if (selectedChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(39);
        }
        if (selectedBinaryChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(40);
        }
        List<ShelvedChange> changesToDelete = ShelvedChangesViewManager.getChangesNotInLists(shelvedListsToDelete, selectedChanges);
        List<ShelvedBinaryFile> binariesToDelete = ShelvedChangesViewManager.getBinariesNotInLists(shelvedListsToDelete, selectedBinaryChanges);
        ShelveChangesManager manager = ShelveChangesManager.getInstance(project);
        int fileListSize = binariesToDelete.size() + changesToDelete.size();
        Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDates = manager.deleteShelves(shelvedListsToDelete, shelvedListsFromChanges, changesToDelete, binariesToDelete);
        if (!createdDeletedListsWithOriginalDates.isEmpty()) {
            ShelvedChangesViewManager.showUndoDeleteNotification(project, shelvedListsToDelete, fileListSize, createdDeletedListsWithOriginalDates);
        }
    }

    private static void showUndoDeleteNotification(@NotNull Project project, @NotNull List<ShelvedChangeList> shelvedListsToDelete, int shelvedFilesToDeleteSize, @NotNull Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDate) {
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(41);
        }
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(42);
        }
        if (createdDeletedListsWithOriginalDate == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(43);
        }
        HtmlChunk message = ShelvedChangesViewManager.constructDeleteSuccessfullyMessage(shelvedFilesToDeleteSize, shelvedListsToDelete);
        Notification shelfDeletionNotification = new Notification(VcsNotifier.standardNotification().getDisplayId(), message.toString(), NotificationType.INFORMATION);
        shelfDeletionNotification.setDisplayId("vcs.shelf.undo.delete");
        shelfDeletionNotification.addAction((AnAction)new UndoShelfDeletionAction(project, createdDeletedListsWithOriginalDate));
        VcsNotifier.getInstance(project).showNotificationAndHideExisting(shelfDeletionNotification);
    }

    private static List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedBinaryFile> binaryFiles) {
        if (listsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(44);
        }
        if (binaryFiles == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(45);
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
        for (ShelvedChangeList list : listsToDelete) {
            result2.removeAll(list.getBinaryFiles());
        }
        return result2;
    }

    private static boolean canHandleDropEvent(@NotNull Project project, @NotNull DnDEvent event) {
        Object attachedObject;
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(46);
        }
        if (event == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(47);
        }
        if ((attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean) {
            List<Change> changes = ((ChangeListDragBean)attachedObject).getChanges();
            return !changes.isEmpty();
        }
        return false;
    }

    private static void handleDropEvent(@NotNull Project project, @NotNull DnDEvent event) {
        Object attachedObject;
        if (project == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(48);
        }
        if (event == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(49);
        }
        if ((attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean) {
            FileDocumentManager.getInstance().saveAllDocuments();
            List<Change> changes = ((ChangeListDragBean)attachedObject).getChanges();
            ShelveChangesManager.getInstance(project).shelveSilentlyUnderProgress(changes, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 9, 10, 11, 16, 18, 19, 23, 25, 27, 28, 31, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeConsumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postUpdateRunnable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 29: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listsToDelete";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 32: 
            case 35: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsToDelete";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsFromChanges";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChanges";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBinaryChanges";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeletedListsWithOriginalDate";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initToolWindowPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLists";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangesOrAll";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelvedLists";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactlySelectedLists";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelveChanges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryShelveChanges";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedShelvedChangeNames";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesNotInLists";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDeleteSuccessfullyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChangesOrAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeIfShown";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hideDefaultShelfTab";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startEditing";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getShelvedLists";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExactlySelectedLists";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "activateAndUpdate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "selectShelvedList";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShelveChanges";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryShelveChanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedShelvedChangeNames";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getChangesNotInLists";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "constructDeleteSuccessfullyMessage";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "deleteShelves";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showUndoDeleteNotification";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getBinariesNotInLists";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "canHandleDropEvent";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "handleDropEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 9, 10, 11, 16, 18, 19, 23, 25, 27, 28, 31, 33 -> new IllegalStateException(string);
        };
    }

    private static final class ShelfToolWindowPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        private final Project myProject;
        private final ShelveChangesManager myShelveChangesManager;
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final Wrapper myMainPanelContent;
        @NotNull
        private final JPanel myShelvePanel;
        @NotNull
        private final JScrollPane myTreeScrollPane;
        private final ShelfTree myTree;
        @NotNull
        private final ShelveEditorDiffPreview myEditorDiffPreview;
        @Nullable
        private ShelveSplitterDiffPreview mySplitterDiffPreview;
        private boolean myDisposed;

        private ShelfToolWindowPanel(@NotNull Project project) {
            if (project == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(0);
            }
            super(true);
            this.myMainPanelContent = new Wrapper();
            this.myProject = project;
            this.myShelveChangesManager = ShelveChangesManager.getInstance(this.myProject);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myTree = new ShelfTree(this.myProject);
            this.myTree.setEditable(true);
            this.myTree.setDragEnabled(!ApplicationManager.getApplication().isHeadlessEnvironment());
            this.myTree.setCellEditor(new ShelveRenameTreeCellEditor());
            AnAction showDiffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
            showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            EditSourceAction editSourceAction = new EditSourceAction();
            editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            actionGroup.addAll((ActionGroup)ActionManager.getInstance().getAction(ShelvedChangesViewManager.SHELVED_CHANGES_TOOLBAR));
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new MyToggleDetailsAction());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup, true);
            toolbar.setTargetComponent((JComponent)((Object)this.myTree));
            this.myTreeScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (boolean)true);
            this.myShelvePanel = JBUI.Panels.simplePanel((Component)this.myTreeScrollPane).addToTop((Component)toolbar.getComponent());
            this.myMainPanelContent.setContent((JComponent)this.myShelvePanel);
            this.setContent((JComponent)this.myMainPanelContent);
            this.myEditorDiffPreview = new ShelveEditorDiffPreview();
            Disposer.register((Disposable)this, (Disposable)this.myEditorDiffPreview);
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
            ChangesViewContentManagerKt.subscribeOnVcsToolWindowLayoutChanges(busConnection, this::updatePanelLayout);
            this.updatePanelLayout();
            PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)ShelvedChangesViewManager.SHELF_CONTEXT_MENU);
            new MyDnDSupport(this.myProject, this.myTree, this.myTreeScrollPane).install(this);
        }

        public void dispose() {
            this.myDisposed = true;
            if (this.mySplitterDiffPreview != null) {
                Disposer.dispose((Disposable)this.mySplitterDiffPreview);
            }
            this.mySplitterDiffPreview = null;
            this.myTree.shutdown();
        }

        private void updatePanelLayout() {
            boolean needUpdatePreview;
            boolean isVertical = ChangesViewContentManager.isToolWindowTabVertical(this.myProject, "Shelf");
            boolean hasSplitterPreview = ChangesViewContentManager.shouldHaveSplitterDiffPreview(this.myProject, isVertical);
            boolean bl = needUpdatePreview = hasSplitterPreview != (this.mySplitterDiffPreview != null);
            if (!needUpdatePreview) {
                return;
            }
            if (hasSplitterPreview) {
                this.mySplitterDiffPreview = new ShelveSplitterDiffPreview();
                DiffPreview.setPreviewVisible((DiffPreview)this.mySplitterDiffPreview, (boolean)this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN);
            } else {
                Disposer.dispose((Disposable)this.mySplitterDiffPreview);
                this.mySplitterDiffPreview = null;
            }
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(1);
            }
            super.uiDataSnapshot(sink);
            sink.set(DiffDataKeys.EDITOR_TAB_DIFF_PREVIEW, (Object)this.myEditorDiffPreview);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ShelveRenameTreeCellEditor
        extends DefaultTreeCellEditor
        implements CellEditorListener {
            ShelveRenameTreeCellEditor() {
                super((JTree)((Object)ShelfToolWindowPanel.this.myTree), null);
                this.addCellEditorListener(this);
            }

            @Override
            public boolean isCellEditable(EventObject event) {
                return !(event instanceof MouseEvent) && super.isCellEditable(event);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                TreeNode node = (TreeNode)ShelfToolWindowPanel.this.myTree.getLastSelectedPathComponent();
                if (node instanceof ShelvedListNode) {
                    ShelvedListNode changeListNode = (ShelvedListNode)node;
                    Object object = e.getSource();
                    if (object instanceof TreeCellEditor) {
                        TreeCellEditor treeCellEditor = (TreeCellEditor)object;
                        String editorValue = treeCellEditor.getCellEditorValue().toString();
                        ShelvedChangeList shelvedChangeList = changeListNode.getList();
                        ShelfToolWindowPanel.this.myShelveChangesManager.renameChangeList(shelvedChangeList, editorValue);
                    }
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        }

        private class MyToggleDetailsAction
        extends ShowDiffPreviewAction {
            private MyToggleDetailsAction() {
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(ShelfToolWindowPanel.this.mySplitterDiffPreview != null || isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(2);
                }
                DiffPreview previewSplitter = (DiffPreview)ObjectUtils.chooseNotNull((Object)ShelfToolWindowPanel.this.mySplitterDiffPreview, (Object)((Object)ShelfToolWindowPanel.this.myEditorDiffPreview));
                DiffPreview.setPreviewVisible((DiffPreview)previewSplitter, (boolean)state);
                ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(3);
                }
                return ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyToggleDetailsAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyToggleDetailsAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        private class ShelveEditorDiffPreview
        extends TreeHandlerEditorDiffPreview {
            private ShelveEditorDiffPreview() {
                super(ShelfToolWindowPanel.this.myTree, ShelfToolWindowPanel.this.myTreeScrollPane, MyShelvedPreviewProcessor.ShelveTreeDiffPreviewHandler.INSTANCE);
            }

            @Override
            @NotNull
            protected DiffEditorViewer createViewer() {
                return new MyShelvedPreviewProcessor(ShelfToolWindowPanel.this.myProject, ShelfToolWindowPanel.this.myTree, true);
            }

            @Override
            public void returnFocusToTree() {
                ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(ShelfToolWindowPanel.this.myProject, "Shelf");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            }

            public boolean openPreview(boolean requestFocus) {
                return CommitToolWindowUtil.openDiff("Shelf", this, requestFocus);
            }

            public void updateDiffAction(@NotNull AnActionEvent event) {
                if (event == null) {
                    ShelveEditorDiffPreview.$$$reportNull$$$0(0);
                }
                DiffShelvedChangesActionProvider.updateAvailability(event);
            }

            @Override
            @Nullable
            public String getEditorTabName(@Nullable ChangeViewDiffRequestProcessor.Wrapper wrapper2) {
                return wrapper2 != null ? VcsBundle.message((String)"shelve.editor.diff.preview.title", (Object[])new Object[]{wrapper2.getPresentableName()}) : VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]);
            }

            @Override
            protected boolean isOpenPreviewWithSingleClickEnabled() {
                return isOpenEditorDiffPreviewWithSingleClick.asBoolean();
            }

            @Override
            protected boolean isOpenPreviewWithSingleClick() {
                if (ShelfToolWindowPanel.this.mySplitterDiffPreview != null && ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN) {
                    return false;
                }
                return super.isOpenPreviewWithSingleClick();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$ShelveEditorDiffPreview", "updateDiffAction"));
            }
        }

        private static class MyDnDSupport
        implements DnDDropHandler,
        DnDTargetChecker {
            @NotNull
            private final Project myProject;
            @NotNull
            private final ChangesTree myTree;
            @NotNull
            private final JScrollPane myTreeScrollPane;

            private MyDnDSupport(@NotNull Project project, @NotNull ChangesTree tree, @NotNull JScrollPane treeScrollPane) {
                if (project == null) {
                    MyDnDSupport.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    MyDnDSupport.$$$reportNull$$$0(1);
                }
                if (treeScrollPane == null) {
                    MyDnDSupport.$$$reportNull$$$0(2);
                }
                this.myProject = project;
                this.myTree = tree;
                this.myTreeScrollPane = treeScrollPane;
            }

            public void install(@NotNull Disposable disposable) {
                if (disposable == null) {
                    MyDnDSupport.$$$reportNull$$$0(3);
                }
                DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setDisposableParent(disposable).install();
            }

            public void drop(DnDEvent aEvent) {
                ShelvedChangesViewManager.handleDropEvent(this.myProject, aEvent);
            }

            public boolean update(DnDEvent aEvent) {
                aEvent.hideHighlighter();
                aEvent.setDropPossible(false, "");
                boolean canHandle = ShelvedChangesViewManager.canHandleDropEvent(this.myProject, aEvent);
                if (!canHandle) {
                    return true;
                }
                Rectangle tableCellRect = new Rectangle(0, 0, JBUI.scale((int)300), JBUI.scale((int)12));
                aEvent.setHighlighting(new RelativeRectangle((Component)this.myTreeScrollPane, tableCellRect), 1);
                aEvent.setDropPossible(true);
                return false;
            }

            @Nullable
            private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
                if (info == null) {
                    MyDnDSupport.$$$reportNull$$$0(4);
                }
                if (info.isMove()) {
                    DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
                    return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
                }
                return null;
            }

            @NotNull
            private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
                if (info == null) {
                    MyDnDSupport.$$$reportNull$$$0(5);
                }
                String imageText = VcsBundle.message((String)"unshelve.changes.action", (Object[])new Object[0]);
                DnDImage dnDImage = ChangesTreeDnDSupport.createDragImage(this.myTree, imageText);
                if (dnDImage == null) {
                    MyDnDSupport.$$$reportNull$$$0(6);
                }
                return dnDImage;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "treeScrollPane";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "disposable";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyDnDSupport";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyDnDSupport";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDraggedImage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "install";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createDragStartBean";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createDraggedImage";
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 6 -> new IllegalStateException(string);
                };
            }
        }

        private class ShelveSplitterDiffPreview
        implements DiffPreview,
        Disposable {
            private final MyShelvedPreviewProcessor myProcessor;
            private final PreviewDiffSplitterComponent mySplitterComponent;

            private ShelveSplitterDiffPreview() {
                this.myProcessor = new MyShelvedPreviewProcessor(ShelfToolWindowPanel.this.myProject, ShelfToolWindowPanel.this.myTree, false);
                this.mySplitterComponent = new PreviewDiffSplitterComponent((DiffPreviewUpdateProcessor)this.myProcessor, ShelvedChangesViewManager.SHELVE_PREVIEW_SPLITTER_PROPORTION);
                this.mySplitterComponent.setFirstComponent((JComponent)ShelfToolWindowPanel.this.myShelvePanel);
                ShelfToolWindowPanel.this.myMainPanelContent.setContent((JComponent)this.mySplitterComponent);
            }

            public void dispose() {
                Disposer.dispose((Disposable)this.myProcessor);
                if (!ShelfToolWindowPanel.this.myDisposed) {
                    ShelfToolWindowPanel.this.myMainPanelContent.setContent((JComponent)ShelfToolWindowPanel.this.myShelvePanel);
                }
            }

            public boolean openPreview(boolean requestFocus) {
                return this.mySplitterComponent.openPreview(requestFocus);
            }

            public void closePreview() {
                this.mySplitterComponent.closePreview();
            }
        }
    }

    private static final class ShelfTree
    extends AsyncChangesTree {
        private final DeleteProvider myDeleteProvider;
        private final ShelfTreeAsyncModel myAsyncTreeModel;

        private ShelfTree(@NotNull Project project) {
            if (project == null) {
                ShelfTree.$$$reportNull$$$0(0);
            }
            super(project, false, false, false);
            this.myDeleteProvider = new MyShelveDeleteProvider(this.myProject, this);
            this.myAsyncTreeModel = new ShelfTreeAsyncModel(project, this.getScope());
            this.setKeepTreeState(true);
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            ShelfTreeAsyncModel shelfTreeAsyncModel = this.myAsyncTreeModel;
            if (shelfTreeAsyncModel == null) {
                ShelfTree.$$$reportNull$$$0(1);
            }
            return shelfTreeAsyncModel;
        }

        public boolean isPathEditable(TreePath path) {
            return this.isEditable() && this.getSelectionCount() == 1 && path.getLastPathComponent() instanceof ShelvedListNode;
        }

        @Override
        @NotNull
        protected ChangesGroupingSupport installGroupingSupport() {
            ChangesGroupingSupport groupingSupport = new ChangesGroupingSupport(this.myProject, (Object)this, false);
            ChangesTree.installGroupingSupport((ChangesTree)this, groupingSupport, () -> ShelveChangesManager.getInstance(this.myProject).getGrouping(), (? super Collection<String> newGrouping) -> ShelveChangesManager.getInstance(this.myProject).setGrouping((Collection<String>)newGrouping));
            ChangesGroupingSupport changesGroupingSupport = groupingSupport;
            if (changesGroupingSupport == null) {
                ShelfTree.$$$reportNull$$$0(2);
            }
            return changesGroupingSupport;
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            List<ShelvedWrapper> shelvedChanges;
            if (sink == null) {
                ShelfTree.$$$reportNull$$$0(3);
            }
            super.uiDataSnapshot(sink);
            sink.set(SHELVED_CHANGES_TREE, (Object)this);
            sink.set(SHELVED_CHANGELIST_KEY, new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> !l.isRecycled() && !l.isDeleted())));
            sink.set(SHELVED_RECYCLED_CHANGELIST_KEY, new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isRecycled() && !l.isDeleted())));
            sink.set(SHELVED_DELETED_CHANGELIST_KEY, new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isDeleted())));
            sink.set(SHELVED_CHANGE_KEY, (Object)VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(ShelvedWrapper.class).filterMap(s -> s.getShelvedChange()).toList());
            sink.set(SHELVED_BINARY_FILE_KEY, (Object)VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(ShelvedWrapper.class).filterMap(s -> s.getBinaryFile()).toList());
            if (!this.isEditing()) {
                sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)this.myDeleteProvider);
            }
            if (!(shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class)).isEmpty()) {
                sink.set(VcsDataKeys.CHANGES, (Object)((Change[])ContainerUtil.map2Array(shelvedChanges, Change.class, s -> s.getChangeWithLocal(this.myProject))));
            }
            sink.set(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)this.getNavigatables(shelvedChanges).toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY));
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)ShelvedChangesViewManager.HELP_ID);
        }

        @NotNull
        private List<Navigatable> getNavigatables(@NotNull List<ShelvedWrapper> shelvedChanges) {
            if (shelvedChanges == null) {
                ShelfTree.$$$reportNull$$$0(4);
            }
            ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
            for (final ShelvedWrapper shelvedChange : shelvedChanges) {
                if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                NavigatableAdapter navigatable = new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        VirtualFile vf = shelvedChange.getBeforeVFUnderProject(myProject);
                        if (vf != null) {
                            1.navigate((Project)myProject, (VirtualFile)vf, (boolean)true);
                        }
                    }
                };
                navigatables.add((Navigatable)navigatable);
            }
            ArrayList<Navigatable> arrayList = navigatables;
            if (arrayList == null) {
                ShelfTree.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        public void invalidateDataAndRefresh(@Nullable Runnable onRefreshed) {
            this.myAsyncTreeModel.invalidateData();
            this.requestRefresh(onRefreshed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installGroupingSupport";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class UndoShelfDeletionAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<ShelvedChangeList, Date> myListDateMap;

        private UndoShelfDeletionAction(@NotNull Project project, @NotNull Map<ShelvedChangeList, Date> listDateMap) {
            if (project == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(0);
            }
            if (listDateMap == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(1);
            }
            super(IdeBundle.messagePointer((String)"undo.dialog.title", (Object[])new Object[0]));
            this.myProject = project;
            this.myListDateMap = listDateMap;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(2);
            }
            if (notification == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(3);
            }
            ShelveChangesManager manager = ShelveChangesManager.getInstance(this.myProject);
            List cantRestoreList = ContainerUtil.findAll(this.myListDateMap.keySet(), l -> l == null || !manager.getDeletedLists().contains(l));
            this.myListDateMap.forEach((l, d) -> manager.restoreList((ShelvedChangeList)l, (Date)d));
            notification.expire();
            if (!cantRestoreList.isEmpty()) {
                VcsNotifier.getInstance(this.myProject).notifyMinorWarning("vcs.shelve.deletion.undo", VcsBundle.message((String)"shelve.undo.deletion", (Object[])new Object[0]), VcsBundle.message((String)"shelve.changes.restore.error", (Object[])new Object[]{cantRestoreList.size()}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listDateMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$UndoShelfDeletionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShelvedChangeNode
    extends ChangesBrowserNode<ShelvedWrapper>
    implements Comparable<ShelvedChangeNode> {
        @NotNull
        private final ShelvedWrapper myShelvedChange;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        @Nls
        private final String myAdditionalText;

        protected ShelvedChangeNode(@NotNull ShelvedWrapper shelvedChange, @NotNull FilePath filePath, @Nullable @Nls String additionalText) {
            if (shelvedChange == null) {
                ShelvedChangeNode.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                ShelvedChangeNode.$$$reportNull$$$0(1);
            }
            super(shelvedChange);
            this.myShelvedChange = shelvedChange;
            this.myFilePath = filePath;
            this.myAdditionalText = additionalText;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            if (renderer == null) {
                ShelvedChangeNode.$$$reportNull$$$0(2);
            }
            String path = this.myShelvedChange.getRequestName();
            String directory = StringUtil.defaultIfEmpty((String)PathUtil.getParentPath((String)path), (String)VcsBundle.message((String)"shelve.default.path.rendering", (Object[])new Object[0]));
            String fileName = StringUtil.defaultIfEmpty((String)PathUtil.getFileName((String)path), (String)path);
            renderer.append(fileName, new SimpleTextAttributes(0, this.myShelvedChange.getFileStatus().getColor()));
            if (this.myAdditionalText != null) {
                renderer.append(FontUtil.spaceAndThinSpace() + this.myAdditionalText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (renderer.isShowFlatten()) {
                renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.toSystemDependentName((String)directory), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            renderer.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }

        @Override
        public String getTextPresentation() {
            return PathUtil.getFileName((String)this.myShelvedChange.getRequestName());
        }

        @Override
        protected boolean isFile() {
            return true;
        }

        @Override
        public int compareTo(@NotNull ShelvedChangeNode o) {
            if (o == null) {
                ShelvedChangeNode.$$$reportNull$$$0(3);
            }
            return ShelvedChangeNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }

        @Override
        @Nullable
        public Color getBackgroundColor(@NotNull Project project) {
            if (project == null) {
                ShelvedChangeNode.$$$reportNull$$$0(4);
            }
            return ShelvedChangeNode.getBackgroundColorFor(project, this.myFilePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedChangeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBackgroundColor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShelvedListNode
    extends ChangesBrowserNode<ShelvedChangeList> {
        @NotNull
        private final ShelvedChangeList myList;

        ShelvedListNode(@NotNull ShelvedChangeList list) {
            if (list == null) {
                ShelvedListNode.$$$reportNull$$$0(0);
            }
            super(list);
            this.myList = list;
        }

        @NotNull
        public ShelvedChangeList getList() {
            ShelvedChangeList shelvedChangeList = this.myList;
            if (shelvedChangeList == null) {
                ShelvedListNode.$$$reportNull$$$0(1);
            }
            return shelvedChangeList;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            String listName;
            if (renderer == null) {
                ShelvedListNode.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmptyOrSpaces((String)(listName = this.myList.getDescription()))) {
                listName = VcsBundle.message((String)"changes.nodetitle.empty.changelist.name", (Object[])new Object[0]);
            }
            if (this.myList.isRecycled() || this.myList.isDeleted()) {
                renderer.appendTextWithIssueLinks(listName, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            } else {
                renderer.appendTextWithIssueLinks(listName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.appendCount(renderer);
            String date = DateFormatUtil.formatPrettyDateTime((Date)this.myList.getDate());
            renderer.append(", " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            String loadingError = this.myList.getChangesLoadingError();
            if (loadingError != null) {
                renderer.append(FontUtil.spaceAndThinSpace() + loadingError, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        @Override
        @Nls
        public String getTextPresentation() {
            return ((ShelvedChangeList)this.getUserObject()).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyShelvedPreviewProcessor
    extends TreeHandlerDiffRequestProcessor
    implements DiffPreviewUpdateProcessor {
        private final boolean myIsInEditor;
        @NotNull
        private final DiffShelvedChangesActionProvider.PatchesPreloader myPreloader;

        MyShelvedPreviewProcessor(@NotNull Project project, @NotNull ShelfTree tree, boolean isInEditor) {
            if (project == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(1);
            }
            super("ShelveView", tree, ShelveTreeDiffPreviewHandler.INSTANCE);
            this.myIsInEditor = isInEditor;
            this.myPreloader = new DiffShelvedChangesActionProvider.PatchesPreloader(project);
            this.putContextUserData(DiffShelvedChangesActionProvider.PatchesPreloader.SHELF_PRELOADER, this.myPreloader);
            new TreeHandlerChangesTreeTracker(tree, (DiffEditorViewer)this, ShelveTreeDiffPreviewHandler.INSTANCE, !isInEditor).track();
        }

        @Override
        @RequiresEdt
        public void clear() {
            this.setCurrentChange(null);
            this.dropCaches();
        }

        protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
            if (toolbarComponents == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(2);
            }
            return !this.myIsInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
        }

        @Override
        @Nullable
        protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider) {
            ShelvedChange shelvedChange;
            if (provider == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(3);
            }
            if (provider instanceof ShelvedWrapperDiffRequestProducer && (shelvedChange = ((ShelvedWrapperDiffRequestProducer)provider).getWrapper().getShelvedChange()) != null && this.myPreloader.isPatchFileChanged(shelvedChange.getPatchPath())) {
                return null;
            }
            return super.loadRequestFast(provider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolbarComponents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldAddToolbarBottomBorder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadRequestFast";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class ShelveTreeDiffPreviewHandler
        extends ChangesTreeDiffPreviewHandler {
            public static final ShelveTreeDiffPreviewHandler INSTANCE = new ShelveTreeDiffPreviewHandler();

            private ShelveTreeDiffPreviewHandler() {
            }

            @Override
            @NotNull
            public Iterable<? extends ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges(@NotNull ChangesTree tree) {
                if (tree == null) {
                    ShelveTreeDiffPreviewHandler.$$$reportNull$$$0(0);
                }
                JBIterable<ShelvedWrapper> jBIterable = VcsTreeModelData.selected((JTree)((Object)tree)).iterateUserObjects(ShelvedWrapper.class);
                if (jBIterable == null) {
                    ShelveTreeDiffPreviewHandler.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }

            @Override
            @NotNull
            public Iterable<? extends ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges(@NotNull ChangesTree tree) {
                if (tree == null) {
                    ShelveTreeDiffPreviewHandler.$$$reportNull$$$0(2);
                }
                Set changeLists = VcsTreeModelData.selected((JTree)((Object)tree)).iterateUserObjects(ShelvedWrapper.class).map(wrapper2 -> wrapper2.getChangeList()).toSet();
                JBIterable jBIterable = VcsTreeModelData.all((JTree)((Object)tree)).iterateRawNodes().filter(node -> node instanceof ShelvedListNode && changeLists.contains(((ShelvedListNode)node).getList())).flatMap(node -> VcsTreeModelData.allUnder(node).iterateUserObjects(ShelvedWrapper.class));
                if (jBIterable == null) {
                    ShelveTreeDiffPreviewHandler.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }

            @Override
            public void selectChange(@NotNull ChangesTree tree, @NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
                if (tree == null) {
                    ShelveTreeDiffPreviewHandler.$$$reportNull$$$0(4);
                }
                if (change == null) {
                    ShelveTreeDiffPreviewHandler.$$$reportNull$$$0(5);
                }
                if (change instanceof ShelvedWrapper) {
                    ChangesBrowserNode<?> root = tree.getRoot();
                    DefaultMutableTreeNode changelistNode = TreeUtil.findNodeWithObject(root, (Object)((ShelvedWrapper)change).getChangeList());
                    if (changelistNode == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)changelistNode, (Object)change);
                    if (node == null) {
                        return;
                    }
                    TreeUtil.selectPath((JTree)((Object)tree), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node), (boolean)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor$ShelveTreeDiffPreviewHandler";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor$ShelveTreeDiffPreviewHandler";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "iterateSelectedChanges";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "iterateAllChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "iterateSelectedChanges";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "iterateAllChanges";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "selectChange";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static final class MyDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyDnDTarget(@NotNull Project project, @NotNull Content content) {
            if (project == null) {
                MyDnDTarget.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyDnDTarget.$$$reportNull$$$0(1);
            }
            super(project, content);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            ShelvedChangesViewManager.handleDropEvent(this.myProject, event);
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            if (event == null) {
                MyDnDTarget.$$$reportNull$$$0(2);
            }
            return ShelvedChangesViewManager.canHandleDropEvent(this.myProject, event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyShelveDeleteProvider
    implements DeleteProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelfTree myTree;

        private MyShelveDeleteProvider(@NotNull Project project, @NotNull ShelfTree tree) {
            if (project == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myTree = tree;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(3);
            }
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this.myTree), ShelvedChangeList.class);
            List<ShelvedChangeList> shelvedListsFromChanges = ShelvedChangesViewManager.getShelvedLists(dataContext);
            List<ShelvedChange> selectedChanges = ShelvedChangesViewManager.getShelveChanges(dataContext);
            List<ShelvedBinaryFile> selectedBinaryChanges = ShelvedChangesViewManager.getBinaryShelveChanges(dataContext);
            ShelvedChangesViewManager.deleteShelves(this.myProject, shelvedListsToDelete, shelvedListsFromChanges, selectedChanges, selectedBinaryChanges);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(4);
            }
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ShelfTreeAsyncModel
    extends TwoStepAsyncChangesTreeModel<List<ShelvedChangeList>> {
        private final Project myProject;

        private ShelfTreeAsyncModel(@NotNull Project project, @NotNull CoroutineScope scope) {
            if (project == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(1);
            }
            super(scope);
            this.myProject = project;
        }

        @Override
        public List<ShelvedChangeList> fetchData() {
            List<ShelvedChangeList> lists = ShelveChangesManager.getInstance(this.myProject).getAllLists();
            lists.forEach(l -> l.loadChangesIfNeeded(this.myProject));
            return ContainerUtil.sorted(lists, (Comparator)ChangelistComparator.getInstance());
        }

        @Override
        @NotNull
        public DefaultTreeModel buildTreeModelSync(@NotNull List<ShelvedChangeList> changeLists, @NotNull ChangesGroupingPolicyFactory grouping) {
            if (changeLists == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(2);
            }
            if (grouping == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(3);
            }
            boolean showRecycled = ShelveChangesManager.getInstance(this.myProject).isShowRecycled();
            MyShelvedTreeModelBuilder modelBuilder = new MyShelvedTreeModelBuilder(this.myProject, grouping);
            modelBuilder.setShelvedLists(ContainerUtil.filter(changeLists, l -> !l.isDeleted() && (showRecycled || !l.isRecycled())));
            modelBuilder.setDeletedShelvedLists(ContainerUtil.filter(changeLists, ShelvedChangeList::isDeleted));
            DefaultTreeModel defaultTreeModel = modelBuilder.build();
            if (defaultTreeModel == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(4);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTreeAsyncModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTreeAsyncModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModelSync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModelSync";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.getDate().compareTo(o1.getDate());
        }
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project) {
            if (project == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void initTabContent(@NotNull Content content) {
            if (content == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            if (!Registry.is((String)"vcs.shelves.rhizome.enabled")) {
                ShelfToolWindowPanel panel = ShelvedChangesViewManager.getInstance(this.myProject).initToolWindowPanel();
                content.setHelpId(ShelvedChangesViewManager.HELP_ID);
                content.setComponent((JComponent)((Object)panel));
                content.setDisposer((Disposable)panel);
                content.setPreferredFocusableComponent((JComponent)((Object)panel.myTree));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ContentPredicate
    implements Predicate<Project> {
        ContentPredicate() {
        }

        @Override
        public boolean test(Project project) {
            if (ShelvedChangesViewManager.hideDefaultShelfTab(project)) {
                return false;
            }
            ShelveChangesManager shelveManager = (ShelveChangesManager)project.getServiceIfCreated(ShelveChangesManager.class);
            return shelveManager != null && !shelveManager.getAllLists().isEmpty();
        }
    }

    public static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        public ContentPreloader(@NotNull Project project) {
            if (project == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void preloadTabContent(@NotNull Content content) {
            if (content == null) {
                ContentPreloader.$$$reportNull$$$0(1);
            }
            content.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyDnDTarget(this.myProject, content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ContentPreloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preloadTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyShelvedTreeModelBuilder
    extends TreeModelBuilder {
        private MyShelvedTreeModelBuilder(Project project, @NotNull ChangesGroupingPolicyFactory grouping) {
            if (grouping == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(0);
            }
            super(project, grouping);
        }

        public void setShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists2) {
            if (shelvedLists2 == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(1);
            }
            this.createShelvedListsWithChangesNode(shelvedLists2, this.myRoot);
        }

        public void setDeletedShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists2) {
            if (shelvedLists2 == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(2);
            }
            this.createShelvedListsWithChangesNode(shelvedLists2, this.createTagNode(VcsBundle.message((String)"shelve.recently.deleted.node", (Object[])new Object[0])));
        }

        private void createShelvedListsWithChangesNode(@NotNull List<ShelvedChangeList> shelvedLists2, @NotNull ChangesBrowserNode<?> parentNode) {
            if (shelvedLists2 == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(3);
            }
            if (parentNode == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(4);
            }
            for (ShelvedChangeList changeList : shelvedLists2) {
                ShelvedListNode shelvedListNode = new ShelvedListNode(changeList);
                this.insertSubtreeRoot(shelvedListNode, parentNode);
                List<ShelvedChange> changes = changeList.getChanges();
                if (changes == null) continue;
                ArrayList<ShelvedWrapper> shelvedChanges = new ArrayList<ShelvedWrapper>();
                changes.stream().map(change -> new ShelvedWrapper((ShelvedChange)change, changeList)).forEach(shelvedChanges::add);
                changeList.getBinaryFiles().stream().map(binaryChange -> new ShelvedWrapper((ShelvedBinaryFile)binaryChange, changeList)).forEach(shelvedChanges::add);
                shelvedChanges.sort(Comparator.comparing(s -> s.getChangeWithLocal(this.myProject), CHANGE_COMPARATOR));
                for (ShelvedWrapper shelved : shelvedChanges) {
                    Change change2 = shelved.getChangeWithLocal(this.myProject);
                    FilePath filePath = ChangesUtil.getFilePath((Change)change2);
                    this.insertChangeNode(change2, (ChangesBrowserNode<?>)shelvedListNode, (ChangesBrowserNode<?>)new ShelvedChangeNode(shelved, filePath, change2.getOriginText(this.myProject)));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedLists";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setShelvedLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDeletedShelvedLists";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createShelvedListsWithChangesNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        public String get() {
            return VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]);
        }
    }
}

