/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.compiler;

import com.intellij.uiDesigner.compiler.LayoutCodeGenerator;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.GeneratorAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class SimpleLayoutCodeGenerator
extends LayoutCodeGenerator {
    final Type myLayoutType;
    private static final Method ourConstructor = Method.getMethod((String)"void <init>(int,int)");

    SimpleLayoutCodeGenerator(Type layoutType) {
        this.myLayoutType = layoutType;
    }

    @Override
    public void generateContainerLayout(LwContainer lwContainer, GeneratorAdapter generator, int componentLocal) {
        generator.loadLocal(componentLocal);
        generator.newInstance(this.myLayoutType);
        generator.dup();
        generator.push(Utils.getHGap(lwContainer.getLayout()));
        generator.push(Utils.getVGap(lwContainer.getLayout()));
        generator.invokeConstructor(this.myLayoutType, ourConstructor);
        generator.invokeVirtual(ourContainerType, ourSetLayoutMethod);
    }

    @Override
    public void generateComponentLayout(LwComponent lwComponent, GeneratorAdapter generator, int componentLocal, int parentLocal, String formClassName) {
        generator.loadLocal(parentLocal);
        generator.loadLocal(componentLocal);
        generator.push((String)lwComponent.getCustomLayoutConstraints());
        generator.invokeVirtual(ourContainerType, ourAddMethod);
    }
}

