/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.recovery.ActionStatusService;
import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.List;
import javax.transaction.xa.Xid;

public class JTAActionStatusServiceXAResourceOrphanFilter
implements XAResourceOrphanFilter {
    private static final Uid LOCAL_UID = new Uid();

    @Override
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        if (xid.getFormatId() != 131077) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        XidImple theXid = new XidImple(xid);
        Uid u = theXid.getTransactionUid();
        List<String> xaRecoveryNodes = jtaPropertyManager.getJTAEnvironmentBean().getXaRecoveryNodes();
        String nodeName = XAUtils.getXANodeName(xid);
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("node name of " + String.valueOf(xid) + " is " + nodeName));
        }
        if (xaRecoveryNodes == null || xaRecoveryNodes.isEmpty() || !xaRecoveryNodes.contains(nodeName) && !xaRecoveryNodes.contains("*")) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        String process_id = u.getHexPid();
        if (process_id.equals(LOCAL_UID.getHexPid())) {
            ActionStatusService ass = new ActionStatusService();
            int transactionStatus = ass.getTransactionStatus("", u.stringForm());
            if (transactionStatus == 4) {
                return XAResourceOrphanFilter.Vote.ROLLBACK;
            }
            if (transactionStatus == 16) {
                return XAResourceOrphanFilter.Vote.ABSTAIN;
            }
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        return XAResourceOrphanFilter.Vote.ABSTAIN;
    }
}

