/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AnnotationCreator<A extends Annotation> {
    public static <A extends Annotation> Consumer<AnnotationCreator<A>> from(A annotation) {
        return ac -> {
            Method[] methods;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Method method : methods = annotationType.getDeclaredMethods()) {
                Object val;
                int mods = method.getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isAbstract(mods) || Modifier.isStatic(mods)) continue;
                try {
                    val = method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    try {
                        throw e.getCause();
                    }
                    catch (Error | RuntimeException e2) {
                        throw e2;
                    }
                    catch (Throwable e2) {
                        throw new UndeclaredThrowableException(e2);
                    }
                }
                if (val == null || Objects.equals(val, method.getDefaultValue())) continue;
                String name = method.getName();
                if (val instanceof Annotation) {
                    Annotation a = (Annotation)val;
                    ac.add(name, a.getClass().asSubclass(Annotation.class), AnnotationCreator.from(a));
                    continue;
                }
                if (val instanceof Boolean) {
                    Boolean b = (Boolean)val;
                    ac.add(name, (boolean)b);
                    continue;
                }
                if (val instanceof Byte) {
                    Byte b = (Byte)val;
                    ac.add(name, (byte)b);
                    continue;
                }
                if (val instanceof Class) {
                    Class z = (Class)val;
                    ac.add(name, (Enum)((Object)z));
                    continue;
                }
                if (val instanceof Character) {
                    Character c = (Character)val;
                    ac.add(name, c.charValue());
                    continue;
                }
                if (val instanceof Double) {
                    Double d = (Double)val;
                    ac.add(name, (double)d);
                    continue;
                }
                if (val instanceof Float) {
                    Float f = (Float)val;
                    ac.add(name, f.floatValue());
                    continue;
                }
                if (val instanceof Integer) {
                    Integer i = (Integer)val;
                    ac.add(name, (int)i);
                    continue;
                }
                if (val instanceof Long) {
                    Long l = (Long)val;
                    ac.add(name, (long)l);
                    continue;
                }
                if (val instanceof Short) {
                    Short s = (Short)val;
                    ac.add(name, (short)s);
                    continue;
                }
                if (val instanceof String) {
                    String s = (String)val;
                    ac.add(name, s);
                    continue;
                }
                if (val instanceof Enum) {
                    Enum e = (Enum)val;
                    ac.add(name, e);
                    continue;
                }
                if (val instanceof Annotation[]) {
                    Annotation[] array = (Annotation[])val;
                    ac.doWithArray(name, method.getReturnType().asSubclass(Annotation.class), array);
                    continue;
                }
                if (val instanceof boolean[]) {
                    boolean[] array = (boolean[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof byte[]) {
                    byte[] array = (byte[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof Class[]) {
                    Class[] array = (Class[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof char[]) {
                    char[] array = (char[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof double[]) {
                    double[] array = (double[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof float[]) {
                    float[] array = (float[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof int[]) {
                    int[] array = (int[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof long[]) {
                    long[] array = (long[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof short[]) {
                    short[] array = (short[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof String[]) {
                    String[] array = (String[])val;
                    ac.addArray(name, array);
                    continue;
                }
                if (val instanceof Enum[]) {
                    Enum[] array = (Enum[])val;
                    ac.addArray(name, Util.classDesc(method.getReturnType().asSubclass(Enum.class)), (String[])Stream.of(array).map(Enum::name).toArray(String[]::new));
                    continue;
                }
                throw Assert.unreachableCode();
            }
        };
    }

    private <AA extends Annotation> void doWithArray(String name, Class<AA> type, Annotation[] values) {
        this.addArray(name, type, Stream.of(values).map(type::cast).map(AnnotationCreator::from).toList());
    }

    public void add(String var1, boolean var2);

    public void add(BooleanProperty<A> var1, boolean var2);

    public void add(String var1, byte var2);

    public void add(ByteProperty<A> var1, byte var2);

    public void add(String var1, short var2);

    public void add(ShortProperty<A> var1, short var2);

    public void add(String var1, int var2);

    public void add(IntProperty<A> var1, int var2);

    public void add(String var1, long var2);

    public void add(LongProperty<A> var1, long var2);

    public void add(String var1, float var2);

    public void add(FloatProperty<A> var1, float var2);

    public void add(String var1, double var2);

    public void add(DoubleProperty<A> var1, double var2);

    public void add(String var1, char var2);

    public void add(CharProperty<A> var1, char var2);

    public void add(String var1, String var2);

    public void add(StringProperty<A> var1, String var2);

    public void add(String var1, Class<?> var2);

    public void add(ClassProperty<A> var1, Class<?> var2);

    public void add(String var1, ClassDesc var2);

    public void add(ClassProperty<A> var1, ClassDesc var2);

    public <E extends Enum<E>> void add(String var1, E var2);

    public <E extends Enum<E>> void add(EnumProperty<A, E> var1, E var2);

    public void add(String var1, ClassDesc var2, String var3);

    public <S extends Annotation> void add(String var1, Class<S> var2, Consumer<AnnotationCreator<S>> var3);

    public <S extends Annotation> void add(AnnotationProperty<A, S> var1, Consumer<AnnotationCreator<S>> var2);

    public void add(String var1, ClassDesc var2, Consumer<AnnotationCreator<Annotation>> var3);

    public void addArray(String var1, boolean ... var2);

    public void addArray(BooleanArrayProperty<A> var1, boolean ... var2);

    public void addArray(String var1, byte ... var2);

    public void addArray(ByteArrayProperty<A> var1, byte ... var2);

    public void addArray(String var1, short ... var2);

    public void addArray(ShortArrayProperty<A> var1, short ... var2);

    public void addArray(String var1, int ... var2);

    public void addArray(IntArrayProperty<A> var1, int ... var2);

    public void addArray(String var1, long ... var2);

    public void addArray(LongArrayProperty<A> var1, long ... var2);

    public void addArray(String var1, float ... var2);

    public void addArray(FloatArrayProperty<A> var1, float ... var2);

    public void addArray(String var1, double ... var2);

    public void addArray(DoubleArrayProperty<A> var1, double ... var2);

    public void addArray(String var1, char ... var2);

    public void addArray(CharArrayProperty<A> var1, char ... var2);

    public void addArray(String var1, String ... var2);

    public void addArray(StringArrayProperty<A> var1, String ... var2);

    public void addArray(String var1, Class<?> ... var2);

    public void addArray(ClassArrayProperty<A> var1, Class<?> ... var2);

    public void addArray(String var1, ClassDesc ... var2);

    public void addArray(ClassArrayProperty<A> var1, ClassDesc ... var2);

    public <E extends Enum<E>> void addArray(String var1, List<E> var2);

    public <E extends Enum<E>> void addArray(EnumArrayProperty<A, E> var1, List<E> var2);

    public void addArray(String var1, ClassDesc var2, String ... var3);

    public <E extends Enum<E>> void addArray(EnumArrayProperty<A, E> var1, ClassDesc var2, String ... var3);

    public <S extends Annotation> void addArray(String var1, Class<S> var2, List<Consumer<AnnotationCreator<S>>> var3);

    public <S extends Annotation> void addArray(AnnotationArrayProperty<A, S> var1, List<Consumer<AnnotationCreator<S>>> var2);

    public void addArray(String var1, ClassDesc var2, List<Consumer<AnnotationCreator<Annotation>>> var3);

    @FunctionalInterface
    public static interface AnnotationArrayProperty<A extends Annotation, S extends Annotation>
    extends Serializable {
        public S[] get(A var1);
    }

    @FunctionalInterface
    public static interface EnumArrayProperty<A extends Annotation, E extends Enum<E>>
    extends Serializable {
        public E[] get(A var1);
    }

    @FunctionalInterface
    public static interface ClassArrayProperty<A extends Annotation>
    extends Serializable {
        public Class<?>[] get(A var1);
    }

    @FunctionalInterface
    public static interface StringArrayProperty<A extends Annotation>
    extends Serializable {
        public String[] get(A var1);
    }

    @FunctionalInterface
    public static interface CharArrayProperty<A extends Annotation>
    extends Serializable {
        public char[] get(A var1);
    }

    @FunctionalInterface
    public static interface DoubleArrayProperty<A extends Annotation>
    extends Serializable {
        public double[] get(A var1);
    }

    @FunctionalInterface
    public static interface FloatArrayProperty<A extends Annotation>
    extends Serializable {
        public float[] get(A var1);
    }

    @FunctionalInterface
    public static interface LongArrayProperty<A extends Annotation>
    extends Serializable {
        public long[] get(A var1);
    }

    @FunctionalInterface
    public static interface IntArrayProperty<A extends Annotation>
    extends Serializable {
        public int[] get(A var1);
    }

    @FunctionalInterface
    public static interface ShortArrayProperty<A extends Annotation>
    extends Serializable {
        public short[] get(A var1);
    }

    @FunctionalInterface
    public static interface ByteArrayProperty<A extends Annotation>
    extends Serializable {
        public byte[] get(A var1);
    }

    @FunctionalInterface
    public static interface BooleanArrayProperty<A extends Annotation>
    extends Serializable {
        public boolean[] get(A var1);
    }

    @FunctionalInterface
    public static interface AnnotationProperty<A extends Annotation, S extends Annotation>
    extends Serializable {
        public S get(A var1);
    }

    @FunctionalInterface
    public static interface EnumProperty<A extends Annotation, E extends Enum<E>>
    extends Serializable {
        public E get(A var1);
    }

    @FunctionalInterface
    public static interface ClassProperty<A extends Annotation>
    extends Serializable {
        public Class<?> get(A var1);
    }

    @FunctionalInterface
    public static interface StringProperty<A extends Annotation>
    extends Serializable {
        public String get(A var1);
    }

    @FunctionalInterface
    public static interface CharProperty<A extends Annotation>
    extends Serializable {
        public char get(A var1);
    }

    @FunctionalInterface
    public static interface DoubleProperty<A extends Annotation>
    extends Serializable {
        public double get(A var1);
    }

    @FunctionalInterface
    public static interface FloatProperty<A extends Annotation>
    extends Serializable {
        public float get(A var1);
    }

    @FunctionalInterface
    public static interface LongProperty<A extends Annotation>
    extends Serializable {
        public long get(A var1);
    }

    @FunctionalInterface
    public static interface IntProperty<A extends Annotation>
    extends Serializable {
        public int get(A var1);
    }

    @FunctionalInterface
    public static interface ShortProperty<A extends Annotation>
    extends Serializable {
        public short get(A var1);
    }

    @FunctionalInterface
    public static interface ByteProperty<A extends Annotation>
    extends Serializable {
        public byte get(A var1);
    }

    @FunctionalInterface
    public static interface BooleanProperty<A extends Annotation>
    extends Serializable {
        public boolean get(A var1);
    }
}

