/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.session.JpaSessionUtil;
import org.keycloak.models.jpa.session.UserSessionAndUser;
import org.keycloak.models.jpa.session.UserSessionIdAndRememberMe;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmExpiration;

final class UserSessionExpirationLogic {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final Consumer<TypedQuery<Object[]>> NO_PARAMETERS = typedQuery -> {};

    private UserSessionExpirationLogic() {
    }

    public static void expireOfflineSessions(KeycloakSessionFactory sessionFactory, RealmModel realm, int currentTime, RealmExpiration expiration, int batchSize) {
        long start = System.nanoTime();
        logger.tracef("Removing expired offline user sessions for realm '%s'", (Object)realm.getName());
        int oldestCreatedOn = realm.isOfflineSessionMaxLifespanEnabled() ? currentTime - expiration.offlineLifespan() - 180 : 0;
        Consumer setCreatedOn = UserSessionExpirationLogic.setCreatedOn(oldestCreatedOn);
        int oldestLastSessionRefresh = currentTime - expiration.offlineMaxIdle() - 180;
        Consumer setLastSessionRefresh = UserSessionExpirationLogic.setLastSessionRefresh(oldestLastSessionRefresh);
        String realmId = realm.getId();
        ArrayList expiredSessions = new ArrayList(batchSize);
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.findAndRemoveSessions(s, realmId, batchSize, true, "user_session_expired", "findExpiredOfflineUserSessionsLastRefresh", setLastSessionRefresh, expiredSessions)), expiredSessions::clear);
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.findAndRemoveSessions(s, realmId, batchSize, true, "user_session_expired", "findExpiredOfflineUserSessionsCreatedOn", setCreatedOn, expiredSessions)), expiredSessions::clear);
        long duration = System.nanoTime() - start;
        logger.debugf("Offline user session expiration task completed for realm '%s'. Took %dms", (Object)realm.getName(), (Object)TimeUnit.NANOSECONDS.toMillis(duration));
    }

    public static void expireRegularSessions(KeycloakSessionFactory sessionFactory, RealmModel realm, int currentTime, RealmExpiration expiration, boolean rememberMe, int batchSize) {
        long start = System.nanoTime();
        logger.tracef("Removing expired regular user sessions for realm '%s'", (Object)realm.getName());
        int oldestCreatedOn = currentTime - expiration.getLifespan(rememberMe) - 180;
        Consumer setRememberMe = UserSessionExpirationLogic.setRememberMe(rememberMe);
        Consumer setCreatedOn = UserSessionExpirationLogic.setCreatedOn(oldestCreatedOn).andThen(setRememberMe);
        int oldestLastSessionRefresh = currentTime - expiration.getMaxIdle(rememberMe) - 180;
        Consumer setLastSessionRefresh = UserSessionExpirationLogic.setLastSessionRefresh(oldestLastSessionRefresh).andThen(setRememberMe);
        String realmId = realm.getId();
        ArrayList expiredSessions = new ArrayList(batchSize);
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.findAndRemoveSessions(s, realmId, batchSize, false, "user_session_expired", "findExpiredRegularUserSessionsLastRefresh", setLastSessionRefresh, expiredSessions)), expiredSessions::clear);
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.findAndRemoveSessions(s, realmId, batchSize, false, "user_session_expired", "findExpiredRegularUserSessionsCreatedOn", setCreatedOn, expiredSessions)), expiredSessions::clear);
        long duration = System.nanoTime() - start;
        logger.debugf("Regular user session expiration task completed for realm '%s'. Took %dms", (Object)realm.getName(), (Object)TimeUnit.NANOSECONDS.toMillis(duration));
    }

    public static void migrateRememberMe(KeycloakSessionFactory sessionFactory, RealmModel realm, RealmExpiration expiration, int currentTime, int batchSize) {
        long start = System.nanoTime();
        boolean rememberMeEnabledInRealm = realm.isRememberMe();
        String realmId = realm.getId();
        String realmName = realm.getName();
        logger.tracef("Migrating remember me value for regular user sessions, for realm '%s'", (Object)realmName);
        int expireMaxIdle = currentTime - Math.min(expiration.maxIdle(), expiration.rememberMeMaxIdle());
        Consumer setLastSessionRefresh = UserSessionExpirationLogic.setLastSessionRefresh(expireMaxIdle);
        int expireLifespan = currentTime - Math.min(expiration.lifespan(), expiration.rememberMeLifespan());
        Consumer setCreatedOn = UserSessionExpirationLogic.setCreatedOn(expireLifespan);
        ArrayList sessionsWithRememberMe = new ArrayList(batchSize);
        ArrayList sessionsWithoutRememberMe = new ArrayList(batchSize);
        Runnable cleanup = () -> {
            sessionsWithRememberMe.clear();
            sessionsWithoutRememberMe.clear();
        };
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.handleRememberMeColumnValue(s, realmId, realmName, batchSize, rememberMeEnabledInRealm, "findUserSessionAndDataWithNullRememberMeLastRefresh", setLastSessionRefresh, sessionsWithRememberMe, sessionsWithoutRememberMe)), cleanup);
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.handleRememberMeColumnValue(s, realmId, realmName, batchSize, rememberMeEnabledInRealm, "findUserSessionAndDataWithNullRememberMeCreatedOn", setCreatedOn, sessionsWithRememberMe, sessionsWithoutRememberMe)), cleanup);
        long duration = System.nanoTime() - start;
        logger.debugf("Migration task completed for realm '%s'. Took %dms", (Object)realmName, (Object)TimeUnit.NANOSECONDS.toMillis(duration));
    }

    public static void deleteInvalidSessions(KeycloakSessionFactory sessionFactory, RealmModel realm, int batchSize) {
        long start = System.nanoTime();
        String realmId = realm.getId();
        String realmName = realm.getName();
        logger.tracef("Removing invalid user sessions for realm '%s'", (Object)realmName);
        ArrayList invalidSession = new ArrayList();
        UserSessionExpirationLogic.runInBatches(sessionFactory, (KeycloakSessionTaskWithResult<Boolean>)((KeycloakSessionTaskWithResult)s -> UserSessionExpirationLogic.findAndRemoveSessions(s, realmId, batchSize, false, "invalid_user_session_remember_me", "findInvalidRegularUserSessions", NO_PARAMETERS, invalidSession)), invalidSession::clear);
        long duration = System.nanoTime() - start;
        logger.debugf("Invalid session removed for realm '%s'. Took %dms", (Object)realmName, (Object)TimeUnit.NANOSECONDS.toMillis(duration));
    }

    private static boolean handleRememberMeColumnValue(KeycloakSession session, String realmId, String realmName, int batchSize, boolean rememberMeEnabled, String queryName, Consumer<TypedQuery<Object[]>> setParameters, List<UserSessionAndUser> sessionsWithRememberMeCollector, List<String> sessionsWithoutRememberMeCollector) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        TypedQuery query = em.createNamedQuery(queryName, Object[].class);
        setParameters.accept((TypedQuery<Object[]>)query);
        query.setParameter("realmId", (Object)realmId).setHint("org.hibernate.readOnly", (Object)true).setMaxResults(batchSize).getResultStream().map(UserSessionIdAndRememberMe::fromQueryProjection).forEach(userSession -> {
            if (userSession.rememberMe()) {
                sessionsWithRememberMeCollector.add(userSession.sessionAndUser());
            } else {
                sessionsWithoutRememberMeCollector.add(userSession.sessionAndUser().userSessionId());
            }
        });
        int updateCount = UserSessionExpirationLogic.updateRememberMeColumn(em, false, sessionsWithoutRememberMeCollector);
        if (rememberMeEnabled) {
            int rememberMeUpdateCount = UserSessionExpirationLogic.updateRememberMeColumn(em, true, sessionsWithRememberMeCollector.stream().map(UserSessionAndUser::userSessionId).toList());
            logger.debugf("%d sessions with remember me, and %d sessions without remember updated, for realm '%s'", rememberMeUpdateCount, updateCount, (Object)realmName);
        } else {
            int deletedCount = UserSessionExpirationLogic.handleResultsToRemove(session, em, realmId, false, "invalid_user_session_remember_me", sessionsWithRememberMeCollector);
            logger.debugf("%d sessions without remember me updated, and %d invalid sessions deleted, for realm '%s'", updateCount, deletedCount, (Object)realmName);
        }
        return sessionsWithRememberMeCollector.size() + sessionsWithoutRememberMeCollector.size() >= batchSize;
    }

    private static void createUserSessionDeletedEvent(KeycloakSession session, RealmModel realm, UserSessionAndUser data, String reason) {
        new EventBuilder(realm, session).user(data.userId()).session(data.userSessionId()).event(EventType.USER_SESSION_DELETED).detail("reason", reason).success();
    }

    private static boolean findAndRemoveSessions(KeycloakSession session, String realmId, int batchSize, boolean offline, String eventReason, String queryName, Consumer<TypedQuery<Object[]>> queryParameters, List<UserSessionAndUser> expiredSessions) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        TypedQuery query = em.createNamedQuery(queryName, Object[].class);
        queryParameters.accept((TypedQuery<Object[]>)query);
        query.setParameter("realmId", (Object)realmId).setHint("org.hibernate.readOnly", (Object)true).setMaxResults(batchSize).getResultStream().map(UserSessionAndUser::fromQueryProjection).forEach(expiredSessions::add);
        UserSessionExpirationLogic.handleResultsToRemove(session, em, realmId, offline, eventReason, expiredSessions);
        return expiredSessions.size() >= batchSize;
    }

    private static int handleResultsToRemove(KeycloakSession session, EntityManager em, String realmId, boolean offline, String eventReason, Collection<UserSessionAndUser> expiredSessions) {
        if (expiredSessions.isEmpty()) {
            return 0;
        }
        RealmModel realm = session.realms().getRealm(realmId);
        session.getContext().setRealm(realm);
        List<String> sessionIds = expiredSessions.stream().peek(sessionAndUser -> UserSessionExpirationLogic.createUserSessionDeletedEvent(session, realm, sessionAndUser, eventReason)).map(UserSessionAndUser::userSessionId).toList();
        String offlineStr = JpaSessionUtil.offlineToString(offline);
        int cs = em.createNamedQuery("deleteClientSessionsByUserSessions").setParameter("userSessionId", sessionIds).setParameter("offline", (Object)offlineStr).executeUpdate();
        int us = em.createNamedQuery("deleteUserSessions").setParameter("offline", (Object)offlineStr).setParameter("userSessionIds", sessionIds).executeUpdate();
        logger.debugf("Removed %d user sessions and %d client sessions in realm '%s'", us, cs, (Object)realm.getName());
        return us;
    }

    private static int updateRememberMeColumn(EntityManager em, boolean rememberMe, Collection<String> sessionIds) {
        if (sessionIds.isEmpty()) {
            return 0;
        }
        return em.createNamedQuery("updateUserSessionRememberMeColumn").setParameter("rememberMe", (Object)rememberMe).setParameter("userSessionIds", sessionIds).executeUpdate();
    }

    private static void runInBatches(KeycloakSessionFactory sessionFactory, KeycloakSessionTaskWithResult<Boolean> task, Runnable afterBatchAction) {
        boolean hasMore;
        do {
            hasMore = (Boolean)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)sessionFactory, null, task, (String)"session-expiration-task");
            afterBatchAction.run();
        } while (hasMore);
    }

    private static <T> Consumer<TypedQuery<T>> setLastSessionRefresh(int value) {
        return query -> query.setParameter("lastSessionRefresh", (Object)value);
    }

    private static <T> Consumer<TypedQuery<T>> setCreatedOn(int value) {
        return query -> query.setParameter("createdOn", (Object)value);
    }

    private static <T> Consumer<TypedQuery<T>> setRememberMe(boolean value) {
        return query -> query.setParameter("rememberMe", (Object)value);
    }
}

