/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.crossclassloader.runtime;

import io.quarkus.devservices.crossclassloader.runtime.DevServiceOwner;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.ConfigMapping;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public record ComparableDevServicesConfig(UUID applicationInstanceId, DevServiceOwner owner, Object globalConfig, Object identifyingConfig) {
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ComparableDevServicesConfig)) {
            return false;
        }
        ComparableDevServicesConfig that = (ComparableDevServicesConfig)o;
        return Objects.equals(this.owner, that.owner) && ComparableDevServicesConfig.reflectiveEquals(this.globalConfig, that.globalConfig) && ComparableDevServicesConfig.reflectiveEquals(this.identifyingConfig, that.identifyingConfig) && Objects.equals(this.applicationInstanceId, that.applicationInstanceId);
    }

    private static boolean reflectiveEquals(Object config, Object otherConfig) {
        if (config == null || otherConfig == null) {
            return config == otherConfig;
        }
        Class<?> clazz = config.getClass();
        Class<?> otherClazz = otherConfig.getClass();
        if (!clazz.getName().equals(otherClazz.getName())) {
            return false;
        }
        try {
            while (clazz != null) {
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (!ComparableDevServicesConfig.isConfigInterface(iface)) continue;
                    for (Method method : iface.getMethods()) {
                        int modifiers = method.getModifiers();
                        if (!ComparableDevServicesConfig.isInvokableMethod(method, modifiers)) continue;
                        Method otherMethod = clazz == otherClazz ? method : otherClazz.getMethod(method.getName(), new Class[0]);
                        otherMethod.setAccessible(true);
                        Object thisValue = method.invoke(config, new Object[0]);
                        Object otherValue = otherMethod.invoke(otherConfig, new Object[0]);
                        if (Objects.deepEquals(thisValue, otherValue)) continue;
                        return false;
                    }
                }
                clazz = clazz.getSuperclass();
                otherClazz = otherClazz.getSuperclass();
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean containsAnnotation(Class<?> iface, Class<? extends Annotation> configAnnotation) {
        return Arrays.stream(iface.getAnnotations()).anyMatch(a -> a.annotationType().getName().equals(configAnnotation.getName()));
    }

    private static boolean isInvokableMethod(Method method, int modifiers) {
        if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
            return false;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (method.getParameterCount() > 0) {
            return false;
        }
        method.setAccessible(true);
        return true;
    }

    private static boolean isConfigInterface(Class<?> iface) {
        return ComparableDevServicesConfig.containsAnnotation(iface, ConfigMapping.class) || ComparableDevServicesConfig.containsAnnotation(iface, ConfigGroup.class);
    }
}

