/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.context.Flag;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class KeyStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<K, Stream<K>> {
    private static final Log log = LogFactory.getLog(KeyStreamSupplier.class);
    private final Cache<K, V> cache;
    private final ToIntFunction<Object> segmentFunction;
    private final Supplier<Stream<K>> supplier;

    public KeyStreamSupplier(Cache<K, V> cache, ToIntFunction<Object> segmentFunction, Supplier<Stream<K>> supplier) {
        this.cache = cache;
        this.segmentFunction = segmentFunction;
        this.supplier = supplier;
    }

    @Override
    public Stream<K> buildStream(IntSet segmentsToFilter, Set<?> keysToFilter, boolean parallel) {
        Stream<Object> stream;
        AdvancedCache advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
        if (keysToFilter != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Applying key filtering %s", keysToFilter);
            }
            stream = (parallel ? keysToFilter.parallelStream() : keysToFilter.stream()).filter(k -> advancedCache.get(k) != null);
        } else {
            stream = this.supplier.get();
            if (parallel) {
                stream = (Stream<Object>)stream.parallel();
            }
        }
        if (segmentsToFilter != null && this.segmentFunction != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Applying segment filter %s", segmentsToFilter);
            }
            stream = stream.filter(k -> segmentsToFilter.contains(this.segmentFunction.applyAsInt(k)));
        }
        return stream;
    }
}

