/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;

public class RingClipper {
    private static final int BOX_LEFT = 3;
    private static final int BOX_TOP = 2;
    private static final int BOX_RIGHT = 1;
    private static final int BOX_BOTTOM = 0;
    private Envelope clipEnv;
    private double clipEnvMinY;
    private double clipEnvMaxY;
    private double clipEnvMinX;
    private double clipEnvMaxX;

    public RingClipper(Envelope clipEnv) {
        this.clipEnv = clipEnv;
        this.clipEnvMinY = clipEnv.getMinY();
        this.clipEnvMaxY = clipEnv.getMaxY();
        this.clipEnvMinX = clipEnv.getMinX();
        this.clipEnvMaxX = clipEnv.getMaxX();
    }

    public Coordinate[] clip(Coordinate[] pts) {
        for (int edgeIndex = 0; edgeIndex < 4; ++edgeIndex) {
            boolean closeRing = edgeIndex == 3;
            if ((pts = this.clipToBoxEdge(pts, edgeIndex, closeRing)).length != 0) continue;
            return pts;
        }
        return pts;
    }

    private Coordinate[] clipToBoxEdge(Coordinate[] pts, int edgeIndex, boolean closeRing) {
        Coordinate start;
        CoordinateList ptsClip = new CoordinateList();
        Coordinate p0 = pts[pts.length - 1];
        for (int i = 0; i < pts.length; ++i) {
            Coordinate intPt;
            Coordinate p1 = pts[i];
            if (this.isInsideEdge(p1, edgeIndex)) {
                if (!this.isInsideEdge(p0, edgeIndex)) {
                    intPt = this.intersection(p0, p1, edgeIndex);
                    ptsClip.add(intPt, false);
                }
                ptsClip.add(p1.copy(), false);
            } else if (this.isInsideEdge(p0, edgeIndex)) {
                intPt = this.intersection(p0, p1, edgeIndex);
                ptsClip.add(intPt, false);
            }
            p0 = p1;
        }
        if (closeRing && ptsClip.size() > 0 && !(start = (Coordinate)ptsClip.get(0)).equals2D((Coordinate)ptsClip.get(ptsClip.size() - 1))) {
            ptsClip.add(start.copy());
        }
        return ptsClip.toCoordinateArray();
    }

    private Coordinate intersection(Coordinate a, Coordinate b, int edgeIndex) {
        Coordinate intPt;
        switch (edgeIndex) {
            case 0: {
                intPt = new Coordinate(this.intersectionLineY(a, b, this.clipEnvMinY), this.clipEnvMinY);
                break;
            }
            case 1: {
                intPt = new Coordinate(this.clipEnvMaxX, this.intersectionLineX(a, b, this.clipEnvMaxX));
                break;
            }
            case 2: {
                intPt = new Coordinate(this.intersectionLineY(a, b, this.clipEnvMaxY), this.clipEnvMaxY);
                break;
            }
            default: {
                intPt = new Coordinate(this.clipEnvMinX, this.intersectionLineX(a, b, this.clipEnvMinX));
            }
        }
        return intPt;
    }

    private double intersectionLineY(Coordinate a, Coordinate b, double y) {
        double m = (b.x - a.x) / (b.y - a.y);
        double intercept = (y - a.y) * m;
        return a.x + intercept;
    }

    private double intersectionLineX(Coordinate a, Coordinate b, double x) {
        double m = (b.y - a.y) / (b.x - a.x);
        double intercept = (x - a.x) * m;
        return a.y + intercept;
    }

    private boolean isInsideEdge(Coordinate p, int edgeIndex) {
        boolean isInside = false;
        switch (edgeIndex) {
            case 0: {
                isInside = p.y > this.clipEnvMinY;
                break;
            }
            case 1: {
                isInside = p.x < this.clipEnvMaxX;
                break;
            }
            case 2: {
                isInside = p.y < this.clipEnvMaxY;
                break;
            }
            default: {
                isInside = p.x > this.clipEnvMinX;
            }
        }
        return isInside;
    }
}

