/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.server.ServerProperty;
import java.util.Base64;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.credential.CredentialInput;

public class WebAuthnCredentialModelInput
implements CredentialInput {
    private AttestedCredentialData attestedCredentialData;
    private AttestationStatement attestationStatement;
    private KeycloakWebAuthnAuthenticationParameters authenticationParameters;
    private AuthenticationRequest authenticationRequest;
    private long count;
    private String credentialDBId;
    private final String credentialType;
    private String attestationStatementFormat;
    private Set<AuthenticatorTransport> transports;

    public WebAuthnCredentialModelInput(String credentialType) {
        this.credentialType = credentialType;
    }

    public String getCredentialId() {
        return this.credentialDBId;
    }

    public String getChallengeResponse() {
        throw new UnsupportedOperationException("WebAuthn credential doesn't support getChallengeResponse");
    }

    public String getType() {
        return this.credentialType;
    }

    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public long getCount() {
        return this.count;
    }

    public KeycloakWebAuthnAuthenticationParameters getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public void setAuthenticationParameters(KeycloakWebAuthnAuthenticationParameters authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
    }

    public AuthenticationRequest getAuthenticationRequest() {
        return this.authenticationRequest;
    }

    public void setAuthenticationRequest(AuthenticationRequest authenticationRequest) {
        this.authenticationRequest = authenticationRequest;
    }

    public void setAttestedCredentialData(AttestedCredentialData attestedCredentialData) {
        this.attestedCredentialData = attestedCredentialData;
    }

    public void setAttestationStatement(AttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getCredentialDBId() {
        return this.credentialDBId;
    }

    public void setCredentialDBId(String credentialDBId) {
        this.credentialDBId = credentialDBId;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getAttestationStatementFormat() {
        return this.attestationStatementFormat;
    }

    public void setAttestationStatementFormat(String attestationStatementFormat) {
        this.attestationStatementFormat = attestationStatementFormat;
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports != null ? this.transports : Collections.emptySet();
    }

    public void setTransports(Set<AuthenticatorTransport> transports) {
        this.transports = transports;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Credential Type = " + this.credentialType + ",");
        if (this.credentialDBId != null) {
            sb.append("Credential DB Id = ").append(this.credentialDBId).append(",");
        }
        if (this.attestationStatement != null) {
            sb.append("Attestation Statement Format = ").append(this.attestationStatement.getFormat()).append(",");
        } else if (this.attestationStatementFormat != null) {
            sb.append("Attestation Statement Format = ").append(this.attestationStatementFormat).append(",");
        }
        if (this.attestedCredentialData != null) {
            sb.append("AAGUID = ").append(this.attestedCredentialData.getAaguid().toString()).append(",");
            sb.append("CREDENTIAL_ID = ").append(Base64.getEncoder().encodeToString(this.attestedCredentialData.getCredentialId())).append(",");
            COSEKey credPubKey = this.attestedCredentialData.getCOSEKey();
            byte[] keyId = credPubKey.getKeyId();
            if (keyId != null) {
                sb.append("CREDENTIAL_PUBLIC_KEY.key_id = ").append(Base64.getEncoder().encodeToString(keyId)).append(",");
            }
            sb.append("CREDENTIAL_PUBLIC_KEY.algorithm = ").append(String.valueOf(credPubKey.getAlgorithm().getValue())).append(",");
            sb.append("CREDENTIAL_PUBLIC_KEY.key_type = ").append(credPubKey.getKeyType().name()).append(",");
        }
        if (this.authenticationRequest != null) {
            sb.append("Credential Id = ").append(Base64.getEncoder().encodeToString(this.authenticationRequest.getCredentialId())).append(",");
        }
        if (CollectionUtil.isNotEmpty(this.getTransports())) {
            String transportsString = this.getTransports().stream().map(AuthenticatorTransport::getValue).collect(Collectors.joining(","));
            sb.append("Transports = [").append(transportsString).append("],");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }

    public static class KeycloakWebAuthnAuthenticationParameters {
        private final ServerProperty serverProperty;
        private final boolean userVerificationRequired;

        public KeycloakWebAuthnAuthenticationParameters(ServerProperty serverProperty, boolean userVerificationRequired) {
            this.serverProperty = serverProperty;
            this.userVerificationRequired = userVerificationRequired;
        }

        public ServerProperty getServerProperty() {
            return this.serverProperty;
        }

        public boolean isUserVerificationRequired() {
            return this.userVerificationRequired;
        }
    }
}

