/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.stream.Stream;
import org.keycloak.forms.login.freemarker.model.AbstractUserProfileBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;

public class EmailBean
extends AbstractUserProfileBean {
    private final UserModel user;

    public EmailBean(UserModel user, MultivaluedMap<String, String> formData, KeycloakSession session) {
        super(formData);
        this.user = user;
        this.init(session, false);
    }

    public String getValue() {
        return this.formData != null ? (String)this.formData.getFirst((Object)"email") : this.user.getEmail();
    }

    @Override
    protected UserProfile createUserProfile(UserProfileProvider provider) {
        return provider.create(UserProfileContext.UPDATE_EMAIL, this.user);
    }

    @Override
    protected Stream<String> getAttributeDefaultValues(String name) {
        return this.user.getAttributeStream(name);
    }

    @Override
    public String getContext() {
        return UserProfileContext.UPDATE_PROFILE.name();
    }
}

