/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterDocIdSetIterator;
import org.apache.lucene.util.Bits;

public final class FacetUtils {
    private FacetUtils() {
    }

    public static DocIdSetIterator liveDocsDISI(final DocIdSetIterator it, final Bits liveDocs) {
        return new FilterDocIdSetIterator(it){

            private int doNext(int doc) throws IOException {
                assert (doc == it.docID());
                while (doc != Integer.MAX_VALUE && !liveDocs.get(doc)) {
                    doc = it.nextDoc();
                }
                return doc;
            }

            public int nextDoc() throws IOException {
                return this.doNext(it.nextDoc());
            }

            public int advance(int target) throws IOException {
                return this.doNext(it.advance(target));
            }
        };
    }
}

