/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.Arrays;

public class BCPGOutputStream
extends OutputStream
implements PacketTags,
CompressionAlgorithmTags {
    OutputStream out;
    private boolean useOldFormat;
    private byte[] partialBuffer;
    private int partialBufferLength;
    private int partialPower;
    private int partialOffset;
    private static final int BUF_SIZE_POWER = 16;

    public static BCPGOutputStream wrap(OutputStream outputStream) {
        if (outputStream instanceof BCPGOutputStream) {
            return (BCPGOutputStream)outputStream;
        }
        return new BCPGOutputStream(outputStream);
    }

    public BCPGOutputStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public BCPGOutputStream(OutputStream outputStream, boolean bl) {
        this.out = outputStream;
        this.useOldFormat = !bl;
    }

    public BCPGOutputStream(OutputStream outputStream, int n) throws IOException {
        this.out = outputStream;
        this.writeHeader(n, true, true, 0L);
    }

    public BCPGOutputStream(OutputStream outputStream, int n, long l, boolean bl) throws IOException {
        this.out = outputStream;
        if (l > 0xFFFFFFFFL) {
            this.writeHeader(n, false, true, 0L);
            this.partialBufferLength = 65536;
            this.partialBuffer = new byte[this.partialBufferLength];
            this.partialPower = 16;
            this.partialOffset = 0;
        } else {
            this.writeHeader(n, bl, false, l);
        }
    }

    public BCPGOutputStream(OutputStream outputStream, int n, long l) throws IOException {
        this.out = outputStream;
        this.writeHeader(n, false, false, l);
    }

    public BCPGOutputStream(OutputStream outputStream, int n, byte[] byArray) throws IOException {
        this.out = outputStream;
        this.writeHeader(n, false, true, 0L);
        this.partialBuffer = byArray;
        int n2 = this.partialBuffer.length;
        this.partialPower = 0;
        while (n2 != 1) {
            n2 >>>= 1;
            ++this.partialPower;
        }
        if (this.partialPower > 30) {
            throw new IOException("Buffer cannot be greater than 2^30 in length.");
        }
        this.partialBufferLength = 1 << this.partialPower;
        this.partialOffset = 0;
    }

    private void writeHeader(int n, boolean bl, boolean bl2, long l) throws IOException {
        int n2 = 128;
        if (this.partialBuffer != null) {
            this.partialFlush(true);
            this.partialBuffer = null;
        }
        if (n <= 15 && bl) {
            n2 |= n << 2;
            if (bl2) {
                this.write(n2 | 3);
            } else if (l <= 255L) {
                this.write(n2);
                this.write((byte)l);
            } else if (l <= 65535L) {
                this.write(n2 | 1);
                this.write((byte)(l >> 8));
                this.write((byte)l);
            } else {
                this.write(n2 | 2);
                StreamUtil.writeBodyLen(this, l);
            }
        } else {
            this.write(n2 |= 0x40 | n);
            if (bl2) {
                this.partialOffset = 0;
            } else {
                StreamUtil.writeNewPacketLength(this.out, l);
            }
        }
    }

    private void partialFlush(boolean bl) throws IOException {
        if (bl) {
            StreamUtil.writeNewPacketLength(this.out, this.partialOffset);
            this.out.write(this.partialBuffer, 0, this.partialOffset);
        } else {
            this.out.write(0xE0 | this.partialPower);
            this.out.write(this.partialBuffer, 0, this.partialBufferLength);
        }
        this.partialOffset = 0;
    }

    private void writePartial(byte by) throws IOException {
        if (this.partialOffset == this.partialBufferLength) {
            this.partialFlush(false);
        }
        this.partialBuffer[this.partialOffset++] = by;
    }

    private void writePartial(byte[] byArray, int n, int n2) throws IOException {
        if (this.partialOffset == this.partialBufferLength) {
            this.partialFlush(false);
        }
        if (n2 <= this.partialBufferLength - this.partialOffset) {
            System.arraycopy(byArray, n, this.partialBuffer, this.partialOffset, n2);
        } else {
            System.arraycopy(byArray, n, this.partialBuffer, this.partialOffset, this.partialBufferLength - this.partialOffset);
            n += this.partialBufferLength - this.partialOffset;
            n2 -= this.partialBufferLength - this.partialOffset;
            this.partialFlush(false);
            while (n2 > this.partialBufferLength) {
                System.arraycopy(byArray, n, this.partialBuffer, 0, this.partialBufferLength);
                n += this.partialBufferLength;
                n2 -= this.partialBufferLength;
                this.partialFlush(false);
            }
            System.arraycopy(byArray, n, this.partialBuffer, 0, n2);
        }
        this.partialOffset += n2;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.partialBuffer != null) {
            this.writePartial((byte)n);
        } else {
            this.out.write(n);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.partialBuffer != null) {
            this.writePartial(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    public void writePacket(ContainedPacket containedPacket) throws IOException {
        containedPacket.encode(this);
    }

    void writePacket(int n, byte[] byArray) throws IOException {
        this.writeHeader(n, this.useOldFormat, false, byArray.length);
        this.write(byArray);
    }

    void writePacket(int n, byte[] byArray, boolean bl) throws IOException {
        this.writeHeader(n, bl, false, byArray.length);
        this.write(byArray);
    }

    public void writeObject(BCPGObject bCPGObject) throws IOException {
        bCPGObject.encode(this);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public void finish() throws IOException {
        if (this.partialBuffer != null) {
            this.partialFlush(true);
            Arrays.fill((byte[])this.partialBuffer, (byte)0);
            this.partialBuffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.flush();
        this.out.close();
    }
}

