/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.api;

import java.util.regex.Pattern;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.painless.CompilerSettings;

public class LimitedCharSequence
implements CharSequence {
    private final CharSequence wrapped;
    private final Counter counter;
    private final Pattern pattern;
    private final int limitFactor;
    public static final int MAX_STR_LENGTH = 64;
    private static final String SNIPPET = "...";

    public LimitedCharSequence(CharSequence wrap, Pattern pattern, int limitFactor) {
        if (limitFactor <= 0) {
            throw new IllegalArgumentException("limitFactor must be positive");
        }
        this.wrapped = wrap;
        this.counter = new Counter(limitFactor * this.wrapped.length());
        this.pattern = pattern;
        this.limitFactor = limitFactor;
    }

    public String details() {
        return (String)(this.pattern != null ? "pattern: [" + this.pattern.pattern() + "], " : "") + "limit factor: [" + this.limitFactor + "], char limit: [" + this.counter.charAtLimit + "], count: [" + this.counter.count + "], wrapped: [" + this.snippet(64) + "]";
    }

    String snippet(int maxStrLength) {
        if (maxStrLength < SNIPPET.length() * 6) {
            throw new IllegalArgumentException("max str length must be large enough to include three snippets and three context chars, at least [" + SNIPPET.length() * 6 + "], not [" + maxStrLength + "]");
        }
        if (this.wrapped.length() <= maxStrLength) {
            return this.wrapped.toString();
        }
        return String.valueOf(this.wrapped.subSequence(0, maxStrLength - SNIPPET.length())) + SNIPPET;
    }

    @Override
    public int length() {
        return this.wrapped.length();
    }

    @Override
    public char charAt(int index) {
        ++this.counter.count;
        if (this.counter.hitLimit()) {
            throw new CircuitBreakingException("[scripting] Regular expression considered too many characters, " + this.details() + ", this limit can be changed by changed by the [" + CompilerSettings.REGEX_LIMIT_FACTOR.getKey() + "] setting", CircuitBreaker.Durability.TRANSIENT);
        }
        return this.wrapped.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.wrapped.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.wrapped.toString();
    }

    private static class Counter {
        public final int charAtLimit;
        public int count;

        Counter(int charAtLimit) {
            this.charAtLimit = charAtLimit;
            this.count = 0;
        }

        boolean hitLimit() {
            return this.count > this.charAtLimit;
        }
    }
}

