## 0.0.8 (master)

## 0.0.7 (16-Mar-2016)

### Breaking changes

- [Object reform][gtk221] introduced autogenerated high-level bindings and
  broke some conventions.

  - Constructors don't return `Option`, they never fail.

  - Companion traits renamed e.g. `ButtonTrait` -> `ButtonExt`.

  - Modules are private now, all items are exported at the crate level (e.g.
    `gtk::button::Button` is no longer visible, use `gtk::Button` instead).

  - Dialog APIs made less Rust-y for consistency with upstream.

  - File name types [changed][gtk236] from `&str` to `T: AsRef<Path>`.

  - A few signatures and spellings corrected to match upstream.

- Version features [reintroduced][gtk248] and autodetection is no more. The
  fallback version is 3.4.

    Select the minimal version required by your application like this:
    ```toml
    [dependencies.gtk]
    features = ["v3_10"]
    ```

- Signal handlers [take the receiver by reference][gtk226-1] and support [more
  specific receiver types][gtk226-2].

- New [safe event bindings][gdk95] are [passed to signal handlers][gtk244].
  These bindings have [safe getters][gdk107] while the low-level event structs are
  still reachable [via `as_ref`][examples68].

- New safe [`Error`][glib86-error] and [`Value`][glib95] bindings. `ListStore` and
  `TreeStore` [changed accordingly][gtk238], traded `set_string` for more
  powerful [`set`][gtk241].

- In an ongoing move to [reflect integer unsignedness properly][gtk246]
  `Notebook` switched from `i32` to `u32`, `ListStore` and `TreeStore` partly
  switched to `u32` and `EntryBuffer` switched to `u16`.

### Improvements

- [Object reform][gtk221] benefits include:

  - Automatic generation of [the majority of code][auto-dir], expanding the
    number of implemented classes, eliminating typos and making maintenance
    easier.

  - Unified upcasting and downcasting via the `Cast` trait, proper interface
    support. In particular this makes `Builder` safe to use.

  - Each crate has a `prelude` module, which reexports all traits and some
    ubiquitous types (`Continue`, `Inhibit`). `gtk`'s prelude incorporates
    `glib`'s one.

  - Removal of the C glue layer and gcc dependency.

- The upstream documentation excised from all crates earlier lives in the
  [`lgpl-docs`][lgpl-docs] crate now. It can be embedded into your local copy of
  `gtk` and other crates by enabling the [`embed-lgpl-docs` feature][gtk245].

- [Building][sys21]:

 - Windows users no longer need to delete Rust's bundled gcc.

 - In the absence of `pkg-config` we try to link anyway assuming the libraries
   can be found in the default search path. There are no version checks in this
   case.

 - Setting `GTK_LIB_DIR` skips `pkg-config` altogether.

[auto-dir]: https://github.com/gtk-rs/gtk/tree/master/src/auto
[examples68]: https://github.com/gtk-rs/examples/pull/68
[gdk95]: https://github.com/gtk-rs/gdk/pull/95
[gdk107]: https://github.com/gtk-rs/gdk/pull/107
[glib86-error]: https://github.com/gtk-rs/glib/commit/c1a30e97
[glib95]: https://github.com/gtk-rs/glib/pull/95
[gtk221]: https://github.com/gtk-rs/gtk/pull/221
[gtk226-1]: https://github.com/gkoz/gtk-rs-gtk/commit/edfafb8f
[gtk226-2]: https://github.com/gkoz/gtk-rs-gtk/commit/dda2a242
[gtk236]: https://github.com/gtk-rs/gtk/pull/236
[gtk238]: https://github.com/gtk-rs/gtk/pull/238
[gtk241]: https://github.com/gtk-rs/gtk/pull/241
[gtk244]: https://github.com/gtk-rs/gtk/pull/244
[gtk245]: https://github.com/gtk-rs/gtk/pull/245
[gtk246]: https://github.com/gtk-rs/gtk/issues/246
[gtk248]: https://github.com/gtk-rs/gtk/pull/248
[lgpl-docs]: https://github.com/gtk-rs/lgpl-docs
[prelude]: https://github.com/gtk-rs/gtk/blob/master/src/prelude.rs
[sys21]: https://github.com/gtk-rs/sys/pull/21

## v0.0.6 (28-Nov-2015)

- TBD
