/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _mmhub_3_3_0_OFFSET_HEADER
#define _mmhub_3_3_0_OFFSET_HEADER



// addressBlock: mmhub_dagbdec
// base address: 0x68000
#define regDAGB0_RDCLI0                                                                                 0x0000
#define regDAGB0_RDCLI0_BASE_IDX                                                                        1
#define regDAGB0_RDCLI1                                                                                 0x0001
#define regDAGB0_RDCLI1_BASE_IDX                                                                        1
#define regDAGB0_RDCLI2                                                                                 0x0002
#define regDAGB0_RDCLI2_BASE_IDX                                                                        1
#define regDAGB0_RDCLI3                                                                                 0x0003
#define regDAGB0_RDCLI3_BASE_IDX                                                                        1
#define regDAGB0_RDCLI4                                                                                 0x0004
#define regDAGB0_RDCLI4_BASE_IDX                                                                        1
#define regDAGB0_RDCLI5                                                                                 0x0005
#define regDAGB0_RDCLI5_BASE_IDX                                                                        1
#define regDAGB0_RDCLI6                                                                                 0x0006
#define regDAGB0_RDCLI6_BASE_IDX                                                                        1
#define regDAGB0_RDCLI7                                                                                 0x0007
#define regDAGB0_RDCLI7_BASE_IDX                                                                        1
#define regDAGB0_RDCLI8                                                                                 0x0008
#define regDAGB0_RDCLI8_BASE_IDX                                                                        1
#define regDAGB0_RDCLI9                                                                                 0x0009
#define regDAGB0_RDCLI9_BASE_IDX                                                                        1
#define regDAGB0_RDCLI10                                                                                0x000a
#define regDAGB0_RDCLI10_BASE_IDX                                                                       1
#define regDAGB0_RDCLI11                                                                                0x000b
#define regDAGB0_RDCLI11_BASE_IDX                                                                       1
#define regDAGB0_RDCLI12                                                                                0x000c
#define regDAGB0_RDCLI12_BASE_IDX                                                                       1
#define regDAGB0_RDCLI13                                                                                0x000d
#define regDAGB0_RDCLI13_BASE_IDX                                                                       1
#define regDAGB0_RDCLI14                                                                                0x000e
#define regDAGB0_RDCLI14_BASE_IDX                                                                       1
#define regDAGB0_RDCLI15                                                                                0x000f
#define regDAGB0_RDCLI15_BASE_IDX                                                                       1
#define regDAGB0_RDCLI16                                                                                0x0010
#define regDAGB0_RDCLI16_BASE_IDX                                                                       1
#define regDAGB0_RDCLI17                                                                                0x0011
#define regDAGB0_RDCLI17_BASE_IDX                                                                       1
#define regDAGB0_RDCLI18                                                                                0x0012
#define regDAGB0_RDCLI18_BASE_IDX                                                                       1
#define regDAGB0_RDCLI19                                                                                0x0013
#define regDAGB0_RDCLI19_BASE_IDX                                                                       1
#define regDAGB0_RDCLI20                                                                                0x0014
#define regDAGB0_RDCLI20_BASE_IDX                                                                       1
#define regDAGB0_RDCLI21                                                                                0x0015
#define regDAGB0_RDCLI21_BASE_IDX                                                                       1
#define regDAGB0_RDCLI22                                                                                0x0016
#define regDAGB0_RDCLI22_BASE_IDX                                                                       1
#define regDAGB0_RDCLI23                                                                                0x0017
#define regDAGB0_RDCLI23_BASE_IDX                                                                       1
#define regDAGB0_RDCLI24                                                                                0x0018
#define regDAGB0_RDCLI24_BASE_IDX                                                                       1
#define regDAGB0_RDCLI25                                                                                0x0019
#define regDAGB0_RDCLI25_BASE_IDX                                                                       1
#define regDAGB0_RDCLI26                                                                                0x001a
#define regDAGB0_RDCLI26_BASE_IDX                                                                       1
#define regDAGB0_RDCLI27                                                                                0x001b
#define regDAGB0_RDCLI27_BASE_IDX                                                                       1
#define regDAGB0_RDCLI28                                                                                0x001c
#define regDAGB0_RDCLI28_BASE_IDX                                                                       1
#define regDAGB0_RDCLI29                                                                                0x001d
#define regDAGB0_RDCLI29_BASE_IDX                                                                       1
#define regDAGB0_RDCLI30                                                                                0x001e
#define regDAGB0_RDCLI30_BASE_IDX                                                                       1
#define regDAGB0_RD_CNTL                                                                                0x001f
#define regDAGB0_RD_CNTL_BASE_IDX                                                                       1
#define regDAGB0_RD_IO_CNTL                                                                             0x0020
#define regDAGB0_RD_IO_CNTL_BASE_IDX                                                                    1
#define regDAGB0_RD_GMI_CNTL                                                                            0x0021
#define regDAGB0_RD_GMI_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_ADDR_DAGB                                                                           0x0022
#define regDAGB0_RD_ADDR_DAGB_BASE_IDX                                                                  1
#define regDAGB0_RD_CGTT_CLK_CTRL                                                                       0x0023
#define regDAGB0_RD_CGTT_CLK_CTRL_BASE_IDX                                                              1
#define regDAGB0_L1TLB_RD_CGTT_CLK_CTRL                                                                 0x0024
#define regDAGB0_L1TLB_RD_CGTT_CLK_CTRL_BASE_IDX                                                        1
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST0                                                                0x0025
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST0_BASE_IDX                                                       1
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER0                                                               0x0026
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER0_BASE_IDX                                                      1
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST1                                                                0x0027
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST1_BASE_IDX                                                       1
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER1                                                               0x0028
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER1_BASE_IDX                                                      1
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST2                                                                0x0029
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST2_BASE_IDX                                                       1
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER2                                                               0x002a
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER2_BASE_IDX                                                      1
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST3                                                                0x002b
#define regDAGB0_RD_ADDR_DAGB_MAX_BURST3_BASE_IDX                                                       1
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER3                                                               0x002c
#define regDAGB0_RD_ADDR_DAGB_LAZY_TIMER3_BASE_IDX                                                      1
#define regDAGB0_RD_VC0_CNTL                                                                            0x002d
#define regDAGB0_RD_VC0_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_VC1_CNTL                                                                            0x002e
#define regDAGB0_RD_VC1_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_VC2_CNTL                                                                            0x002f
#define regDAGB0_RD_VC2_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_VC3_CNTL                                                                            0x0030
#define regDAGB0_RD_VC3_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_VC4_CNTL                                                                            0x0031
#define regDAGB0_RD_VC4_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_VC5_CNTL                                                                            0x0032
#define regDAGB0_RD_VC5_CNTL_BASE_IDX                                                                   1
#define regDAGB0_RD_IO_VC_CNTL                                                                          0x0033
#define regDAGB0_RD_IO_VC_CNTL_BASE_IDX                                                                 1
#define regDAGB0_RD_GMI_VC_CNTL                                                                         0x0034
#define regDAGB0_RD_GMI_VC_CNTL_BASE_IDX                                                                1
#define regDAGB0_RD_CNTL_MISC                                                                           0x0035
#define regDAGB0_RD_CNTL_MISC_BASE_IDX                                                                  1
#define regDAGB0_RD_TLB_CREDIT                                                                          0x0036
#define regDAGB0_RD_TLB_CREDIT_BASE_IDX                                                                 1
#define regDAGB0_RDCLI_ASK_PENDING                                                                      0x0037
#define regDAGB0_RDCLI_ASK_PENDING_BASE_IDX                                                             1
#define regDAGB0_RDCLI_GO_PENDING                                                                       0x0038
#define regDAGB0_RDCLI_GO_PENDING_BASE_IDX                                                              1
#define regDAGB0_RDCLI_GBLSEND_PENDING                                                                  0x0039
#define regDAGB0_RDCLI_GBLSEND_PENDING_BASE_IDX                                                         1
#define regDAGB0_RDCLI_TLB_PENDING                                                                      0x003a
#define regDAGB0_RDCLI_TLB_PENDING_BASE_IDX                                                             1
#define regDAGB0_RDCLI_OARB_PENDING                                                                     0x003b
#define regDAGB0_RDCLI_OARB_PENDING_BASE_IDX                                                            1
#define regDAGB0_RDCLI_ASK2ARB_PENDING                                                                  0x003c
#define regDAGB0_RDCLI_ASK2ARB_PENDING_BASE_IDX                                                         1
#define regDAGB0_RDCLI_ASK2DF_PENDING                                                                   0x003d
#define regDAGB0_RDCLI_ASK2DF_PENDING_BASE_IDX                                                          1
#define regDAGB0_RDCLI_OSD_PENDING                                                                      0x003e
#define regDAGB0_RDCLI_OSD_PENDING_BASE_IDX                                                             1
#define regDAGB0_RDCLI_ASK_OSD_PENDING                                                                  0x003f
#define regDAGB0_RDCLI_ASK_OSD_PENDING_BASE_IDX                                                         1
#define regDAGB0_RDCLI_NOALLOC_OVERRIDE                                                                 0x0040
#define regDAGB0_RDCLI_NOALLOC_OVERRIDE_BASE_IDX                                                        1
#define regDAGB0_RDCLI_NOALLOC_OVERRIDE_VALUE                                                           0x0041
#define regDAGB0_RDCLI_NOALLOC_OVERRIDE_VALUE_BASE_IDX                                                  1
#define regDAGB0_WRCLI0                                                                                 0x0042
#define regDAGB0_WRCLI0_BASE_IDX                                                                        1
#define regDAGB0_WRCLI1                                                                                 0x0043
#define regDAGB0_WRCLI1_BASE_IDX                                                                        1
#define regDAGB0_WRCLI2                                                                                 0x0044
#define regDAGB0_WRCLI2_BASE_IDX                                                                        1
#define regDAGB0_WRCLI3                                                                                 0x0045
#define regDAGB0_WRCLI3_BASE_IDX                                                                        1
#define regDAGB0_WRCLI4                                                                                 0x0046
#define regDAGB0_WRCLI4_BASE_IDX                                                                        1
#define regDAGB0_WRCLI5                                                                                 0x0047
#define regDAGB0_WRCLI5_BASE_IDX                                                                        1
#define regDAGB0_WRCLI6                                                                                 0x0048
#define regDAGB0_WRCLI6_BASE_IDX                                                                        1
#define regDAGB0_WRCLI7                                                                                 0x0049
#define regDAGB0_WRCLI7_BASE_IDX                                                                        1
#define regDAGB0_WRCLI8                                                                                 0x004a
#define regDAGB0_WRCLI8_BASE_IDX                                                                        1
#define regDAGB0_WRCLI9                                                                                 0x004b
#define regDAGB0_WRCLI9_BASE_IDX                                                                        1
#define regDAGB0_WRCLI10                                                                                0x004c
#define regDAGB0_WRCLI10_BASE_IDX                                                                       1
#define regDAGB0_WRCLI11                                                                                0x004d
#define regDAGB0_WRCLI11_BASE_IDX                                                                       1
#define regDAGB0_WRCLI12                                                                                0x004e
#define regDAGB0_WRCLI12_BASE_IDX                                                                       1
#define regDAGB0_WRCLI13                                                                                0x004f
#define regDAGB0_WRCLI13_BASE_IDX                                                                       1
#define regDAGB0_WRCLI14                                                                                0x0050
#define regDAGB0_WRCLI14_BASE_IDX                                                                       1
#define regDAGB0_WRCLI15                                                                                0x0051
#define regDAGB0_WRCLI15_BASE_IDX                                                                       1
#define regDAGB0_WRCLI16                                                                                0x0052
#define regDAGB0_WRCLI16_BASE_IDX                                                                       1
#define regDAGB0_WRCLI17                                                                                0x0053
#define regDAGB0_WRCLI17_BASE_IDX                                                                       1
#define regDAGB0_WRCLI18                                                                                0x0054
#define regDAGB0_WRCLI18_BASE_IDX                                                                       1
#define regDAGB0_WRCLI19                                                                                0x0055
#define regDAGB0_WRCLI19_BASE_IDX                                                                       1
#define regDAGB0_WRCLI20                                                                                0x0056
#define regDAGB0_WRCLI20_BASE_IDX                                                                       1
#define regDAGB0_WRCLI21                                                                                0x0057
#define regDAGB0_WRCLI21_BASE_IDX                                                                       1
#define regDAGB0_WRCLI22                                                                                0x0058
#define regDAGB0_WRCLI22_BASE_IDX                                                                       1
#define regDAGB0_WRCLI23                                                                                0x0059
#define regDAGB0_WRCLI23_BASE_IDX                                                                       1
#define regDAGB0_WRCLI24                                                                                0x005a
#define regDAGB0_WRCLI24_BASE_IDX                                                                       1
#define regDAGB0_WRCLI25                                                                                0x005b
#define regDAGB0_WRCLI25_BASE_IDX                                                                       1
#define regDAGB0_WRCLI26                                                                                0x005c
#define regDAGB0_WRCLI26_BASE_IDX                                                                       1
#define regDAGB0_WRCLI27                                                                                0x005d
#define regDAGB0_WRCLI27_BASE_IDX                                                                       1
#define regDAGB0_WRCLI28                                                                                0x005e
#define regDAGB0_WRCLI28_BASE_IDX                                                                       1
#define regDAGB0_WRCLI29                                                                                0x005f
#define regDAGB0_WRCLI29_BASE_IDX                                                                       1
#define regDAGB0_WRCLI30                                                                                0x0060
#define regDAGB0_WRCLI30_BASE_IDX                                                                       1
#define regDAGB0_WR_CNTL                                                                                0x0061
#define regDAGB0_WR_CNTL_BASE_IDX                                                                       1
#define regDAGB0_WR_IO_CNTL                                                                             0x0062
#define regDAGB0_WR_IO_CNTL_BASE_IDX                                                                    1
#define regDAGB0_WR_GMI_CNTL                                                                            0x0063
#define regDAGB0_WR_GMI_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_ADDR_DAGB                                                                           0x0064
#define regDAGB0_WR_ADDR_DAGB_BASE_IDX                                                                  1
#define regDAGB0_WR_CGTT_CLK_CTRL                                                                       0x0065
#define regDAGB0_WR_CGTT_CLK_CTRL_BASE_IDX                                                              1
#define regDAGB0_L1TLB_WR_CGTT_CLK_CTRL                                                                 0x0066
#define regDAGB0_L1TLB_WR_CGTT_CLK_CTRL_BASE_IDX                                                        1
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST0                                                                0x0067
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST0_BASE_IDX                                                       1
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER0                                                               0x0068
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER0_BASE_IDX                                                      1
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST1                                                                0x0069
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST1_BASE_IDX                                                       1
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER1                                                               0x006a
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER1_BASE_IDX                                                      1
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST2                                                                0x006b
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST2_BASE_IDX                                                       1
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER2                                                               0x006c
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER2_BASE_IDX                                                      1
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST3                                                                0x006d
#define regDAGB0_WR_ADDR_DAGB_MAX_BURST3_BASE_IDX                                                       1
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER3                                                               0x006e
#define regDAGB0_WR_ADDR_DAGB_LAZY_TIMER3_BASE_IDX                                                      1
#define regDAGB0_WR_DATA_DAGB                                                                           0x006f
#define regDAGB0_WR_DATA_DAGB_BASE_IDX                                                                  1
#define regDAGB0_WR_DATA_DAGB_MAX_BURST0                                                                0x0070
#define regDAGB0_WR_DATA_DAGB_MAX_BURST0_BASE_IDX                                                       1
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER0                                                               0x0071
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER0_BASE_IDX                                                      1
#define regDAGB0_WR_DATA_DAGB_MAX_BURST1                                                                0x0072
#define regDAGB0_WR_DATA_DAGB_MAX_BURST1_BASE_IDX                                                       1
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER1                                                               0x0073
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER1_BASE_IDX                                                      1
#define regDAGB0_WR_DATA_DAGB_MAX_BURST2                                                                0x0074
#define regDAGB0_WR_DATA_DAGB_MAX_BURST2_BASE_IDX                                                       1
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER2                                                               0x0075
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER2_BASE_IDX                                                      1
#define regDAGB0_WR_DATA_DAGB_MAX_BURST3                                                                0x0076
#define regDAGB0_WR_DATA_DAGB_MAX_BURST3_BASE_IDX                                                       1
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER3                                                               0x0077
#define regDAGB0_WR_DATA_DAGB_LAZY_TIMER3_BASE_IDX                                                      1
#define regDAGB0_WR_VC0_CNTL                                                                            0x0078
#define regDAGB0_WR_VC0_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_VC1_CNTL                                                                            0x0079
#define regDAGB0_WR_VC1_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_VC2_CNTL                                                                            0x007a
#define regDAGB0_WR_VC2_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_VC3_CNTL                                                                            0x007b
#define regDAGB0_WR_VC3_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_VC4_CNTL                                                                            0x007c
#define regDAGB0_WR_VC4_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_VC5_CNTL                                                                            0x007d
#define regDAGB0_WR_VC5_CNTL_BASE_IDX                                                                   1
#define regDAGB0_WR_IO_VC_CNTL                                                                          0x007e
#define regDAGB0_WR_IO_VC_CNTL_BASE_IDX                                                                 1
#define regDAGB0_WR_GMI_VC_CNTL                                                                         0x007f
#define regDAGB0_WR_GMI_VC_CNTL_BASE_IDX                                                                1
#define regDAGB0_WR_CNTL_MISC                                                                           0x0080
#define regDAGB0_WR_CNTL_MISC_BASE_IDX                                                                  1
#define regDAGB0_WR_TLB_CREDIT                                                                          0x0081
#define regDAGB0_WR_TLB_CREDIT_BASE_IDX                                                                 1
#define regDAGB0_WR_DATA_CREDIT                                                                         0x0082
#define regDAGB0_WR_DATA_CREDIT_BASE_IDX                                                                1
#define regDAGB0_WR_MISC_CREDIT                                                                         0x0083
#define regDAGB0_WR_MISC_CREDIT_BASE_IDX                                                                1
#define regDAGB0_WR_DATA_FIFO_CREDIT_CNTL1                                                              0x0084
#define regDAGB0_WR_DATA_FIFO_CREDIT_CNTL1_BASE_IDX                                                     1
#define regDAGB0_WR_ATOMIC_FIFO_CREDIT_CNTL1                                                            0x0085
#define regDAGB0_WR_ATOMIC_FIFO_CREDIT_CNTL1_BASE_IDX                                                   1
#define regDAGB0_WRCLI_ASK_PENDING                                                                      0x0086
#define regDAGB0_WRCLI_ASK_PENDING_BASE_IDX                                                             1
#define regDAGB0_WRCLI_GO_PENDING                                                                       0x0087
#define regDAGB0_WRCLI_GO_PENDING_BASE_IDX                                                              1
#define regDAGB0_WRCLI_GBLSEND_PENDING                                                                  0x0088
#define regDAGB0_WRCLI_GBLSEND_PENDING_BASE_IDX                                                         1
#define regDAGB0_WRCLI_TLB_PENDING                                                                      0x0089
#define regDAGB0_WRCLI_TLB_PENDING_BASE_IDX                                                             1
#define regDAGB0_WRCLI_OARB_PENDING                                                                     0x008a
#define regDAGB0_WRCLI_OARB_PENDING_BASE_IDX                                                            1
#define regDAGB0_WRCLI_ASK2ARB_PENDING                                                                  0x008b
#define regDAGB0_WRCLI_ASK2ARB_PENDING_BASE_IDX                                                         1
#define regDAGB0_WRCLI_ASK2DF_PENDING                                                                   0x008c
#define regDAGB0_WRCLI_ASK2DF_PENDING_BASE_IDX                                                          1
#define regDAGB0_WRCLI_OSD_PENDING                                                                      0x008d
#define regDAGB0_WRCLI_OSD_PENDING_BASE_IDX                                                             1
#define regDAGB0_WRCLI_ASK_OSD_PENDING                                                                  0x008e
#define regDAGB0_WRCLI_ASK_OSD_PENDING_BASE_IDX                                                         1
#define regDAGB0_WRCLI_DBUS_ASK_PENDING                                                                 0x008f
#define regDAGB0_WRCLI_DBUS_ASK_PENDING_BASE_IDX                                                        1
#define regDAGB0_WRCLI_DBUS_GO_PENDING                                                                  0x0090
#define regDAGB0_WRCLI_DBUS_GO_PENDING_BASE_IDX                                                         1
#define regDAGB0_WRCLI_GPU_SNOOP_OVERRIDE                                                               0x0091
#define regDAGB0_WRCLI_GPU_SNOOP_OVERRIDE_BASE_IDX                                                      1
#define regDAGB0_WRCLI_GPU_SNOOP_OVERRIDE_VALUE                                                         0x0092
#define regDAGB0_WRCLI_GPU_SNOOP_OVERRIDE_VALUE_BASE_IDX                                                1
#define regDAGB0_WRCLI_NOALLOC_OVERRIDE                                                                 0x0093
#define regDAGB0_WRCLI_NOALLOC_OVERRIDE_BASE_IDX                                                        1
#define regDAGB0_WRCLI_NOALLOC_OVERRIDE_VALUE                                                           0x0094
#define regDAGB0_WRCLI_NOALLOC_OVERRIDE_VALUE_BASE_IDX                                                  1
#define regDAGB0_DAGB_DLY                                                                               0x0095
#define regDAGB0_DAGB_DLY_BASE_IDX                                                                      1
#define regDAGB0_CNTL_MISC                                                                              0x0096
#define regDAGB0_CNTL_MISC_BASE_IDX                                                                     1
#define regDAGB0_CNTL_MISC2                                                                             0x0097
#define regDAGB0_CNTL_MISC2_BASE_IDX                                                                    1
#define regDAGB0_FIFO_EMPTY                                                                             0x0098
#define regDAGB0_FIFO_EMPTY_BASE_IDX                                                                    1
#define regDAGB0_FIFO_FULL                                                                              0x0099
#define regDAGB0_FIFO_FULL_BASE_IDX                                                                     1
#define regDAGB0_RD_CREDITS_FULL                                                                        0x009a
#define regDAGB0_RD_CREDITS_FULL_BASE_IDX                                                               1
#define regDAGB0_WR_CREDITS_FULL                                                                        0x009b
#define regDAGB0_WR_CREDITS_FULL_BASE_IDX                                                               1
#define regDAGB0_PERFCOUNTER_LO                                                                         0x009c
#define regDAGB0_PERFCOUNTER_LO_BASE_IDX                                                                1
#define regDAGB0_PERFCOUNTER_HI                                                                         0x009d
#define regDAGB0_PERFCOUNTER_HI_BASE_IDX                                                                1
#define regDAGB0_PERFCOUNTER0_CFG                                                                       0x009e
#define regDAGB0_PERFCOUNTER0_CFG_BASE_IDX                                                              1
#define regDAGB0_PERFCOUNTER1_CFG                                                                       0x009f
#define regDAGB0_PERFCOUNTER1_CFG_BASE_IDX                                                              1
#define regDAGB0_PERFCOUNTER2_CFG                                                                       0x00a0
#define regDAGB0_PERFCOUNTER2_CFG_BASE_IDX                                                              1
#define regDAGB0_PERFCOUNTER_RSLT_CNTL                                                                  0x00a1
#define regDAGB0_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                         1
#define regDAGB0_L1TLB_REG_RW                                                                           0x00a2
#define regDAGB0_L1TLB_REG_RW_BASE_IDX                                                                  1
#define regDAGB0_RESERVE1                                                                               0x00a3
#define regDAGB0_RESERVE1_BASE_IDX                                                                      1
#define regDAGB0_RESERVE2                                                                               0x00a4
#define regDAGB0_RESERVE2_BASE_IDX                                                                      1
#define regDAGB0_RESERVE3                                                                               0x00a5
#define regDAGB0_RESERVE3_BASE_IDX                                                                      1
#define regDAGB0_RESERVE4                                                                               0x00a6
#define regDAGB0_RESERVE4_BASE_IDX                                                                      1
#define regDAGB0_SDP_RD_BW_CNTL                                                                         0x00a7
#define regDAGB0_SDP_RD_BW_CNTL_BASE_IDX                                                                1
#define regDAGB0_SDP_PRIORITY_OVERRIDE                                                                  0x00a8
#define regDAGB0_SDP_PRIORITY_OVERRIDE_BASE_IDX                                                         1
#define regDAGB0_SDP_RD_PRIORITY                                                                        0x00a9
#define regDAGB0_SDP_RD_PRIORITY_BASE_IDX                                                               1
#define regDAGB0_SDP_WR_PRIORITY                                                                        0x00aa
#define regDAGB0_SDP_WR_PRIORITY_BASE_IDX                                                               1
#define regDAGB0_SDP_RD_CLI2SDP_VC_MAP                                                                  0x00ab
#define regDAGB0_SDP_RD_CLI2SDP_VC_MAP_BASE_IDX                                                         1
#define regDAGB0_SDP_WR_CLI2SDP_VC_MAP                                                                  0x00ac
#define regDAGB0_SDP_WR_CLI2SDP_VC_MAP_BASE_IDX                                                         1
#define regDAGB0_SDP_ENABLE                                                                             0x00ad
#define regDAGB0_SDP_ENABLE_BASE_IDX                                                                    1
#define regDAGB0_SDP_CREDITS                                                                            0x00ae
#define regDAGB0_SDP_CREDITS_BASE_IDX                                                                   1
#define regDAGB0_SDP_TAG_RESERVE0                                                                       0x00af
#define regDAGB0_SDP_TAG_RESERVE0_BASE_IDX                                                              1
#define regDAGB0_SDP_TAG_RESERVE1                                                                       0x00b0
#define regDAGB0_SDP_TAG_RESERVE1_BASE_IDX                                                              1
#define regDAGB0_SDP_VCC_RESERVE0                                                                       0x00b1
#define regDAGB0_SDP_VCC_RESERVE0_BASE_IDX                                                              1
#define regDAGB0_SDP_VCC_RESERVE1                                                                       0x00b2
#define regDAGB0_SDP_VCC_RESERVE1_BASE_IDX                                                              1
#define regDAGB0_SDP_ERR_STATUS                                                                         0x00b3
#define regDAGB0_SDP_ERR_STATUS_BASE_IDX                                                                1
#define regDAGB0_SDP_REQ_CNTL                                                                           0x00b4
#define regDAGB0_SDP_REQ_CNTL_BASE_IDX                                                                  1
#define regDAGB0_SDP_MISC_AON                                                                           0x00b5
#define regDAGB0_SDP_MISC_AON_BASE_IDX                                                                  1
#define regDAGB0_SDP_MISC                                                                               0x00b6
#define regDAGB0_SDP_MISC_BASE_IDX                                                                      1
#define regDAGB0_SDP_MISC2                                                                              0x00b7
#define regDAGB0_SDP_MISC2_BASE_IDX                                                                     1
#define regDAGB0_SDP_VCD_RESERVE0                                                                       0x00b9
#define regDAGB0_SDP_VCD_RESERVE0_BASE_IDX                                                              1
#define regDAGB0_SDP_VCD_RESERVE1                                                                       0x00ba
#define regDAGB0_SDP_VCD_RESERVE1_BASE_IDX                                                              1
#define regDAGB0_SDP_ARB_CNTL0                                                                          0x00bb
#define regDAGB0_SDP_ARB_CNTL0_BASE_IDX                                                                 1
#define regDAGB0_SDP_ARB_CNTL1                                                                          0x00bc
#define regDAGB0_SDP_ARB_CNTL1_BASE_IDX                                                                 1
#define regDAGB0_SDP_CGTT_CLK_CTRL                                                                      0x00bd
#define regDAGB0_SDP_CGTT_CLK_CTRL_BASE_IDX                                                             1
#define regDAGB0_SDP_LATENCY_SAMPLING                                                                   0x00be
#define regDAGB0_SDP_LATENCY_SAMPLING_BASE_IDX                                                          1


// addressBlock: mmhub_pctldec
// base address: 0x68e00
#define regPCTL_CTRL                                                                                    0x0380
#define regPCTL_CTRL_BASE_IDX                                                                           1
#define regPCTL_MMHUB_DEEPSLEEP_IB                                                                      0x0381
#define regPCTL_MMHUB_DEEPSLEEP_IB_BASE_IDX                                                             1
#define regPCTL_MMHUB_DEEPSLEEP_OVERRIDE                                                                0x0382
#define regPCTL_MMHUB_DEEPSLEEP_OVERRIDE_BASE_IDX                                                       1
#define regPCTL_MMHUB_DEEPSLEEP_OVERRIDE_IB                                                             0x0383
#define regPCTL_MMHUB_DEEPSLEEP_OVERRIDE_IB_BASE_IDX                                                    1
#define regPCTL_PG_IGNORE_DEEPSLEEP                                                                     0x0384
#define regPCTL_PG_IGNORE_DEEPSLEEP_BASE_IDX                                                            1
#define regPCTL_PG_IGNORE_DEEPSLEEP_IB                                                                  0x0385
#define regPCTL_PG_IGNORE_DEEPSLEEP_IB_BASE_IDX                                                         1
#define regPCTL_SLICE0_CFG_DAGB_WRBUSY                                                                  0x0386
#define regPCTL_SLICE0_CFG_DAGB_WRBUSY_BASE_IDX                                                         1
#define regPCTL_SLICE0_CFG_DAGB_RDBUSY                                                                  0x0387
#define regPCTL_SLICE0_CFG_DAGB_RDBUSY_BASE_IDX                                                         1
#define regPCTL_SLICE0_CFG_DS_ALLOW                                                                     0x0388
#define regPCTL_SLICE0_CFG_DS_ALLOW_BASE_IDX                                                            1
#define regPCTL_SLICE0_CFG_DS_ALLOW_IB                                                                  0x0389
#define regPCTL_SLICE0_CFG_DS_ALLOW_IB_BASE_IDX                                                         1
#define regPCTL_SLICE1_CFG_DAGB_WRBUSY                                                                  0x038a
#define regPCTL_SLICE1_CFG_DAGB_WRBUSY_BASE_IDX                                                         1
#define regPCTL_SLICE1_CFG_DAGB_RDBUSY                                                                  0x038b
#define regPCTL_SLICE1_CFG_DAGB_RDBUSY_BASE_IDX                                                         1
#define regPCTL_SLICE1_CFG_DS_ALLOW                                                                     0x038c
#define regPCTL_SLICE1_CFG_DS_ALLOW_BASE_IDX                                                            1
#define regPCTL_SLICE1_CFG_DS_ALLOW_IB                                                                  0x038d
#define regPCTL_SLICE1_CFG_DS_ALLOW_IB_BASE_IDX                                                         1
#define regPCTL_UTCL2_MISC                                                                              0x038e
#define regPCTL_UTCL2_MISC_BASE_IDX                                                                     1
#define regPCTL_SLICE0_MISC                                                                             0x038f
#define regPCTL_SLICE0_MISC_BASE_IDX                                                                    1
#define regPCTL_SLICE1_MISC                                                                             0x0390
#define regPCTL_SLICE1_MISC_BASE_IDX                                                                    1
#define regPCTL_RENG_CTRL                                                                               0x0391
#define regPCTL_RENG_CTRL_BASE_IDX                                                                      1
#define regPCTL_UTCL2_RENG_EXECUTE                                                                      0x0392
#define regPCTL_UTCL2_RENG_EXECUTE_BASE_IDX                                                             1
#define regPCTL_SLICE0_RENG_EXECUTE                                                                     0x0393
#define regPCTL_SLICE0_RENG_EXECUTE_BASE_IDX                                                            1
#define regPCTL_SLICE1_RENG_EXECUTE                                                                     0x0394
#define regPCTL_SLICE1_RENG_EXECUTE_BASE_IDX                                                            1
#define regPCTL_UTCL2_RENG_RAM_INDEX                                                                    0x0395
#define regPCTL_UTCL2_RENG_RAM_INDEX_BASE_IDX                                                           1
#define regPCTL_UTCL2_RENG_RAM_DATA                                                                     0x0396
#define regPCTL_UTCL2_RENG_RAM_DATA_BASE_IDX                                                            1
#define regPCTL_SLICE0_RENG_RAM_INDEX                                                                   0x0397
#define regPCTL_SLICE0_RENG_RAM_INDEX_BASE_IDX                                                          1
#define regPCTL_SLICE0_RENG_RAM_DATA                                                                    0x0398
#define regPCTL_SLICE0_RENG_RAM_DATA_BASE_IDX                                                           1
#define regPCTL_SLICE1_RENG_RAM_INDEX                                                                   0x0399
#define regPCTL_SLICE1_RENG_RAM_INDEX_BASE_IDX                                                          1
#define regPCTL_SLICE1_RENG_RAM_DATA                                                                    0x039a
#define regPCTL_SLICE1_RENG_RAM_DATA_BASE_IDX                                                           1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE0                                                       0x039b
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE0_BASE_IDX                                              1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE1                                                       0x039c
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE1_BASE_IDX                                              1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE2                                                       0x039d
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE2_BASE_IDX                                              1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE3                                                       0x039e
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE3_BASE_IDX                                              1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE4                                                       0x039f
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_RANGE4_BASE_IDX                                              1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_EXCL_SET0                                                    0x03a0
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_EXCL_SET0_BASE_IDX                                           1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_EXCL_SET1                                                    0x03a1
#define regPCTL_UTCL2_STCTRL_REGISTER_SAVE_EXCL_SET1_BASE_IDX                                           1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE0                                                      0x03a2
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE0_BASE_IDX                                             1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE1                                                      0x03a3
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE1_BASE_IDX                                             1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE2                                                      0x03a4
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE2_BASE_IDX                                             1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE3                                                      0x03a5
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE3_BASE_IDX                                             1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE4                                                      0x03a6
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_RANGE4_BASE_IDX                                             1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_EXCL_SET0                                                   0x03a7
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_EXCL_SET0_BASE_IDX                                          1
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_EXCL_SET1                                                   0x03a8
#define regPCTL_SLICE0_STCTRL_REGISTER_SAVE_EXCL_SET1_BASE_IDX                                          1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE0                                                      0x03a9
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE0_BASE_IDX                                             1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE1                                                      0x03aa
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE1_BASE_IDX                                             1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE2                                                      0x03ab
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE2_BASE_IDX                                             1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE3                                                      0x03ac
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE3_BASE_IDX                                             1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE4                                                      0x03ad
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_RANGE4_BASE_IDX                                             1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_EXCL_SET0                                                   0x03ae
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_EXCL_SET0_BASE_IDX                                          1
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_EXCL_SET1                                                   0x03af
#define regPCTL_SLICE1_STCTRL_REGISTER_SAVE_EXCL_SET1_BASE_IDX                                          1
#define regPCTL_STATUS                                                                                  0x03b0
#define regPCTL_STATUS_BASE_IDX                                                                         1
#define regPCTL_PERFCOUNTER_LO                                                                          0x03b1
#define regPCTL_PERFCOUNTER_LO_BASE_IDX                                                                 1
#define regPCTL_PERFCOUNTER_HI                                                                          0x03b2
#define regPCTL_PERFCOUNTER_HI_BASE_IDX                                                                 1
#define regPCTL_PERFCOUNTER0_CFG                                                                        0x03b3
#define regPCTL_PERFCOUNTER0_CFG_BASE_IDX                                                               1
#define regPCTL_PERFCOUNTER1_CFG                                                                        0x03b4
#define regPCTL_PERFCOUNTER1_CFG_BASE_IDX                                                               1
#define regPCTL_PERFCOUNTER_RSLT_CNTL                                                                   0x03b5
#define regPCTL_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                          1
#define regPCTL_RESERVED_0                                                                              0x03b6
#define regPCTL_RESERVED_0_BASE_IDX                                                                     1
#define regPCTL_RESERVED_1                                                                              0x03b7
#define regPCTL_RESERVED_1_BASE_IDX                                                                     1
#define regPCTL_RESERVED_2                                                                              0x03b8
#define regPCTL_RESERVED_2_BASE_IDX                                                                     1
#define regPCTL_RESERVED_3                                                                              0x03b9
#define regPCTL_RESERVED_3_BASE_IDX                                                                     1


// addressBlock: mmhub_l1tlb_mmutcl1pfdec
// base address: 0x69600
#define regMMMC_VM_MX_L1_TLB0_STATUS                                                                    0x0588
#define regMMMC_VM_MX_L1_TLB0_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB1_STATUS                                                                    0x0589
#define regMMMC_VM_MX_L1_TLB1_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB2_STATUS                                                                    0x058a
#define regMMMC_VM_MX_L1_TLB2_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB3_STATUS                                                                    0x058b
#define regMMMC_VM_MX_L1_TLB3_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB4_STATUS                                                                    0x058c
#define regMMMC_VM_MX_L1_TLB4_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB5_STATUS                                                                    0x058d
#define regMMMC_VM_MX_L1_TLB5_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB6_STATUS                                                                    0x058e
#define regMMMC_VM_MX_L1_TLB6_STATUS_BASE_IDX                                                           1
#define regMMMC_VM_MX_L1_TLB7_STATUS                                                                    0x058f
#define regMMMC_VM_MX_L1_TLB7_STATUS_BASE_IDX                                                           1


// addressBlock: mmhub_l1tlb_mmutcl1pldec
// base address: 0x69670
#define regMMMC_VM_MX_L1_PERFCOUNTER0_CFG                                                               0x059c
#define regMMMC_VM_MX_L1_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define regMMMC_VM_MX_L1_PERFCOUNTER1_CFG                                                               0x059d
#define regMMMC_VM_MX_L1_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define regMMMC_VM_MX_L1_PERFCOUNTER2_CFG                                                               0x059e
#define regMMMC_VM_MX_L1_PERFCOUNTER2_CFG_BASE_IDX                                                      1
#define regMMMC_VM_MX_L1_PERFCOUNTER3_CFG                                                               0x059f
#define regMMMC_VM_MX_L1_PERFCOUNTER3_CFG_BASE_IDX                                                      1
#define regMMMC_VM_MX_L1_PERFCOUNTER_RSLT_CNTL                                                          0x05a0
#define regMMMC_VM_MX_L1_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1


// addressBlock: mmhub_l1tlb_mmutcl1prdec
// base address: 0x69690
#define regMMMC_VM_MX_L1_PERFCOUNTER_LO                                                                 0x05a4
#define regMMMC_VM_MX_L1_PERFCOUNTER_LO_BASE_IDX                                                        1
#define regMMMC_VM_MX_L1_PERFCOUNTER_HI                                                                 0x05a5
#define regMMMC_VM_MX_L1_PERFCOUNTER_HI_BASE_IDX                                                        1


// addressBlock: mmhub_l1tlb_mmvmtlspfdec
// base address: 0x696c0
#define regMMMC_VM_MX_L1_TLS0_PROTECTION_FAULT_STATUS                                                   0x0701
#define regMMMC_VM_MX_L1_TLS0_PROTECTION_FAULT_STATUS_BASE_IDX                                          1
#define regMMMC_VM_MX_L1_TLS0_PROTECTION_FAULT_ADDR_LO32                                                0x0702
#define regMMMC_VM_MX_L1_TLS0_PROTECTION_FAULT_ADDR_LO32_BASE_IDX                                       1
#define regMMMC_VM_MX_L1_TLS0_PROTECTION_FAULT_ADDR_HI32                                                0x0703
#define regMMMC_VM_MX_L1_TLS0_PROTECTION_FAULT_ADDR_HI32_BASE_IDX                                       1
#define regMMVM_L2_SAW_CNTL                                                                             0x0704
#define regMMVM_L2_SAW_CNTL_BASE_IDX                                                                    1
#define regMMVM_L2_SAW_CNTL2                                                                            0x0705
#define regMMVM_L2_SAW_CNTL2_BASE_IDX                                                                   1
#define regMMVM_L2_SAW_CNTL3                                                                            0x0706
#define regMMVM_L2_SAW_CNTL3_BASE_IDX                                                                   1
#define regMMVM_L2_SAW_CNTL4                                                                            0x0707
#define regMMVM_L2_SAW_CNTL4_BASE_IDX                                                                   1
#define regMMVM_L2_SAW_CONTEXT0_CNTL                                                                    0x0708
#define regMMVM_L2_SAW_CONTEXT0_CNTL_BASE_IDX                                                           1
#define regMMVM_L2_SAW_CONTEXT0_CNTL2                                                                   0x0709
#define regMMVM_L2_SAW_CONTEXT0_CNTL2_BASE_IDX                                                          1
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                               0x070a
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                      1
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                               0x070b
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                      1
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                              0x070c
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                     1
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                              0x070d
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                     1
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                0x070e
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                       1
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                0x070f
#define regMMVM_L2_SAW_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                       1
#define regMMVM_L2_SAW_CONTEXTS_DISABLE                                                                 0x0710
#define regMMVM_L2_SAW_CONTEXTS_DISABLE_BASE_IDX                                                        1
#define regMMVM_L2_SAW_PIPES_BUSY_LO32                                                                  0x0711
#define regMMVM_L2_SAW_PIPES_BUSY_LO32_BASE_IDX                                                         1
#define regMMVM_L2_SAW_PIPES_BUSY_HI32                                                                  0x0712
#define regMMVM_L2_SAW_PIPES_BUSY_HI32_BASE_IDX                                                         1
#define regMMVM_L2_SAW_PIPES_BUSY_1_LO32                                                                0x0713
#define regMMVM_L2_SAW_PIPES_BUSY_1_LO32_BASE_IDX                                                       1
#define regMMVM_L2_SAW_PIPES_BUSY_1_HI32                                                                0x0714
#define regMMVM_L2_SAW_PIPES_BUSY_1_HI32_BASE_IDX                                                       1


// addressBlock: mmhub_mmutcl2_mmatcl2dec
// base address: 0x69f00
#define regMM_ATC_L2_CNTL                                                                               0x07c0
#define regMM_ATC_L2_CNTL_BASE_IDX                                                                      1
#define regMM_ATC_L2_CNTL2                                                                              0x07c1
#define regMM_ATC_L2_CNTL2_BASE_IDX                                                                     1
#define regMM_ATC_L2_CACHE_DATA0                                                                        0x07c4
#define regMM_ATC_L2_CACHE_DATA0_BASE_IDX                                                               1
#define regMM_ATC_L2_CACHE_DATA1                                                                        0x07c5
#define regMM_ATC_L2_CACHE_DATA1_BASE_IDX                                                               1
#define regMM_ATC_L2_CACHE_DATA2                                                                        0x07c6
#define regMM_ATC_L2_CACHE_DATA2_BASE_IDX                                                               1
#define regMM_ATC_L2_CNTL3                                                                              0x07c7
#define regMM_ATC_L2_CNTL3_BASE_IDX                                                                     1
#define regMM_ATC_L2_CNTL4                                                                              0x07c8
#define regMM_ATC_L2_CNTL4_BASE_IDX                                                                     1
#define regMM_ATC_L2_CNTL5                                                                              0x07c9
#define regMM_ATC_L2_CNTL5_BASE_IDX                                                                     1
#define regMM_ATC_L2_MM_GROUP_RT_CLASSES                                                                0x07ca
#define regMM_ATC_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                       1
#define regMM_ATC_L2_STATUS                                                                             0x07cb
#define regMM_ATC_L2_STATUS_BASE_IDX                                                                    1
#define regMM_ATC_L2_STATUS2                                                                            0x07cc
#define regMM_ATC_L2_STATUS2_BASE_IDX                                                                   1
#define regMM_ATC_L2_MISC_CG                                                                            0x07cd
#define regMM_ATC_L2_MISC_CG_BASE_IDX                                                                   1
#define regMM_ATC_L2_MEM_POWER_LS                                                                       0x07ce
#define regMM_ATC_L2_MEM_POWER_LS_BASE_IDX                                                              1
#define regMM_ATC_L2_CGTT_CLK_CTRL                                                                      0x07cf
#define regMM_ATC_L2_CGTT_CLK_CTRL_BASE_IDX                                                             1
#define regMM_ATC_L2_SDPPORT_CTRL                                                                       0x07d2
#define regMM_ATC_L2_SDPPORT_CTRL_BASE_IDX                                                              1


// addressBlock: mmhub_mmutcl2_mmvml2pfdec
// base address: 0x6a000
#define regMMVM_L2_CNTL                                                                                 0x0800
#define regMMVM_L2_CNTL_BASE_IDX                                                                        1
#define regMMVM_L2_CNTL2                                                                                0x0801
#define regMMVM_L2_CNTL2_BASE_IDX                                                                       1
#define regMMVM_L2_CNTL3                                                                                0x0802
#define regMMVM_L2_CNTL3_BASE_IDX                                                                       1
#define regMMVM_L2_STATUS                                                                               0x0803
#define regMMVM_L2_STATUS_BASE_IDX                                                                      1
#define regMMVM_DUMMY_PAGE_FAULT_CNTL                                                                   0x0804
#define regMMVM_DUMMY_PAGE_FAULT_CNTL_BASE_IDX                                                          1
#define regMMVM_DUMMY_PAGE_FAULT_ADDR_LO32                                                              0x0805
#define regMMVM_DUMMY_PAGE_FAULT_ADDR_LO32_BASE_IDX                                                     1
#define regMMVM_DUMMY_PAGE_FAULT_ADDR_HI32                                                              0x0806
#define regMMVM_DUMMY_PAGE_FAULT_ADDR_HI32_BASE_IDX                                                     1
#define regMMVM_INVALIDATE_CNTL                                                                         0x0807
#define regMMVM_INVALIDATE_CNTL_BASE_IDX                                                                1
#define regMMVM_L2_PROTECTION_FAULT_CNTL                                                                0x0808
#define regMMVM_L2_PROTECTION_FAULT_CNTL_BASE_IDX                                                       1
#define regMMVM_L2_PROTECTION_FAULT_CNTL2                                                               0x0809
#define regMMVM_L2_PROTECTION_FAULT_CNTL2_BASE_IDX                                                      1
#define regMMVM_L2_PROTECTION_FAULT_MM_CNTL3                                                            0x080a
#define regMMVM_L2_PROTECTION_FAULT_MM_CNTL3_BASE_IDX                                                   1
#define regMMVM_L2_PROTECTION_FAULT_MM_CNTL4                                                            0x080b
#define regMMVM_L2_PROTECTION_FAULT_MM_CNTL4_BASE_IDX                                                   1
#define regMMVM_L2_PROTECTION_FAULT_STATUS                                                              0x080c
#define regMMVM_L2_PROTECTION_FAULT_STATUS_BASE_IDX                                                     1
#define regMMVM_L2_PROTECTION_FAULT_ADDR_LO32                                                           0x080d
#define regMMVM_L2_PROTECTION_FAULT_ADDR_LO32_BASE_IDX                                                  1
#define regMMVM_L2_PROTECTION_FAULT_ADDR_HI32                                                           0x080e
#define regMMVM_L2_PROTECTION_FAULT_ADDR_HI32_BASE_IDX                                                  1
#define regMMVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32                                                   0x080f
#define regMMVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32_BASE_IDX                                          1
#define regMMVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32                                                   0x0810
#define regMMVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32_BASE_IDX                                          1
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32                                             0x0812
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32_BASE_IDX                                    1
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32                                             0x0813
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32_BASE_IDX                                    1
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32                                            0x0814
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32_BASE_IDX                                   1
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32                                            0x0815
#define regMMVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32_BASE_IDX                                   1
#define regMMVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32                                                0x0816
#define regMMVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32_BASE_IDX                                       1
#define regMMVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32                                                0x0817
#define regMMVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32_BASE_IDX                                       1
#define regMMVM_L2_CNTL4                                                                                0x0818
#define regMMVM_L2_CNTL4_BASE_IDX                                                                       1
#define regMMVM_L2_MM_GROUP_RT_CLASSES                                                                  0x0819
#define regMMVM_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                         1
#define regMMVM_L2_BANK_SELECT_RESERVED_CID                                                             0x081a
#define regMMVM_L2_BANK_SELECT_RESERVED_CID_BASE_IDX                                                    1
#define regMMVM_L2_BANK_SELECT_RESERVED_CID2                                                            0x081b
#define regMMVM_L2_BANK_SELECT_RESERVED_CID2_BASE_IDX                                                   1
#define regMMVM_L2_CACHE_PARITY_CNTL                                                                    0x081c
#define regMMVM_L2_CACHE_PARITY_CNTL_BASE_IDX                                                           1
#define regMMVM_L2_CGTT_CLK_CTRL                                                                        0x081d
#define regMMVM_L2_CGTT_CLK_CTRL_BASE_IDX                                                               1
#define regMMVM_L2_CNTL5                                                                                0x081e
#define regMMVM_L2_CNTL5_BASE_IDX                                                                       1
#define regMMVM_L2_GCR_CNTL                                                                             0x081f
#define regMMVM_L2_GCR_CNTL_BASE_IDX                                                                    1
#define regMMVM_L2_CGTT_BUSY_CTRL                                                                       0x0820
#define regMMVM_L2_CGTT_BUSY_CTRL_BASE_IDX                                                              1
#define regMMVM_L2_PTE_CACHE_DUMP_CNTL                                                                  0x0821
#define regMMVM_L2_PTE_CACHE_DUMP_CNTL_BASE_IDX                                                         1
#define regMMVM_L2_PTE_CACHE_DUMP_READ                                                                  0x0822
#define regMMVM_L2_PTE_CACHE_DUMP_READ_BASE_IDX                                                         1
#define regMMVM_L2_BANK_SELECT_MASKS                                                                    0x0825
#define regMMVM_L2_BANK_SELECT_MASKS_BASE_IDX                                                           1
#define regMMUTCL2_CREDIT_SAFETY_GROUP_RET_CDC                                                          0x0826
#define regMMUTCL2_CREDIT_SAFETY_GROUP_RET_CDC_BASE_IDX                                                 1
#define regMMUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC                                               0x0827
#define regMMUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC_BASE_IDX                                      1
#define regMMUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC                                             0x0828
#define regMMUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC_BASE_IDX                                    1
#define regMMVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT                                                      0x0829
#define regMMVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT_BASE_IDX                                             1
#define regMMVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ                                                      0x082a
#define regMMVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ_BASE_IDX                                             1


// addressBlock: mmhub_mmutcl2_mmvml2vcdec
// base address: 0x6a100
#define regMMVM_CONTEXT0_CNTL                                                                           0x0840
#define regMMVM_CONTEXT0_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT1_CNTL                                                                           0x0841
#define regMMVM_CONTEXT1_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT2_CNTL                                                                           0x0842
#define regMMVM_CONTEXT2_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT3_CNTL                                                                           0x0843
#define regMMVM_CONTEXT3_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT4_CNTL                                                                           0x0844
#define regMMVM_CONTEXT4_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT5_CNTL                                                                           0x0845
#define regMMVM_CONTEXT5_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT6_CNTL                                                                           0x0846
#define regMMVM_CONTEXT6_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT7_CNTL                                                                           0x0847
#define regMMVM_CONTEXT7_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT8_CNTL                                                                           0x0848
#define regMMVM_CONTEXT8_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT9_CNTL                                                                           0x0849
#define regMMVM_CONTEXT9_CNTL_BASE_IDX                                                                  1
#define regMMVM_CONTEXT10_CNTL                                                                          0x084a
#define regMMVM_CONTEXT10_CNTL_BASE_IDX                                                                 1
#define regMMVM_CONTEXT11_CNTL                                                                          0x084b
#define regMMVM_CONTEXT11_CNTL_BASE_IDX                                                                 1
#define regMMVM_CONTEXT12_CNTL                                                                          0x084c
#define regMMVM_CONTEXT12_CNTL_BASE_IDX                                                                 1
#define regMMVM_CONTEXT13_CNTL                                                                          0x084d
#define regMMVM_CONTEXT13_CNTL_BASE_IDX                                                                 1
#define regMMVM_CONTEXT14_CNTL                                                                          0x084e
#define regMMVM_CONTEXT14_CNTL_BASE_IDX                                                                 1
#define regMMVM_CONTEXT15_CNTL                                                                          0x084f
#define regMMVM_CONTEXT15_CNTL_BASE_IDX                                                                 1
#define regMMVM_CONTEXTS_DISABLE                                                                        0x0850
#define regMMVM_CONTEXTS_DISABLE_BASE_IDX                                                               1
#define regMMVM_INVALIDATE_ENG0_SEM                                                                     0x0851
#define regMMVM_INVALIDATE_ENG0_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG1_SEM                                                                     0x0852
#define regMMVM_INVALIDATE_ENG1_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG2_SEM                                                                     0x0853
#define regMMVM_INVALIDATE_ENG2_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG3_SEM                                                                     0x0854
#define regMMVM_INVALIDATE_ENG3_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG4_SEM                                                                     0x0855
#define regMMVM_INVALIDATE_ENG4_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG5_SEM                                                                     0x0856
#define regMMVM_INVALIDATE_ENG5_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG6_SEM                                                                     0x0857
#define regMMVM_INVALIDATE_ENG6_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG7_SEM                                                                     0x0858
#define regMMVM_INVALIDATE_ENG7_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG8_SEM                                                                     0x0859
#define regMMVM_INVALIDATE_ENG8_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG9_SEM                                                                     0x085a
#define regMMVM_INVALIDATE_ENG9_SEM_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG10_SEM                                                                    0x085b
#define regMMVM_INVALIDATE_ENG10_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG11_SEM                                                                    0x085c
#define regMMVM_INVALIDATE_ENG11_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG12_SEM                                                                    0x085d
#define regMMVM_INVALIDATE_ENG12_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG13_SEM                                                                    0x085e
#define regMMVM_INVALIDATE_ENG13_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG14_SEM                                                                    0x085f
#define regMMVM_INVALIDATE_ENG14_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG15_SEM                                                                    0x0860
#define regMMVM_INVALIDATE_ENG15_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG16_SEM                                                                    0x0861
#define regMMVM_INVALIDATE_ENG16_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG17_SEM                                                                    0x0862
#define regMMVM_INVALIDATE_ENG17_SEM_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG0_REQ                                                                     0x0863
#define regMMVM_INVALIDATE_ENG0_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG1_REQ                                                                     0x0864
#define regMMVM_INVALIDATE_ENG1_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG2_REQ                                                                     0x0865
#define regMMVM_INVALIDATE_ENG2_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG3_REQ                                                                     0x0866
#define regMMVM_INVALIDATE_ENG3_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG4_REQ                                                                     0x0867
#define regMMVM_INVALIDATE_ENG4_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG5_REQ                                                                     0x0868
#define regMMVM_INVALIDATE_ENG5_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG6_REQ                                                                     0x0869
#define regMMVM_INVALIDATE_ENG6_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG7_REQ                                                                     0x086a
#define regMMVM_INVALIDATE_ENG7_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG8_REQ                                                                     0x086b
#define regMMVM_INVALIDATE_ENG8_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG9_REQ                                                                     0x086c
#define regMMVM_INVALIDATE_ENG9_REQ_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG10_REQ                                                                    0x086d
#define regMMVM_INVALIDATE_ENG10_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG11_REQ                                                                    0x086e
#define regMMVM_INVALIDATE_ENG11_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG12_REQ                                                                    0x086f
#define regMMVM_INVALIDATE_ENG12_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG13_REQ                                                                    0x0870
#define regMMVM_INVALIDATE_ENG13_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG14_REQ                                                                    0x0871
#define regMMVM_INVALIDATE_ENG14_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG15_REQ                                                                    0x0872
#define regMMVM_INVALIDATE_ENG15_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG16_REQ                                                                    0x0873
#define regMMVM_INVALIDATE_ENG16_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG17_REQ                                                                    0x0874
#define regMMVM_INVALIDATE_ENG17_REQ_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG0_ACK                                                                     0x0875
#define regMMVM_INVALIDATE_ENG0_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG1_ACK                                                                     0x0876
#define regMMVM_INVALIDATE_ENG1_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG2_ACK                                                                     0x0877
#define regMMVM_INVALIDATE_ENG2_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG3_ACK                                                                     0x0878
#define regMMVM_INVALIDATE_ENG3_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG4_ACK                                                                     0x0879
#define regMMVM_INVALIDATE_ENG4_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG5_ACK                                                                     0x087a
#define regMMVM_INVALIDATE_ENG5_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG6_ACK                                                                     0x087b
#define regMMVM_INVALIDATE_ENG6_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG7_ACK                                                                     0x087c
#define regMMVM_INVALIDATE_ENG7_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG8_ACK                                                                     0x087d
#define regMMVM_INVALIDATE_ENG8_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG9_ACK                                                                     0x087e
#define regMMVM_INVALIDATE_ENG9_ACK_BASE_IDX                                                            1
#define regMMVM_INVALIDATE_ENG10_ACK                                                                    0x087f
#define regMMVM_INVALIDATE_ENG10_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG11_ACK                                                                    0x0880
#define regMMVM_INVALIDATE_ENG11_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG12_ACK                                                                    0x0881
#define regMMVM_INVALIDATE_ENG12_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG13_ACK                                                                    0x0882
#define regMMVM_INVALIDATE_ENG13_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG14_ACK                                                                    0x0883
#define regMMVM_INVALIDATE_ENG14_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG15_ACK                                                                    0x0884
#define regMMVM_INVALIDATE_ENG15_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG16_ACK                                                                    0x0885
#define regMMVM_INVALIDATE_ENG16_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG17_ACK                                                                    0x0886
#define regMMVM_INVALIDATE_ENG17_ACK_BASE_IDX                                                           1
#define regMMVM_INVALIDATE_ENG0_ADDR_RANGE_LO32                                                         0x0887
#define regMMVM_INVALIDATE_ENG0_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG0_ADDR_RANGE_HI32                                                         0x0888
#define regMMVM_INVALIDATE_ENG0_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG1_ADDR_RANGE_LO32                                                         0x0889
#define regMMVM_INVALIDATE_ENG1_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG1_ADDR_RANGE_HI32                                                         0x088a
#define regMMVM_INVALIDATE_ENG1_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG2_ADDR_RANGE_LO32                                                         0x088b
#define regMMVM_INVALIDATE_ENG2_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG2_ADDR_RANGE_HI32                                                         0x088c
#define regMMVM_INVALIDATE_ENG2_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG3_ADDR_RANGE_LO32                                                         0x088d
#define regMMVM_INVALIDATE_ENG3_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG3_ADDR_RANGE_HI32                                                         0x088e
#define regMMVM_INVALIDATE_ENG3_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG4_ADDR_RANGE_LO32                                                         0x088f
#define regMMVM_INVALIDATE_ENG4_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG4_ADDR_RANGE_HI32                                                         0x0890
#define regMMVM_INVALIDATE_ENG4_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG5_ADDR_RANGE_LO32                                                         0x0891
#define regMMVM_INVALIDATE_ENG5_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG5_ADDR_RANGE_HI32                                                         0x0892
#define regMMVM_INVALIDATE_ENG5_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG6_ADDR_RANGE_LO32                                                         0x0893
#define regMMVM_INVALIDATE_ENG6_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG6_ADDR_RANGE_HI32                                                         0x0894
#define regMMVM_INVALIDATE_ENG6_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG7_ADDR_RANGE_LO32                                                         0x0895
#define regMMVM_INVALIDATE_ENG7_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG7_ADDR_RANGE_HI32                                                         0x0896
#define regMMVM_INVALIDATE_ENG7_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG8_ADDR_RANGE_LO32                                                         0x0897
#define regMMVM_INVALIDATE_ENG8_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG8_ADDR_RANGE_HI32                                                         0x0898
#define regMMVM_INVALIDATE_ENG8_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG9_ADDR_RANGE_LO32                                                         0x0899
#define regMMVM_INVALIDATE_ENG9_ADDR_RANGE_LO32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG9_ADDR_RANGE_HI32                                                         0x089a
#define regMMVM_INVALIDATE_ENG9_ADDR_RANGE_HI32_BASE_IDX                                                1
#define regMMVM_INVALIDATE_ENG10_ADDR_RANGE_LO32                                                        0x089b
#define regMMVM_INVALIDATE_ENG10_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG10_ADDR_RANGE_HI32                                                        0x089c
#define regMMVM_INVALIDATE_ENG10_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG11_ADDR_RANGE_LO32                                                        0x089d
#define regMMVM_INVALIDATE_ENG11_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG11_ADDR_RANGE_HI32                                                        0x089e
#define regMMVM_INVALIDATE_ENG11_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG12_ADDR_RANGE_LO32                                                        0x089f
#define regMMVM_INVALIDATE_ENG12_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG12_ADDR_RANGE_HI32                                                        0x08a0
#define regMMVM_INVALIDATE_ENG12_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG13_ADDR_RANGE_LO32                                                        0x08a1
#define regMMVM_INVALIDATE_ENG13_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG13_ADDR_RANGE_HI32                                                        0x08a2
#define regMMVM_INVALIDATE_ENG13_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG14_ADDR_RANGE_LO32                                                        0x08a3
#define regMMVM_INVALIDATE_ENG14_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG14_ADDR_RANGE_HI32                                                        0x08a4
#define regMMVM_INVALIDATE_ENG14_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG15_ADDR_RANGE_LO32                                                        0x08a5
#define regMMVM_INVALIDATE_ENG15_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG15_ADDR_RANGE_HI32                                                        0x08a6
#define regMMVM_INVALIDATE_ENG15_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG16_ADDR_RANGE_LO32                                                        0x08a7
#define regMMVM_INVALIDATE_ENG16_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG16_ADDR_RANGE_HI32                                                        0x08a8
#define regMMVM_INVALIDATE_ENG16_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG17_ADDR_RANGE_LO32                                                        0x08a9
#define regMMVM_INVALIDATE_ENG17_ADDR_RANGE_LO32_BASE_IDX                                               1
#define regMMVM_INVALIDATE_ENG17_ADDR_RANGE_HI32                                                        0x08aa
#define regMMVM_INVALIDATE_ENG17_ADDR_RANGE_HI32_BASE_IDX                                               1
#define regMMVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08ab
#define regMMVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08ac
#define regMMVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08ad
#define regMMVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08ae
#define regMMVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08af
#define regMMVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08b0
#define regMMVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08b1
#define regMMVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08b2
#define regMMVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08b3
#define regMMVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08b4
#define regMMVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08b5
#define regMMVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08b6
#define regMMVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08b7
#define regMMVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08b8
#define regMMVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08b9
#define regMMVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08ba
#define regMMVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08bb
#define regMMVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08bc
#define regMMVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                      0x08bd
#define regMMVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                      0x08be
#define regMMVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                     0x08bf
#define regMMVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                     0x08c0
#define regMMVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                     0x08c1
#define regMMVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                     0x08c2
#define regMMVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                     0x08c3
#define regMMVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                     0x08c4
#define regMMVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                     0x08c5
#define regMMVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                     0x08c6
#define regMMVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                     0x08c7
#define regMMVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                     0x08c8
#define regMMVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                     0x08c9
#define regMMVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                     0x08ca
#define regMMVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                     0x08cb
#define regMMVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                     0x08cc
#define regMMVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                     0x08cd
#define regMMVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                     0x08ce
#define regMMVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                     0x08cf
#define regMMVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                     0x08d0
#define regMMVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                     0x08d1
#define regMMVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                     0x08d2
#define regMMVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                     0x08d3
#define regMMVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                     0x08d4
#define regMMVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                     0x08d5
#define regMMVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                     0x08d6
#define regMMVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                     0x08d7
#define regMMVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                     0x08d8
#define regMMVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                     0x08d9
#define regMMVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                     0x08da
#define regMMVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                     0x08db
#define regMMVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                     0x08dc
#define regMMVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                     0x08dd
#define regMMVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            1
#define regMMVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                     0x08de
#define regMMVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            1
#define regMMVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                    0x08df
#define regMMVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           1
#define regMMVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                    0x08e0
#define regMMVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           1
#define regMMVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                    0x08e1
#define regMMVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           1
#define regMMVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                    0x08e2
#define regMMVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           1
#define regMMVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                    0x08e3
#define regMMVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           1
#define regMMVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                    0x08e4
#define regMMVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           1
#define regMMVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                    0x08e5
#define regMMVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           1
#define regMMVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                    0x08e6
#define regMMVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           1
#define regMMVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                    0x08e7
#define regMMVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           1
#define regMMVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                    0x08e8
#define regMMVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           1
#define regMMVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                    0x08e9
#define regMMVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           1
#define regMMVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                    0x08ea
#define regMMVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           1
#define regMMVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                       0x08eb
#define regMMVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                       0x08ec
#define regMMVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                       0x08ed
#define regMMVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                       0x08ee
#define regMMVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                       0x08ef
#define regMMVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                       0x08f0
#define regMMVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                       0x08f1
#define regMMVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                       0x08f2
#define regMMVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                       0x08f3
#define regMMVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                       0x08f4
#define regMMVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                       0x08f5
#define regMMVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                       0x08f6
#define regMMVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                       0x08f7
#define regMMVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                       0x08f8
#define regMMVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                       0x08f9
#define regMMVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                       0x08fa
#define regMMVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                       0x08fb
#define regMMVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                       0x08fc
#define regMMVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                       0x08fd
#define regMMVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              1
#define regMMVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                       0x08fe
#define regMMVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              1
#define regMMVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                      0x08ff
#define regMMVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                      0x0900
#define regMMVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                      0x0901
#define regMMVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                      0x0902
#define regMMVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                      0x0903
#define regMMVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                      0x0904
#define regMMVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                      0x0905
#define regMMVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                      0x0906
#define regMMVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                      0x0907
#define regMMVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                      0x0908
#define regMMVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                      0x0909
#define regMMVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             1
#define regMMVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                      0x090a
#define regMMVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             1
#define regMMVM_L2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                                    0x090b
#define regMMVM_L2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                           1
#define regMMVM_L2_CONTEXT0_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x090c
#define regMMVM_L2_CONTEXT0_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT1_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x090d
#define regMMVM_L2_CONTEXT1_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x090e
#define regMMVM_L2_CONTEXT2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT3_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x090f
#define regMMVM_L2_CONTEXT3_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT4_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x0910
#define regMMVM_L2_CONTEXT4_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT5_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x0911
#define regMMVM_L2_CONTEXT5_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT6_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x0912
#define regMMVM_L2_CONTEXT6_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT7_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x0913
#define regMMVM_L2_CONTEXT7_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT8_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x0914
#define regMMVM_L2_CONTEXT8_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT9_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x0915
#define regMMVM_L2_CONTEXT9_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  1
#define regMMVM_L2_CONTEXT10_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x0916
#define regMMVM_L2_CONTEXT10_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 1
#define regMMVM_L2_CONTEXT11_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x0917
#define regMMVM_L2_CONTEXT11_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 1
#define regMMVM_L2_CONTEXT12_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x0918
#define regMMVM_L2_CONTEXT12_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 1
#define regMMVM_L2_CONTEXT13_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x0919
#define regMMVM_L2_CONTEXT13_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 1
#define regMMVM_L2_CONTEXT14_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x091a
#define regMMVM_L2_CONTEXT14_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 1
#define regMMVM_L2_CONTEXT15_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x091b
#define regMMVM_L2_CONTEXT15_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 1


// addressBlock: mmhub_mmutcl2_mmvml2pldec
// base address: 0x6a490
#define regMMMC_VM_L2_PERFCOUNTER0_CFG                                                                  0x0924
#define regMMMC_VM_L2_PERFCOUNTER0_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER1_CFG                                                                  0x0925
#define regMMMC_VM_L2_PERFCOUNTER1_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER2_CFG                                                                  0x0926
#define regMMMC_VM_L2_PERFCOUNTER2_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER3_CFG                                                                  0x0927
#define regMMMC_VM_L2_PERFCOUNTER3_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER4_CFG                                                                  0x0928
#define regMMMC_VM_L2_PERFCOUNTER4_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER5_CFG                                                                  0x0929
#define regMMMC_VM_L2_PERFCOUNTER5_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER6_CFG                                                                  0x092a
#define regMMMC_VM_L2_PERFCOUNTER6_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER7_CFG                                                                  0x092b
#define regMMMC_VM_L2_PERFCOUNTER7_CFG_BASE_IDX                                                         1
#define regMMMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                                             0x092c
#define regMMMC_VM_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                    1
#define regMMUTCL2_PERFCOUNTER0_CFG                                                                     0x092d
#define regMMUTCL2_PERFCOUNTER0_CFG_BASE_IDX                                                            1
#define regMMUTCL2_PERFCOUNTER1_CFG                                                                     0x092e
#define regMMUTCL2_PERFCOUNTER1_CFG_BASE_IDX                                                            1
#define regMMUTCL2_PERFCOUNTER2_CFG                                                                     0x092f
#define regMMUTCL2_PERFCOUNTER2_CFG_BASE_IDX                                                            1
#define regMMUTCL2_PERFCOUNTER3_CFG                                                                     0x0930
#define regMMUTCL2_PERFCOUNTER3_CFG_BASE_IDX                                                            1
#define regMMUTCL2_PERFCOUNTER_RSLT_CNTL                                                                0x0931
#define regMMUTCL2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                       1


// addressBlock: mmhub_mmutcl2_mmvml2prdec
// base address: 0x6a4e0
#define regMMMC_VM_L2_PERFCOUNTER_LO                                                                    0x0938
#define regMMMC_VM_L2_PERFCOUNTER_LO_BASE_IDX                                                           1
#define regMMMC_VM_L2_PERFCOUNTER_HI                                                                    0x0939
#define regMMMC_VM_L2_PERFCOUNTER_HI_BASE_IDX                                                           1
#define regMMUTCL2_PERFCOUNTER_LO                                                                       0x093a
#define regMMUTCL2_PERFCOUNTER_LO_BASE_IDX                                                              1
#define regMMUTCL2_PERFCOUNTER_HI                                                                       0x093b
#define regMMUTCL2_PERFCOUNTER_HI_BASE_IDX                                                              1


// addressBlock: mmhub_mmutcl2_mmvmsharedhvdec
// base address: 0x6a530
#define regMMVM_PCIE_ATS_CNTL                                                                           0x094c
#define regMMVM_PCIE_ATS_CNTL_BASE_IDX                                                                  1


// addressBlock: mmhub_mmutcl2_mmvmsharedpfdec
// base address: 0x6a740
#define regMMMC_VM_NB_MMIOBASE                                                                          0x09d0
#define regMMMC_VM_NB_MMIOBASE_BASE_IDX                                                                 1
#define regMMMC_VM_NB_MMIOLIMIT                                                                         0x09d1
#define regMMMC_VM_NB_MMIOLIMIT_BASE_IDX                                                                1
#define regMMMC_VM_NB_PCI_CTRL                                                                          0x09d2
#define regMMMC_VM_NB_PCI_CTRL_BASE_IDX                                                                 1
#define regMMMC_VM_NB_PCI_ARB                                                                           0x09d3
#define regMMMC_VM_NB_PCI_ARB_BASE_IDX                                                                  1
#define regMMMC_VM_NB_TOP_OF_DRAM_SLOT1                                                                 0x09d4
#define regMMMC_VM_NB_TOP_OF_DRAM_SLOT1_BASE_IDX                                                        1
#define regMMMC_VM_NB_LOWER_TOP_OF_DRAM2                                                                0x09d5
#define regMMMC_VM_NB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                       1
#define regMMMC_VM_NB_UPPER_TOP_OF_DRAM2                                                                0x09d6
#define regMMMC_VM_NB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                       1
#define regMMMC_VM_FB_OFFSET                                                                            0x09d7
#define regMMMC_VM_FB_OFFSET_BASE_IDX                                                                   1
#define regMMMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB                                                     0x09d8
#define regMMMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB_BASE_IDX                                            1
#define regMMMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB                                                     0x09d9
#define regMMMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB_BASE_IDX                                            1
#define regMMMC_VM_STEERING                                                                             0x09da
#define regMMMC_VM_STEERING_BASE_IDX                                                                    1
#define regMMMC_SHARED_VIRT_RESET_REQ                                                                   0x09db
#define regMMMC_SHARED_VIRT_RESET_REQ_BASE_IDX                                                          1
#define regMMMC_MEM_POWER_LS                                                                            0x09dc
#define regMMMC_MEM_POWER_LS_BASE_IDX                                                                   1
#define regMMMC_VM_CACHEABLE_DRAM_ADDRESS_START                                                         0x09dd
#define regMMMC_VM_CACHEABLE_DRAM_ADDRESS_START_BASE_IDX                                                1
#define regMMMC_VM_CACHEABLE_DRAM_ADDRESS_END                                                           0x09de
#define regMMMC_VM_CACHEABLE_DRAM_ADDRESS_END_BASE_IDX                                                  1
#define regMMMC_VM_LOCAL_SYSMEM_ADDRESS_START                                                           0x09df
#define regMMMC_VM_LOCAL_SYSMEM_ADDRESS_START_BASE_IDX                                                  1
#define regMMMC_VM_LOCAL_SYSMEM_ADDRESS_END                                                             0x09e0
#define regMMMC_VM_LOCAL_SYSMEM_ADDRESS_END_BASE_IDX                                                    1
#define regMMMC_VM_APT_CNTL                                                                             0x09e1
#define regMMMC_VM_APT_CNTL_BASE_IDX                                                                    1
#define regMMMC_VM_LOCAL_FB_ADDRESS_START                                                               0x09e2
#define regMMMC_VM_LOCAL_FB_ADDRESS_START_BASE_IDX                                                      1
#define regMMMC_VM_LOCAL_FB_ADDRESS_END                                                                 0x09e3
#define regMMMC_VM_LOCAL_FB_ADDRESS_END_BASE_IDX                                                        1
#define regMMMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL                                                           0x09e4
#define regMMMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL_BASE_IDX                                                  1
#define regMMUTCL2_CGTT_CLK_CTRL                                                                        0x09e5
#define regMMUTCL2_CGTT_CLK_CTRL_BASE_IDX                                                               1
#define regMMMC_SHARED_ACTIVE_FCN_ID                                                                    0x09e6
#define regMMMC_SHARED_ACTIVE_FCN_ID_BASE_IDX                                                           1
#define regMMUTCL2_CGTT_BUSY_CTRL                                                                       0x09e7
#define regMMUTCL2_CGTT_BUSY_CTRL_BASE_IDX                                                              1
#define regMMMC_VM_FB_NOALLOC_CNTL                                                                      0x09e8
#define regMMMC_VM_FB_NOALLOC_CNTL_BASE_IDX                                                             1
#define regMMUTCL2_HARVEST_BYPASS_GROUPS                                                                0x09e9
#define regMMUTCL2_HARVEST_BYPASS_GROUPS_BASE_IDX                                                       1
#define regMMUTCL2_GROUP_RET_FAULT_STATUS                                                               0x09eb
#define regMMUTCL2_GROUP_RET_FAULT_STATUS_BASE_IDX                                                      1


// addressBlock: mmhub_mmutcl2_mmvmsharedvcdec
// base address: 0x6a7b0
#define regMMMC_VM_FB_LOCATION_BASE                                                                     0x09ec
#define regMMMC_VM_FB_LOCATION_BASE_BASE_IDX                                                            1
#define regMMMC_VM_FB_LOCATION_TOP                                                                      0x09ed
#define regMMMC_VM_FB_LOCATION_TOP_BASE_IDX                                                             1
#define regMMMC_VM_AGP_TOP                                                                              0x09ee
#define regMMMC_VM_AGP_TOP_BASE_IDX                                                                     1
#define regMMMC_VM_AGP_BOT                                                                              0x09ef
#define regMMMC_VM_AGP_BOT_BASE_IDX                                                                     1
#define regMMMC_VM_AGP_BASE                                                                             0x09f0
#define regMMMC_VM_AGP_BASE_BASE_IDX                                                                    1
#define regMMMC_VM_SYSTEM_APERTURE_LOW_ADDR                                                             0x09f1
#define regMMMC_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                                    1
#define regMMMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                                            0x09f2
#define regMMMC_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                                   1
#define regMMMC_VM_MX_L1_TLB_CNTL                                                                       0x09f3
#define regMMMC_VM_MX_L1_TLB_CNTL_BASE_IDX                                                              1


// addressBlock: mmhub_mmutcl2_mmatcl2pfcntrdec
// base address: 0x6a800
#define regMM_ATC_L2_PERFCOUNTER_LO                                                                     0x0a00
#define regMM_ATC_L2_PERFCOUNTER_LO_BASE_IDX                                                            1
#define regMM_ATC_L2_PERFCOUNTER_HI                                                                     0x0a01
#define regMM_ATC_L2_PERFCOUNTER_HI_BASE_IDX                                                            1


// addressBlock: mmhub_mmutcl2_mmatcl2pfcntldec
// base address: 0x6a820
#define regMM_ATC_L2_PERFCOUNTER0_CFG                                                                   0x0a08
#define regMM_ATC_L2_PERFCOUNTER0_CFG_BASE_IDX                                                          1
#define regMM_ATC_L2_PERFCOUNTER1_CFG                                                                   0x0a09
#define regMM_ATC_L2_PERFCOUNTER1_CFG_BASE_IDX                                                          1
#define regMM_ATC_L2_PERFCOUNTER_RSLT_CNTL                                                              0x0a0a
#define regMM_ATC_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                     1


// addressBlock: mmhub_mmutcl2_mmvml2pspdec
// base address: 0x6ae50
#define regMMUTCL2_TRANSLATION_BYPASS_BY_VMID                                                           0x0b94
#define regMMUTCL2_TRANSLATION_BYPASS_BY_VMID_BASE_IDX                                                  1
#define regMMVM_IOMMU_GPU_HOST_TRANSLATION_ENABLE                                                       0x0b96
#define regMMVM_IOMMU_GPU_HOST_TRANSLATION_ENABLE_BASE_IDX                                              1
#define regMMVM_IOMMU_CONTROL_REGISTER                                                                  0x0b97
#define regMMVM_IOMMU_CONTROL_REGISTER_BASE_IDX                                                         1
#define regMMVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER                                         0x0b98
#define regMMVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER_BASE_IDX                                1
#define regMMUTC_TRANSLATION_FAULT_CNTL0                                                                0x0b99
#define regMMUTC_TRANSLATION_FAULT_CNTL0_BASE_IDX                                                       1
#define regMMUTC_TRANSLATION_FAULT_CNTL1                                                                0x0b9a
#define regMMUTC_TRANSLATION_FAULT_CNTL1_BASE_IDX                                                       1
#define regMMUTCL2_VSCH_POWER_STATUS                                                                    0x0b9b
#define regMMUTCL2_VSCH_POWER_STATUS_BASE_IDX                                                           1


// addressBlock: mmhub_mmutcl2_mml2tlbpspdec
// base address: 0x6ae80
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_CNTL                                                     0x0ba0
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_CNTL_BASE_IDX                                            1


// addressBlock: mmhub_mmutcl2_mmatcl2pspdec
// base address: 0x6ae90
#define regMM_ATC_L2_IOV_MODE_CNTL                                                                      0x0ba4
#define regMM_ATC_L2_IOV_MODE_CNTL_BASE_IDX                                                             1


// addressBlock: mmhub_mmutcl2_mml2tlbpfdec
// base address: 0x6aec0
#define regMML2TLB_TLB0_STATUS                                                                          0x0bb1
#define regMML2TLB_TLB0_STATUS_BASE_IDX                                                                 1
#define regMML2TLB_TMZ_CNTL                                                                             0x0bb2
#define regMML2TLB_TMZ_CNTL_BASE_IDX                                                                    1
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_LO                                               0x0bb3
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_LO_BASE_IDX                                      1
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_HI                                               0x0bb4
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_HI_BASE_IDX                                      1
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_LO                                              0x0bb5
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_LO_BASE_IDX                                     1
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_HI                                              0x0bb6
#define regMMUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_HI_BASE_IDX                                     1
#define regMMUTCL2_L2TLB_CREDIT_SAFETY_FETCH_RDREQ                                                      0x0bb7
#define regMMUTCL2_L2TLB_CREDIT_SAFETY_FETCH_RDREQ_BASE_IDX                                             1


// addressBlock: mmhub_mmutcl2_mml2tlbpldec
// base address: 0x6af00
#define regMML2TLB_PERFCOUNTER0_CFG                                                                     0x0bc0
#define regMML2TLB_PERFCOUNTER0_CFG_BASE_IDX                                                            1
#define regMML2TLB_PERFCOUNTER1_CFG                                                                     0x0bc1
#define regMML2TLB_PERFCOUNTER1_CFG_BASE_IDX                                                            1
#define regMML2TLB_PERFCOUNTER2_CFG                                                                     0x0bc2
#define regMML2TLB_PERFCOUNTER2_CFG_BASE_IDX                                                            1
#define regMML2TLB_PERFCOUNTER3_CFG                                                                     0x0bc3
#define regMML2TLB_PERFCOUNTER3_CFG_BASE_IDX                                                            1
#define regMML2TLB_PERFCOUNTER_RSLT_CNTL                                                                0x0bc4
#define regMML2TLB_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                       1


// addressBlock: mmhub_mmutcl2_mml2tlbprdec
// base address: 0x6af20
#define regMML2TLB_PERFCOUNTER_LO                                                                       0x0bc8
#define regMML2TLB_PERFCOUNTER_LO_BASE_IDX                                                              1
#define regMML2TLB_PERFCOUNTER_HI                                                                       0x0bc9
#define regMML2TLB_PERFCOUNTER_HI_BASE_IDX                                                              1

#endif
