package Evo::Path;
use Evo -Class;
use overload
  '""'     => sub { shift->to_string },
  fallback => 1;

has base => '/';
has children => sub { [] };


sub append ($self, $path) {
  $path =~ s#/+$##;
  $path =~ s#^/+##;
  (ref $self)
    ->new(base => $self->base, children => [grep { !!$_ } $self->children->@*, split '/', $path]);
}

sub to_string($self) {
  my $base = $self->base;
  $base .= '/' unless $base =~ m#/$#;
  $base . join '/', $self->children->@*;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Path

=head1 VERSION

version 0.0307

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
