# Generated by default/object.tt
package Paws::SESv2::ImportDestination;
  use Moose;
  has ContactListDestination => (is => 'ro', isa => 'Paws::SESv2::ContactListDestination');
  has SuppressionListDestination => (is => 'ro', isa => 'Paws::SESv2::SuppressionListDestination');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::ImportDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::ImportDestination object:

  $service_obj->Method(Att1 => { ContactListDestination => $value, ..., SuppressionListDestination => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::ImportDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactListDestination

=head1 DESCRIPTION

An object that contains details about the resource destination the
import job is going to target.

=head1 ATTRIBUTES


=head2 ContactListDestination => L<Paws::SESv2::ContactListDestination>

An object that contains the action of the import job towards a contact
list.


=head2 SuppressionListDestination => L<Paws::SESv2::SuppressionListDestination>

An object that contains the action of the import job towards
suppression list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

