package WordList::EN::PersonName::PopularBabyName::US::SSA::1990::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_whitespace",0,"num_words_contains_whitespace",0,"num_words",1000,"longest_word_len",11,"num_words_contain_nonword_chars",0,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"num_words_contain_unicode",0,"shortest_word_len",2,"avg_word_len",5.832); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1990 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::1990::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1990 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::1990::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::1990::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::1990::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.832 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Michael
Christopher
Matthew
Joshua
Daniel
David
Andrew
James
Justin
Joseph
Ryan
John
Robert
Nicholas
Anthony
William
Jonathan
Kyle
Brandon
Jacob
Tyler
Zachary
Kevin
Eric
Steven
Thomas
Brian
Alexander
Jordan
Timothy
Cody
Adam
Benjamin
Aaron
Richard
Patrick
Sean
Charles
Stephen
Jeremy
Jose
Travis
Jeffrey
Nathan
Samuel
Jason
Mark
Jesse
Paul
Dustin
Gregory
Kenneth
Scott
Derek
Austin
Corey
Bryan
Ethan
Alex
Christian
Juan
Cameron
Jared
Taylor
Bradley
Luis
Cory
Edward
Shawn
Ian
Evan
Marcus
Shane
Peter
Carlos
Trevor
Antonio
Vincent
George
Keith
Phillip
Victor
Dylan
Brett
Chad
Nathaniel
Donald
Caleb
Casey
Jesus
Blake
Raymond
Mitchell
Adrian
Joel
Erik
Ronald
Devin
Garrett
Miguel
Gabriel
Seth
Douglas
Logan
Spencer
Derrick
Wesley
Johnathan
Frank
Chase
Philip
Lucas
Martin
Gary
Francisco
Jorge
Craig
Luke
Mario
Ricardo
Curtis
Colin
Julian
Jonathon
Alan
Alejandro
Brent
Troy
Dennis
Johnny
Randy
Isaac
Angel
Manuel
Oscar
Jeffery
Andre
Henry
Colton
Jake
Allen
Russell
Edgar
Larry
Carl
Jerry
Tony
Mathew
Eduardo
Roberto
Devon
Darius
Clayton
Jeremiah
Brendan
Hector
Javier
Todd
Omar
Drew
Sergio
Danny
Marc
Terry
Kristopher
Jack
Albert
Louis
Bryce
Edwin
Max
Jimmy
Calvin
Lawrence
Micheal
Ricky
Ivan
Ruben
Fernando
Levi
Rodney
Lance
Grant
Dillon
Bobby
Xavier
Nicolas
Dominic
Maxwell
Ross
Walter
Randall
Dalton
Julio
Dakota
Arthur
Pedro
Preston
Cesar
Darren
Rafael
Clinton
Andres
Bryant
Maurice
Isaiah
Dominique
Mason
Raul
Joe
Roger
Gerald
Lee
Billy
Jaime
Jon
Jay
Emmanuel
Hunter
Tanner
Willie
Connor
Erick
Alberto
Shaun
Marco
Jamie
Noah
Armando
Reginald
Jessie
Eddie
Theodore
Zachery
Roy
Terrance
Marvin
Micah
Bruce
Collin
Malcolm
Wayne
Elijah
Abraham
Colby
Darrell
Jamal
Geoffrey
Cole
Johnathon
Ramon
Frederick
Trent
Gerardo
Terrence
Darryl
Brock
Arturo
Marquis
Tyrone
Neil
Ronnie
Enrique
Jerome
Byron
Trenton
Steve
Nickolas
Miles
Tommy
Alec
Alfredo
Marcos
Kurt
Andy
Deandre
Melvin
Morgan
Nelson
Harrison
Marshall
Terrell
Ernest
Francis
Dale
Dean
Desmond
Kelvin
Demetrius
Kendall
Salvador
Josue
Leonard
Gavin
Karl
Glenn
Quinton
Donovan
Franklin
Branden
Skyler
Nolan
Rene
Kaleb
Kody
Jermaine
Dwayne
Diego
Lorenzo
Ernesto
Riley
Eugene
Stanley
Orlando
Brady
Chance
Israel
Jarrod
Jackson
Sebastian
Damon
Damian
Wade
Harold
Fabian
Landon
Zachariah
Giovanni
Ray
Tristan
Alvin
Damien
Zackary
Angelo
Dane
Alexis
Beau
Quentin
Kendrick
Warren
Gilbert
Parker
Gustavo
Stuart
Trey
Clifford
Kirk
Barry
Jordon
Lamar
Kelly
Joey
Pablo
Darnell
Josiah
Rashad
Courtney
Elliott
Eli
Elias
Gage
Antoine
Brad
Alfred
Dante
Stefan
Ashton
Felix
Elliot
Emanuel
Harry
Oliver
Roman
Simon
Clarence
Clint
Dexter
Cedric
Hayden
Jarrett
Tevin
Brennan
Abel
Allan
Ralph
Rudy
Kory
Roderick
Infant
Leon
Keenan
Dallas
Dominick
Noel
Guillermo
Sam
Graham
Lewis
Weston
Blaine
Rodolfo
Julius
Howard
Akeem
Earl
Stephan
Tyson
Wyatt
Saul
Kurtis
Jarred
Derick
Ismael
Esteban
Leonardo
Hugo
Cristian
Bret
Forrest
Jamar
Zackery
Alfonso
Charlie
Donte
Carlton
Corbin
Felipe
Myles
Shannon
Bernard
Kenny
Gilberto
Isiah
Ty
Zane
Jarvis
Emilio
Korey
Rogelio
Leroy
Sheldon
Daryl
Demarcus
Denzel
Clay
Dwight
Coty
Chris
Brendon
Chaz
Tyrell
Terence
Owen
Deangelo
Perry
Carson
Marlon
Kasey
Conor
Neal
Heath
Kameron
Sterling
Glen
Raphael
Skylar
Moises
Fredrick
Brenton
Norman
Gordon
Clifton
Ali
Nikolas
Tucker
Alonzo
Leo
Ramiro
Davon
Wilson
Deshawn
Ariel
Kerry
Shayne
Braden
Chandler
Cornelius
Kent
Vernon
Tomas
Lloyd
Avery
Devan
Frankie
Pierre
Rolando
Jaron
Fred
Jayson
Keegan
Markus
Quincy
Quintin
Rickey
Garret
Mike
Roland
Lonnie
Rick
Rodrigo
Darrin
Rory
Humberto
Ben
Sidney
Tracy
Brenden
Quinn
Jamel
Dorian
Duane
Jean
Nathanael
Mackenzie
Shelby
Dion
Gerard
Lukas
Brice
Darin
Herbert
Cortez
Dana
Antwan
Javon
Kadeem
Clark
Drake
Efrain
Noe
Reynaldo
Freddy
Kristofer
Reid
Donnie
Tylor
Adan
Mauricio
Deon
Jace
Bryson
Carter
Marquise
Don
Jimmie
Everett
Johnnie
Lane
Malik
Ahmad
Arnold
Marcel
Milton
Santiago
Tyree
Guy
Salvatore
Jerrod
Darrius
Kristian
Lamont
Nigel
Kareem
Mitchel
Freddie
Alvaro
Toby
Jakob
Thaddeus
Blair
Bradford
Reuben
Kwame
Leslie
Rico
Moses
Sammy
Vicente
Harley
Will
Stephon
Keaton
Chadwick
Stewart
Winston
Ignacio
Robin
Davis
Joaquin
Aron
Mohammad
Anton
Bo
Griffin
Liam
Issac
Rusty
Amir
Hakeem
Leland
Baby
Guadalupe
Irvin
Jasper
Deonte
German
Gene
Colten
Conrad
Leonel
Nico
Jovan
Kyler
Nestor
Ezekiel
Jackie
Ryne
Agustin
Conner
Loren
Lester
Darian
Lyle
Jarod
Bradly
Herman
Floyd
Garrick
Osvaldo
Rigoberto
Clyde
Dusty
Jeff
Ted
Addison
Vance
Dewayne
Adolfo
Khiry
Nathanial
Sonny
Ashley
Donnell
Jonah
Erin
Reed
Rocky
Kellen
Paris
Dan
Jameson
Jamison
Rex
Cecil
Lionel
Tory
Demario
Nick
Antwon
Grayson
Jamaal
Randolph
Arron
Chester
Bennett
Damion
Jairo
Mohammed
Myron
Wendell
Brooks
Heriberto
Shea
Irving
Bronson
Spenser
Jim
Solomon
Uriel
Jerrell
Elmer
Octavio
Harvey
Jess
Jody
Tom
Aric
Barrett
Otis
Josh
Male
Moshe
Royce
Alton
Austen
Cooper
Daquan
Jefferson
Bryon
Greg
Amos
Aubrey
Benny
Sylvester
Ahmed
Tyron
Braxton
Erich
Cruz
Elvis
Estevan
Randal
Rashawn
Tobias
Dominque
Justen
Kelsey
Scotty
Houston
Deven
Hassan
Dashawn
Derik
Westley
Dontae
Hugh
Mohamed
Unknown
Ron
Duncan
Cristopher
Jamil
Arsenio
Hans
Brandan
Dandre
Santos
Cordell
Ladarius
Robbie
Trever
Ulysses
Vaughn
Jaquan
Holden
Mikel
Ellis
Jessy
Wilfredo
Ezra
Bernardo
Jonas
Morris
Camron
Ezequiel
Galen
Luther
Colt
Efren
Garry
Gonzalo
Raheem
Brant
Darrel
Grady
Niko
Dereck
Edgardo
Maximilian
Jerod
Marty
Pete
Dario
Martez
Kirby
Coleman
Cullen
Gino
Dejuan
Josef
Reece
Teddy
Aldo
Sherman
Benito
Brody
Jacques
Ulises
Asa
Codey
Stevie
Demarco
Donavan
Ervin
Fidel
Gregorio
Virgil
Willis
Alphonso
Brandyn
Jerald
Zechariah
Alonso
Cary
Isaias
Jamarcus
Marques
Stacy
Kolby
Shelton
Darrick
Edmund
Keon
Domingo
Laquan
Mychal
Raymundo
Cedrick
Cyrus
Jade
Junior
Mickey
Alexandro
Antony
Carlo
Claude
Francesco
Ira
Rodrick
Rhett
Dangelo
Darien
Trevon
Walker
August
Louie
Rudolph
Daron
Earnest
Madison
Jerad
Khalil
Roosevelt
Travon
Kiefer
Lincoln
Bennie
Ken
Ari
Carey
Darion
Jerel
Quinten
Deron
Greggory
Ibrahim
Jessica
Jorden
Kenton
Laron
Marquez
Mykel
Rocco
Stacey
Timmy
Malcom
Titus
Van
Dayton
Kevon
Anderson
Jarret
Marion
Zakary
Cade
Daren
Kendal
Pierce
Vince
Aidan
Broderick
Tommie
Chaim
Michel
Payton
Reese
Wallace
Andreas
Axel
Brennen
Derrell
Valentin
Donta
Emerson
Monte
Nikko
Jabari
Jacoby
Kendell
Darwin
Giancarlo
Isidro
Garett
Eddy
Jan
Kegan
Prince
Rashaad
Samson
Abram
Cale
Cassidy
Cristobal
Jered
Remington
Dave
Gregg
Kai
Talon
Cortney
Kelby
Rasheed
Abdul
Codie
Elvin
Laurence
Alexandre
Antione
Britton
Hernan
Jeffry
Kalvin
Najee
Peyton
Rakeem
Reggie
Samir
Wilbert
Alden
Camden
Channing
Chauncey
Julien
Malachi
Mikhail
Tremaine
Tyrel
Derrek
Elisha
Federico
Shay
Cornell
Eliseo
Elton
Emmett
Garrison
Marlin
Martell
Silas
Davin
Dionte
Jedidiah
Justine
Kraig
Marcelo
Ronny
Torrey
Trace
Coby
Donny
Jarrell
Jeremey
Jeromy
Lazaro
Tavon
Deontae
Edwardo
Keenen
Keven
Torey
Bill
Bruno
Genaro
Waylon
Brittany
Eliezer
Jory
Misael
Tate
Deante
