#!/bin/bash
# tex->pdf
echo "converting all tex-files to a gif image:"
for file in *.tex ; do
  STEM=`basename $file .tex`
  echo "convert $file ..." 
  latex $file
  dvips $STEM.dvi
  ps2pdf $STEM.ps 
  magick convert -delay 5 -density 100x100 -alpha remove $STEM.pdf -loop 0 $STEM.gif
  echo "... done $STEM.gif"
done
rm *.aux
rm *.log
rm *.ps
rm *.pdf
rm *.dvi