/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerControl;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;

public class AMQPFederationConsumerControlType
extends AbstractControl
implements AMQPFederationConsumerControl {
    private final AMQPFederationConsumer consumer;
    private final FederationConsumerInfo consumerInfo;

    public AMQPFederationConsumerControlType(AMQPFederationConsumer consumer) throws NotCompliantMBeanException {
        super(AMQPFederationConsumerControl.class, consumer.getFederation().getServer().getStorageManager());
        this.consumer = consumer;
        this.consumerInfo = consumer.getConsumerInfo();
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            long l = this.consumer.getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRole() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRole((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            String string = this.consumerInfo.getRole().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getQueueName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getQueueName((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            String string = this.consumerInfo.getQueueName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            String string = this.consumerInfo.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFqqn() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFqqn((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            String string = this.consumerInfo.getFqqn();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRoutingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingType((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            String string = this.consumerInfo.getRoutingType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFilterString() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFilterString((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            String string = this.consumerInfo.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int getPriority() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPriority((Object)this.consumerInfo);
        }
        this.clearIO();
        try {
            int n = this.consumerInfo.getPriority();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPFederationConsumerControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPFederationConsumerControl.class);
    }
}

